/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.BOFAConstraintChecker;
import com.ibm.dltj.ConstraintDecomposer;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Decomposer;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.ObjectBuffer;
import com.ibm.dltj.ReverseCharacterIterator;
import com.ibm.dltj.UCharacterCategoryMask;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.RBBICategory;
import com.ibm.dltj.util.LowercasingCharacterIterator;
import com.ibm.icu.lang.UCharacter;
import java.text.CharacterIterator;

class UniLexAnalyzerEu
extends UniLexAnalyzer {
    protected Decomposer decomposer;
    UniLexAnalyzer.DictLookupPos dictPos = new UniLexAnalyzer.DictLookupPos();
    static final int STATE_ZERO = 0;
    static final int STATE_AWAIT = 1;
    static final int STATE_HAVE = 2;
    static final int STATE_READY_FOR_LOOKUP = 3;
    static final int STATE_READY_FOR_REGEXP = 4;
    static final int STATE_END = 255;
    int crlf;
    int state;
    int startIndex;
    LowercasingCharacterIterator lwrCseIterator;
    ReverseCharacterIterator lwrCseRevCharIterator;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    protected int decompose(CharacterIterator characterIterator, int n, int n2) {
        int n3 = this.characterIterator.getIndex();
        this.decomposer.reset();
        for (int i = 0; i < this.morphoSyntax.dictionaries.length; ++i) {
            Dictionary dictionary = this.morphoSyntax.dictionaries[i];
            if (dictionary == null) continue;
            this.decomposer.decompose(n, n2, characterIterator, dictionary.fsa);
            this.characterIterator.setIndex(n3);
        }
        this.decomposer.close();
        return this.decomposer.numDecomp();
    }

    UniLexAnalyzerEu(String string) throws DLTException {
        super(string);
        this.decompFlags = 0;
        String string2 = string.substring(0, Math.min(2, string.length())).toLowerCase();
        if (string2.equals("de") || string2.equals("nl") || string2.equals("nb") || string2.equals("nn") || string2.equals("sv") || string2.equals("da") || string2.equals("fi") || string2.equals("ko")) {
            this.decompFlags |= 1;
        }
        this.decomposer = new BOFADecomposer(this);
    }

    public ParsingStream doProcessText(CharacterIterator characterIterator) throws DLTException {
        this.lwrCseIterator = new LowercasingCharacterIterator(this.characterIterator);
        this.lwrCseRevCharIterator = new ReverseCharacterIterator(this.lwrCseIterator);
        this.breakIterator.setText(this.characterIterator);
        this.crlf = 0;
        char c = this.characterIterator.current();
        int n = UCharacter.getType((int)c);
        this.state = 2;
        block13: while (this.state != 255) {
            switch (this.state) {
                case 1: {
                    c = this.characterIterator.current();
                    n = UCharacter.getType((int)c);
                }
                case 2: {
                    int n2;
                    this.state = 1;
                    switch (n) {
                        case 12: {
                            this.characterIterator.next();
                            continue block13;
                        }
                        case 15: 
                        case 16: {
                            if (c != '\r' && c != '\n') {
                                this.characterIterator.next();
                                continue block13;
                            }
                        }
                        case 13: {
                            if (this.crlf == 0) {
                                this.crlf = c;
                            }
                            if (c == this.crlf) {
                                n2 = 1;
                                while (true) {
                                    c = this.characterIterator.next();
                                    if (n2 != 0 && c == this.crlf) {
                                        this.markParagraph(this.characterIterator.getIndex() - 1);
                                        n2 = 0;
                                        continue;
                                    }
                                    n = UCharacter.getType((int)c);
                                    if (c != '\n' && n != 13 && n != 14) break;
                                }
                                if (c == '\uffff') {
                                    this.state = 255;
                                    continue block13;
                                }
                                this.state = 2;
                                continue block13;
                            }
                            this.characterIterator.next();
                            continue block13;
                        }
                        case 14: {
                            this.markParagraph(this.characterIterator.getIndex());
                            this.characterIterator.next();
                            continue block13;
                        }
                        case 0: {
                            if (c != '\uffff') break;
                            this.state = 255;
                            continue block13;
                        }
                    }
                    this.startIndex = this.characterIterator.getIndex();
                    this.dictPos.dictIdx = 0;
                    this.morphoSyntax.matches.clear();
                    this.state = 3;
                }
                case 3: {
                    int n3;
                    int n4;
                    int n2;
                    if (this.dictLookup(this.dictPos)) {
                        n2 = this.morphoSyntax.matches.getMaxIndex();
                        this.characterIterator.setIndex(n2);
                        c = this.characterIterator.current();
                        n = UCharacter.getType((int)c);
                        n4 = UCharacterCategoryMask.UMASK(n);
                        if ((n4 & UCharacterCategoryMask.sp_ctrl) != 0 || c == '\uffff') {
                            this.insertGlosses(this.startIndex);
                            this.state = 2;
                            continue block13;
                        }
                        if ((n4 & UCharacterCategoryMask.alnum) != 0 || c == '-' || c == '\'') {
                            this.characterIterator.setIndex(this.startIndex);
                            if (this.morphoSyntax.cmPolicy == 1 && this.dictPos.dictIdx < this.morphoSyntax.dictionaries.length) {
                                this.state = 3;
                                continue block13;
                            }
                            this.state = 4;
                            continue block13;
                        }
                        if ((n4 & UCharacterCategoryMask.punct) != 0) {
                            n3 = c;
                            c = this.characterIterator.next();
                            n = UCharacter.getType((int)c);
                            n4 = UCharacterCategoryMask.UMASK(n);
                            if ((n4 & UCharacterCategoryMask.sp_ctrl) != 0 && (n3 == 46 || n3 == 63 || n3 == 33)) {
                                this.insertGlosses(this.startIndex);
                                this.insertPunctuation(n2, n2 + 1, 65535, n3);
                                this.state = 2;
                                continue block13;
                            }
                            if (c == '\uffff') {
                                this.insertGlosses(this.startIndex);
                                this.insertPunctuation(n2, n2 + 1, 65535, n3);
                                this.state = 255;
                                continue block13;
                            }
                            this.state = 4;
                            continue block13;
                        }
                        this.insertGlosses(this.startIndex);
                        this.state = 1;
                        continue block13;
                    }
                }
                case 4: {
                    int n3;
                    this.state = 1;
                    this.characterIterator.setIndex(this.startIndex);
                    int n2 = this.breakIterator.next();
                    int n4 = this.breakIterator.getRuleStatus();
                    if (n2 < 0) {
                        this.insertUnknown(this.startIndex, this.startIndex + 1, 0);
                        this.characterIterator.next();
                        continue block13;
                    }
                    if (this.morphoSyntax.matches.getNumMatches() > 0) {
                        n3 = this.morphoSyntax.matches.getMaxIndex();
                        if (n3 == n2 || n3 - n2 == 1 && this.characterIterator.current() == '.') {
                            this.insertGlosses(this.startIndex);
                            this.characterIterator.setIndex(n3);
                            continue block13;
                        }
                        if (n3 > n2) {
                            this.characterIterator.setIndex(this.startIndex);
                            GlossCollection glossCollection = this.morphoSyntax.dictLookupWord(this.characterIterator, n2 - this.startIndex);
                            if (glossCollection != null) {
                                this.insertParsedGloss(this.startIndex, n2, glossCollection);
                                this.characterIterator.setIndex(n2);
                                continue block13;
                            }
                        }
                    }
                    if (RBBICategory.isWord(n4)) {
                        if (this.morphoSyntax.matches.getNumMatches() > 0 && (this.hints & 1) != 0 && this.decompose(this.characterIterator, this.startIndex, n2) > 0) {
                            this.characterIterator.setIndex(n2);
                            continue block13;
                        }
                        if (this.guesser(n4, this.startIndex, n2)) {
                            this.characterIterator.setIndex(n2);
                            continue block13;
                        }
                    }
                    if (RBBICategory.isWordLike(n4)) {
                        if ((this.hints & 2) != 2 && this.isHyphenWord(n4, this.startIndex, n2)) {
                            this.decomposeHypheWord(n4, this.startIndex, n2);
                            this.characterIterator.setIndex(n2);
                            continue block13;
                        }
                        this.insertUnknownWord(this.startIndex, n2, n4);
                        this.characterIterator.setIndex(n2);
                        continue block13;
                    }
                    this.characterIterator.setIndex(n2);
                    if (RBBICategory.isPunctuation(n4)) {
                        this.insertPunctuation(this.startIndex, n2, 65535, c);
                        continue block13;
                    }
                    c = this.characterIterator.current();
                    n = UCharacter.getType((int)c);
                    if (n4 == 205) {
                        n3 = UCharacterCategoryMask.UMASK(n);
                        if (c == '.') {
                            this.insertUnknown(this.startIndex, n2 + 1, n4);
                            this.insertPunctuation(n2, n2 + 1, 32766, c);
                            this.characterIterator.next();
                            continue block13;
                        }
                        this.insertUnknown(this.startIndex, n2, 104);
                        continue block13;
                    }
                    this.insertUnknown(this.startIndex, n2, n4);
                    if (c == '\uffff') {
                        this.state = 255;
                        continue block13;
                    }
                    this.state = 2;
                    continue block13;
                }
            }
            this.state = 1;
            this.characterIterator.next();
        }
        return this.m_pLPS;
    }

    protected int decomposeHypheWord(int n, int n2, int n3) {
        int n4;
        int n5 = this.characterIterator.getIndex();
        int n6 = this.dictPos.dictIdx;
        int n7 = this.startIndex;
        block3: for (n4 = this.startIndex; n4 < n3; ++n4) {
            char c = this.characterIterator.setIndex(n4);
            switch (c) {
                case '-': {
                    this.characterIterator.setIndex(n7);
                    this.dictPos.dictIdx = 0;
                    this.morphoSyntax.dictLookup(this.characterIterator, this.dictPos);
                    int n8 = this.morphoSyntax.matches.getMaxIndex();
                    if (n8 == n4) {
                        this.insertGlosses(n7);
                    } else if (n8 <= 0 || this.decompose(this.characterIterator, n7, n4) <= 0) {
                        this.insertUnknownWord(n7, n4, n);
                    }
                    this.insertPunctuation(n4, n4 + 1, 65535, c);
                    n7 = n4 + 1;
                    this.morphoSyntax.matches.clear();
                    continue block3;
                }
            }
        }
        if (n7 < n3) {
            this.characterIterator.setIndex(n7);
            this.dictPos.dictIdx = 0;
            this.morphoSyntax.dictLookup(this.characterIterator, this.dictPos);
            n4 = this.morphoSyntax.matches.getMaxIndex();
            if (n4 == n3) {
                this.insertGlosses(n7);
            } else if (n4 <= 0 || this.decompose(this.characterIterator, n7, n3) <= 0) {
                this.insertUnknownWord(n7, n3, n);
            }
        }
        this.characterIterator.setIndex(n5);
        this.dictPos.dictIdx = n6;
        this.morphoSyntax.matches.clear();
        return 1;
    }

    private boolean isLetterSequence(CharacterIterator characterIterator, int n, int n2) {
        CharacterIterator characterIterator2 = this.breakIterator.getText();
        this.breakIterator.setText((CharacterIterator)this.lwrCseIterator);
        this.lwrCseIterator.setIndex(n);
        int n3 = this.breakIterator.next();
        int n4 = this.breakIterator.getRuleStatus();
        this.breakIterator.setText(characterIterator2);
        return n3 == n2 && n4 == 201;
    }

    private boolean isHyphenWord(int n, int n2, int n3) {
        if (n == 100 && !this.isLetterSequence(this.characterIterator, n2, n3)) {
            return false;
        }
        int n4 = this.characterIterator.getIndex();
        for (int i = n2; i < n3; ++i) {
            char c = this.characterIterator.setIndex(i);
            switch (c) {
                case '-': {
                    this.characterIterator.setIndex(n4);
                    return true;
                }
            }
        }
        this.characterIterator.setIndex(n4);
        return false;
    }

    private boolean guesser(int n, int n2, int n3) {
        GlossCollection glossCollection;
        if (this.isFirstWordOfSentence() && n == 203) {
            this.lwrCseIterator.setIndex(n2);
            glossCollection = this.morphoSyntax.dictLookupWord(this.lwrCseIterator, n3 - n2);
            if (glossCollection != null) {
                this.insertParsedGloss(n2, n3, glossCollection);
                return true;
            }
        }
        if ((n == 201 || (this.isFirstWordOfSentence() || (1 & this.decompFlags) != 0) && n == 203) && this.morphoSyntax.oov_dictionaries.length > 0 & n3 - n2 > 4) {
            this.lwrCseRevCharIterator.setIndex(n3 - 1);
            glossCollection = this.morphoSyntax.oov_dictLookup(this.lwrCseRevCharIterator, n3);
            if (glossCollection != null) {
                this.insertParsedGloss(n2, n3, glossCollection);
                return true;
            }
        }
        return false;
    }

    protected static class BOFADecomposer
    extends ConstraintDecomposer {
        private UniLexAnalyzerEu owner;
        private static final BOFAConstraintChecker CHECKER = new BOFAConstraintChecker();
        private MultiNet pNet;
        protected final ObjectBuffer storedDecompositionBuffer = new ObjectBuffer();

        BOFADecomposer(UniLexAnalyzerEu uniLexAnalyzerEu) {
            this.owner = uniLexAnalyzerEu;
        }

        public void reset() {
            super.reset();
            this.storedDecompositionBuffer.clear();
        }

        public void decompose(int n, int n2, CharacterIterator characterIterator, MultiNet multiNet) {
            this.pNet = multiNet;
            super.decompose(n, n2, characterIterator, CHECKER);
        }

        protected void lookup() {
            this.pNet.traverse(this.pItr, this.match_buffer);
        }

        private void flushFirstSavedDecomposition(boolean bl) {
            Decomposer.Component component;
            Decomposer.Component component2 = component = (Decomposer.Component)this.storedDecompositionBuffer.getFirst();
            while (component2.next != null) {
                component2 = component2.next;
            }
            this.owner.startDecompGroup(component.start, component2.end);
            if (bl) {
                this.owner.fork();
            }
            while (component != null) {
                this.owner.insertDecompElement(component.start, component.end, (GlossCollection)component.element);
                component = component.next;
            }
        }

        public void store_sequence(int n, int n2, Decomposer.Component component, int n3) {
            if (n3 == 0) {
                Decomposer.Component component2 = (Decomposer.Component)this.storedDecompositionBuffer.get(0);
                if (component2 == null) {
                    component2 = new Decomposer.Component();
                }
                this.storedDecompositionBuffer.add(component2);
                int n4 = 0;
                while (component != null) {
                    component2.element = component.element;
                    component2.start = component.start;
                    component2.end = component.end;
                    if (component.next != null) {
                        component2.next = (Decomposer.Component)this.storedDecompositionBuffer.get(++n4);
                        if (component2.next == null) {
                            component2.next = new Decomposer.Component();
                        }
                        this.storedDecompositionBuffer.add(component2.next);
                        component2 = component2.next;
                    } else {
                        component2.next = null;
                    }
                    component = component.next;
                }
                return;
            }
            if (n3 == 1) {
                this.flushFirstSavedDecomposition(true);
            }
            if (n3 >= 1) {
                this.owner.addToFork();
            }
            while (component != null) {
                this.owner.insertDecompElement(component.start, component.end, (GlossCollection)component.element);
                component = component.next;
            }
        }

        public int numDecomp() {
            return this.num_decomp;
        }

        public void close() {
            if (this.num_decomp == 1) {
                this.flushFirstSavedDecomposition(false);
            }
            if (this.num_decomp > 0) {
                this.owner.closeDecompGroup(this.num_decomp);
            }
        }
    }
}

