/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.LanguageGuess;
import com.ibm.dltj.ReverseCharacterIterator;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerEu;
import com.ibm.dltj.gloss.CatNameGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GlossPool;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.MidGloss;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

final class UniLexAnalyzerC
extends UniLexAnalyzerEu {
    private static final int CONF_THRES_TABLE = 1;
    private static final int NORM_FACTOR_TABLE = 2;
    int matchCondition;
    ReverseCharacterIterator revCharacterIterator;
    boolean logResults = false;
    boolean doUnk = true;
    int tieDelta = -1;
    StringBuffer logsb;
    TreeMap lmap;
    int unkCTLvotes;
    int unkSTLvotes;
    TreeMap confThresTable = null;
    TreeMap normFactorTable = null;
    int tokenCount = 1;
    boolean doDebug = true;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$CatNameGloss;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$IntegerGloss;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    int getTieDelta() {
        return this.tieDelta;
    }

    void setTieDelta(int n) {
        this.tieDelta = n;
    }

    void doUnknown(boolean bl) {
        this.doUnk = bl;
    }

    int getConfidenceThreshold(String string) {
        if (this.lmap.containsKey(string)) {
            LanguageGuess languageGuess = (LanguageGuess)this.lmap.get(string);
            return languageGuess.getConfThres();
        }
        return -1;
    }

    int setConfidenceThreshold(String string, int n) {
        if (this.lmap.containsKey(string)) {
            LanguageGuess languageGuess = (LanguageGuess)this.lmap.get(string);
            int n2 = languageGuess.getConfThres();
            languageGuess.setConfThres(n);
            return n2;
        }
        return -1;
    }

    int getNormFactor(String string) {
        if (this.lmap.containsKey(string)) {
            LanguageGuess languageGuess = (LanguageGuess)this.lmap.get(string);
            return languageGuess.getNormFactor();
        }
        return -1;
    }

    int setNormFactor(String string, int n) {
        if (this.lmap.containsKey(string)) {
            LanguageGuess languageGuess = (LanguageGuess)this.lmap.get(string);
            int n2 = languageGuess.getNormFactor();
            languageGuess.setConfThres(n);
            return n2;
        }
        return -1;
    }

    public void setRevCharacterIterator(CharacterIterator characterIterator) {
        this.revCharacterIterator = new ReverseCharacterIterator(characterIterator);
    }

    UniLexAnalyzerC(String string) throws DLTException {
        super(string);
    }

    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        super.open(dictionaryArray, n, n2, n3);
        this.lmap = new TreeMap();
        for (int i = 0; i < this.morphoSyntax.dictionaries.length; ++i) {
            Dictionary dictionary = this.morphoSyntax.dictionaries[i];
            GlossPool glossPool = dictionary.pools[19];
            if (glossPool == null) continue;
            Hashtable hashtable = glossPool.glossHash;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                CatNameGloss catNameGloss = (CatNameGloss)enumeration.nextElement();
                LanguageGuess languageGuess = new LanguageGuess(catNameGloss.value, 0, 0);
                this.lmap.put(languageGuess.getLanguage(), languageGuess);
            }
        }
        this.loadTable(1);
        this.loadTable(2);
        String string = System.getProperty("dlt.log.doOutput");
        if (string != null && string.length() != 0) {
            this.logResults = true;
            this.logsb = new StringBuffer(256);
        }
    }

    private int loadTable(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "jfrost_confThres4Lang";
                break;
            }
            case 2: {
                string = "jfrost_NormFactor4Lang";
                break;
            }
            default: {
                return -1;
            }
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        for (int i = 0; i < this.morphoSyntax.dictionaries.length; ++i) {
            this.morphoSyntax.matches.clear();
            this.morphoSyntax.dictionaries[i].lookupLongest(stringCharacterIterator, this.morphoSyntax.matches);
            int[] nArray = this.morphoSyntax.matches.index;
            Object[] objectArray = this.morphoSyntax.matches.gloss;
            if (this.morphoSyntax.matches.getMaxIndex() == stringCharacterIterator.getEndIndex()) {
                GlossCollection glossCollection = (GlossCollection)objectArray[this.morphoSyntax.matches.mpos - 1];
                GlossListElement glossListElement = glossCollection.first;
                while (glossListElement != null) {
                    Gloss gloss = glossListElement.gloss;
                    if (gloss instanceof MidGloss) {
                        CatNameGloss catNameGloss = (CatNameGloss)((MidGloss)gloss).getGloss(class$com$ibm$dltj$gloss$CatNameGloss == null ? UniLexAnalyzerC.class$("com.ibm.dltj.gloss.CatNameGloss") : class$com$ibm$dltj$gloss$CatNameGloss);
                        IntegerGloss integerGloss = (IntegerGloss)((MidGloss)gloss).getGloss(class$com$ibm$dltj$gloss$IntegerGloss == null ? UniLexAnalyzerC.class$("com.ibm.dltj.gloss.IntegerGloss") : class$com$ibm$dltj$gloss$IntegerGloss);
                        LanguageGuess languageGuess = (LanguageGuess)this.lmap.get(catNameGloss.value);
                        if (n == 1) {
                            languageGuess.setConfThres(integerGloss.weight);
                        } else if (n == 2) {
                            languageGuess.setNormFactor(integerGloss.weight);
                        }
                    }
                    glossListElement = glossListElement.next;
                }
                continue;
            }
            return 0;
        }
        this.morphoSyntax.matches.clear();
        return 1;
    }

    private void loadDefConfTable() {
        Collection collection = this.lmap.values();
        Iterator iterator = collection.iterator();
        IntegerGloss integerGloss = new IntegerGloss();
        while (iterator.hasNext()) {
            LanguageGuess languageGuess = (LanguageGuess)iterator.next();
            this.confThresTable.put(languageGuess.getLanguage(), integerGloss);
        }
    }

    private void loadDefNormTable() {
        Collection collection = this.lmap.values();
        Iterator iterator = collection.iterator();
        IntegerGloss integerGloss = new IntegerGloss();
        while (iterator.hasNext()) {
            LanguageGuess languageGuess = (LanguageGuess)iterator.next();
            this.normFactorTable.put(languageGuess.getLanguage(), integerGloss);
        }
    }

    public void reset() {
        Collection collection = this.lmap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            LanguageGuess languageGuess = (LanguageGuess)iterator.next();
            languageGuess.setScore(0L);
        }
    }

    public void close() throws DLTException {
        this.lmap.clear();
        super.close();
    }

    protected int reverseDictLookup(UniLexAnalyzer.DictLookupPos dictLookupPos) {
        int n = this.revCharacterIterator.getIndex();
        while (dictLookupPos.dictIdx < this.morphoSyntax.dictionaries.length) {
            this.revCharacterIterator.setIndex(n);
            int n2 = this.morphoSyntax.matches.getNumMatches();
            this.morphoSyntax.dictionaries[dictLookupPos.dictIdx].lookupLongestReversed(this.revCharacterIterator, this.morphoSyntax.matches);
            if (this.morphoSyntax.matches.getNumMatches() != 0 && this.morphoSyntax.cmPolicy == 1) {
                ++dictLookupPos.dictIdx;
                break;
            }
            ++dictLookupPos.dictIdx;
        }
        return this.morphoSyntax.matches.getNumMatches();
    }

    protected final void insertUnknown(int n, int n2, int n3) {
        ++this.tokenCount;
        if (this.doDebug) {
            // empty if block
        }
        if (n3 < 300 || n3 > 330) {
            ++this.unkSTLvotes;
        } else {
            ++this.unkCTLvotes;
        }
        if (this.morphoSyntax.matches.mpos > 0) {
            this.matchCondition = 2;
            super.insertGlosses(n);
            this.matchCondition = 0;
        } else {
            this.dictPos.dictIdx = 0;
            this.morphoSyntax.matches.clear();
            this.morphoSyntax.matches.setMaxIndex(Integer.MAX_VALUE);
            this.revCharacterIterator.setIndex(n2 - 1);
            if (this.reverseDictLookup(this.dictPos) > 0) {
                this.matchCondition = 8;
                if (this.startIndex < this.morphoSyntax.matches.index[this.morphoSyntax.matches.mpos - 1]) {
                    super.insertGlosses(this.startIndex);
                }
                this.matchCondition = 0;
            }
            this.characterIterator.setIndex(n2);
        }
    }

    protected final void insertUnknownWord(int n, int n2, int n3) {
        ++this.tokenCount;
        if (this.doDebug) {
            // empty if block
        }
        if (n3 == 303) {
            ++this.unkCTLvotes;
        } else {
            ++this.unkSTLvotes;
        }
        if (this.morphoSyntax.matches.mpos > 0) {
            this.matchCondition = 2;
            super.insertGlosses(n);
            this.matchCondition = 0;
        } else {
            this.dictPos.dictIdx = 0;
            this.morphoSyntax.matches.clear();
            this.morphoSyntax.matches.setMaxIndex(Integer.MAX_VALUE);
            this.revCharacterIterator.setIndex(n2 - 1);
            if (this.reverseDictLookup(this.dictPos) > 0) {
                this.matchCondition = 8;
                if (this.startIndex < this.morphoSyntax.matches.index[this.morphoSyntax.matches.mpos - 1]) {
                    super.insertGlosses(this.startIndex);
                }
                this.matchCondition = 0;
            }
            this.characterIterator.setIndex(n2);
        }
    }

    protected void insertGlosses(int n) {
        ++this.tokenCount;
        if (this.morphoSyntax.cmPolicy == 1 || this.morphoSyntax.matches.mpos <= 1) {
            int n2 = this.morphoSyntax.matches.mpos - 1;
            int n3 = this.morphoSyntax.matches.index[n2];
            this.insertParsedGloss(n, n3, (GlossCollection)this.morphoSyntax.matches.gloss[n2]);
        } else {
            --this.morphoSyntax.matches.mpos;
            int n4 = this.morphoSyntax.matches.index[this.morphoSyntax.matches.mpos];
            this.insertParsedGloss(n, n4, this.collectGlosses(n4));
        }
    }

    protected final void insertParsedGloss(int n, int n2, GlossCollection glossCollection) {
        if (this.matchCondition == 0) {
            this.matchCondition = 1;
        }
        this.processMatches(n, n2, glossCollection);
        this.matchCondition = 0;
        if (this.doDebug) {
            this.m_pLPS.createStd(65535, n, n2, glossCollection);
        }
    }

    private final void processMatches(int n, int n2, GlossCollection glossCollection) {
        if (this.logResults) {
            int n3 = this.characterIterator.getIndex();
            this.characterIterator.setIndex(n > n2 ? n2 : n);
            this.memcpy(this.logsb, this.characterIterator, n < n2 ? n2 - n : n - n2);
            this.characterIterator.setIndex(n3);
        }
        GlossListElement glossListElement = glossCollection.first;
        while (glossListElement != null) {
            FeatureSetGloss featureSetGloss;
            Gloss gloss = glossListElement.gloss;
            if (gloss instanceof MidGloss && (featureSetGloss = ((MidGloss)gloss).getFeatureGloss()) != null) {
                int n4 = featureSetGloss.getBOFA();
                if (this.matchCondition != 0 && 0 != (n4 & this.matchCondition)) {
                    CatNameGloss catNameGloss = (CatNameGloss)((MidGloss)gloss).getGloss(class$com$ibm$dltj$gloss$CatNameGloss == null ? UniLexAnalyzerC.class$("com.ibm.dltj.gloss.CatNameGloss") : class$com$ibm$dltj$gloss$CatNameGloss);
                    IntegerGloss integerGloss = (IntegerGloss)((MidGloss)gloss).getGloss(class$com$ibm$dltj$gloss$IntegerGloss == null ? UniLexAnalyzerC.class$("com.ibm.dltj.gloss.IntegerGloss") : class$com$ibm$dltj$gloss$IntegerGloss);
                    if (catNameGloss != null && integerGloss != null) {
                        LanguageGuess languageGuess = (LanguageGuess)this.lmap.get(catNameGloss.value);
                        languageGuess.setScore(languageGuess.getScore() + (long)integerGloss.weight);
                        if (this.logResults) {
                            this.logsb.append("(" + catNameGloss.value + "," + integerGloss.weight + ")");
                        }
                    }
                }
            }
            glossListElement = glossListElement.next;
        }
        if (this.logResults) {
            if (this.logsb.length() > (n2 > n ? n2 - n : n - n2)) {
                System.out.println(this.logsb.toString());
            }
            this.logsb.delete(0, this.logsb.length());
        }
    }

    private final void memcpy(StringBuffer stringBuffer, CharacterIterator characterIterator, int n) {
        if (n-- > 0) {
            stringBuffer.append(characterIterator.current());
        }
        while (n-- > 0) {
            stringBuffer.append(characterIterator.next());
        }
    }

    LanguageGuess[] getClassificationResult() {
        int n;
        LanguageGuess[] languageGuessArray = null;
        LanguageGuess languageGuess = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Collection collection = this.lmap.values();
        TreeSet treeSet = new TreeSet();
        TreeSet<LanguageGuess> treeSet2 = new TreeSet<LanguageGuess>();
        treeSet.addAll(collection);
        int n2 = treeSet.size();
        Iterator iterator = treeSet.iterator();
        if (!this.doUnk) {
            n = 0;
            while (iterator.hasNext() && (languageGuess = (LanguageGuess)iterator.next()).getScore() != 0L) {
                treeSet2.add(languageGuess);
                ++n;
            }
            if (treeSet2.size() == 0) {
                languageGuess = new LanguageGuess("STL", 0, 1);
                languageGuessArray = new LanguageGuess[]{languageGuess};
                this.tokenCount = 1;
                return languageGuessArray;
            }
        } else {
            Iterator iterator2 = treeSet.iterator();
            while (iterator2.hasNext() && (languageGuess = (LanguageGuess)iterator2.next()).getScore() != 0L) {
                if (!languageGuess.isConfident4Tokens(this.tokenCount)) continue;
                treeSet2.add(languageGuess);
            }
            if (treeSet2.size() == 0) {
                languageGuessArray = new LanguageGuess[]{this.unkCTLvotes > this.unkSTLvotes ? (languageGuess = new LanguageGuess("CTL", this.unkCTLvotes, 1)) : (languageGuess = new LanguageGuess("STL", this.unkSTLvotes, 1))};
                this.tokenCount = 1;
                return languageGuessArray;
            }
        }
        if ((n = treeSet2.size()) > 0) {
            long l;
            long l2;
            double d;
            Iterator iterator3 = treeSet2.iterator();
            languageGuessArray = new LanguageGuess[n];
            int n3 = 0;
            while (iterator3.hasNext()) {
                languageGuessArray[n3] = languageGuess = (LanguageGuess)iterator3.next();
                ++n3;
            }
            languageGuessArray[0].setConfidence(1);
            if (this.tieDelta != -1 && n > 1 && (d = (double)((l2 = languageGuessArray[0].getNormalizedScore()) - (l = languageGuessArray[1].getNormalizedScore())) / (double)l * 100.0) < (double)this.tieDelta) {
                languageGuessArray[1].setConfidence(1);
            }
        }
        this.tokenCount = 1;
        return languageGuessArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

