/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.MWDecorator;
import com.ibm.dltj.Messages;
import com.ibm.dltj.ReverseCharacterIterator;
import com.ibm.dltj.Session;
import com.ibm.dltj.UniLexAnalyzerC;
import com.ibm.dltj.UniLexAnalyzerConstants;
import com.ibm.dltj.UniLexAnalyzerEn;
import com.ibm.dltj.UniLexAnalyzerEu;
import com.ibm.dltj.UniLexAnalyzerFi;
import com.ibm.dltj.UniLexAnalyzerJa;
import com.ibm.dltj.UniLexAnalyzerZh;
import com.ibm.dltj.UniMorphoSyntax;
import com.ibm.dltj.data.BreakIteratorManager;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.text.CharacterIterator;

public abstract class UniLexAnalyzer
implements UniLexAnalyzerConstants {
    private String localeStr = null;
    protected boolean inSentence;
    protected boolean isFirstWord = true;
    UniMorphoSyntax morphoSyntax = null;
    CharacterIterator characterIterator = null;
    RuleBasedBreakIterator breakIterator;
    public Session parentSession = null;
    ParsingStream m_pLPS;
    int hints;
    int flagSpec;
    protected static final int DECOMP_LIKE_GERMAN = 1;
    protected int decompFlags;
    private int decompGroupN;
    protected static final char SEPARATOR_HYPHEN = '-';
    protected final BreakIteratorManager breakIteratorManager = new BreakIteratorManager();

    public CharacterIterator getSourceText() {
        return this.characterIterator != null ? (CharacterIterator)this.characterIterator.clone() : null;
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public ParsingStream getParsingStream() {
        return this.m_pLPS;
    }

    protected UniLexAnalyzer(String string) throws DLTException {
        this(string, string);
    }

    protected RuleBasedBreakIterator constructBreakIterator(String string) throws DLTException {
        return this.breakIteratorManager.constructBreakIterator(string);
    }

    protected UniLexAnalyzer(String string, String string2) throws DLTException {
        this.morphoSyntax = UniMorphoSyntax.getMorphoSyntax(string, string2);
        this.localeStr = string2;
    }

    public void setBreakIteratorByLocaleString(String string) throws DLTException {
        this.breakIterator = this.constructBreakIterator(string);
    }

    public void setBreakIteratorByFilename(String string) throws DLTException {
        this.breakIteratorManager.setConstrMethod(1);
        this.breakIterator = this.constructBreakIterator(string);
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3) throws DLTException {
        this.morphoSyntax.setDictionaries(dictionaryArray, dictionaryArray2, dictionaryArray3);
    }

    public void open(Dictionary[] dictionaryArray) throws DLTException {
        this.open(dictionaryArray, 0, 1, 0);
    }

    public void open(Dictionary[] dictionaryArray, int n) throws DLTException {
        this.open(dictionaryArray, n, 1, 0);
    }

    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        if (this.breakIterator == null) {
            this.breakIterator = this.constructBreakIterator(this.localeStr);
        }
        this.hints = n2;
        this.flagSpec = n3;
        this.morphoSyntax.open(dictionaryArray, n);
    }

    public void open(int n, int n2, int n3) throws DLTException {
        if (this.breakIterator == null) {
            this.breakIterator = this.constructBreakIterator(this.localeStr);
        }
        this.hints = n2;
        this.flagSpec = n3;
        this.morphoSyntax.open(n);
    }

    public void close() throws DLTException {
        this.morphoSyntax.close();
    }

    boolean dictLookup(DictLookupPos dictLookupPos) {
        return this.morphoSyntax.dictLookup(this.characterIterator, dictLookupPos);
    }

    Object oovdictLookup(ReverseCharacterIterator reverseCharacterIterator, int n) {
        return this.morphoSyntax.oov_dictLookup(reverseCharacterIterator, n);
    }

    protected final void markSentence(int n, int n2) {
        this.m_pLPS.createBreakpoint(n2, n, 2);
        this.inSentence = false;
        this.isFirstWord = true;
    }

    protected final void markParagraph(int n) {
        if (this.inSentence) {
            this.markSentence(n, 65535);
        }
        this.m_pLPS.createBreakpoint(65535, n, 1);
        this.isFirstWord = true;
    }

    String text(int n, int n2) {
        String string = new String();
        int n3 = this.characterIterator.getIndex();
        this.characterIterator.setIndex(n);
        while (n < n2) {
            string = string + this.characterIterator.current();
            this.characterIterator.next();
            ++n;
        }
        this.characterIterator.setIndex(n3);
        return string;
    }

    protected void insertParsedGloss(int n, int n2, GlossCollection glossCollection) {
        this.inSentence = true;
        this.m_pLPS.createStd(65535, n, n2, glossCollection);
        if (this.isFirstWord) {
            this.isFirstWord = false;
        }
    }

    protected void insertGlosses(int n) {
        int[] nArray = this.morphoSyntax.matches.index;
        Object[] objectArray = this.morphoSyntax.matches.gloss;
        int n2 = this.morphoSyntax.matches.getMaxIndex();
        if (this.morphoSyntax.cmPolicy == 1 || this.morphoSyntax.matches.getNumMatches() == 1) {
            if (n >= n2) {
                throw new IllegalArgumentException(Messages.getString("error.entryposition"));
            }
            this.insertParsedGloss(n, n2, (GlossCollection)objectArray[0]);
        } else {
            this.insertParsedGloss(n, n2, this.collectGlosses(n2));
        }
    }

    protected GlossCollection collectGlosses(int n) {
        int[] nArray = this.morphoSyntax.matches.index;
        Object[] objectArray = this.morphoSyntax.matches.gloss;
        if (this.morphoSyntax.matches.mpos == 0 || nArray[this.morphoSyntax.matches.mpos - 1] != n) {
            return (GlossCollection)objectArray[this.morphoSyntax.matches.mpos];
        }
        GlossCollection glossCollection = new GlossCollection();
        for (int i = this.morphoSyntax.matches.mpos - 1; i >= 0 && nArray[i] == n; --i) {
            glossCollection.addAll((GlossCollection)objectArray[i]);
        }
        return glossCollection;
    }

    protected void insertPunctuation(int n, int n2, int n3, int n4) {
        this.m_pLPS.createPunctuation(n3, n, n2, 1);
        if (n3 >= 32768 && UniLexAnalyzer.isEndOfSentenceSymbol(n4) && this.inSentence) {
            this.markSentence(n2, n3);
        }
    }

    static boolean isEndOfSentenceSymbol(int n) {
        switch (n) {
            case 33: 
            case 46: 
            case 63: 
            case 12290: 
            case 65281: 
            case 65294: 
            case 65311: 
            case 65377: {
                return true;
            }
        }
        return false;
    }

    protected boolean isFirstWordOfSentence() {
        return this.isFirstWord;
    }

    protected void insertUnknown(int n, int n2, int n3) {
        this.m_pLPS.createUnknown(65535, n, n2, n3);
        if (this.isFirstWord) {
            this.isFirstWord = false;
        }
    }

    protected void insertUnknownWord(int n, int n2, int n3) {
        this.m_pLPS.createUnknown(65535, n, n2, n3);
        this.inSentence = true;
        if (this.isFirstWord) {
            this.isFirstWord = false;
        }
    }

    protected void insertDecompElement(int n, int n2, GlossCollection glossCollection) {
        this.insertParsedGloss(n, n2, glossCollection);
    }

    protected void fork() {
        this.m_pLPS.fork();
    }

    protected void addToFork() {
        this.m_pLPS.addToFork();
    }

    protected void startDecompGroup(int n, int n2) {
        if ((1 & this.decompFlags) != 0) {
            this.decompGroupN = this.m_pLPS.startGroup(n, n2, 1);
        }
    }

    protected void closeDecompGroup(int n) {
        if (n > 0) {
            this.m_pLPS.mergeRoutes(n);
        }
        if ((1 & this.decompFlags) != 0) {
            this.m_pLPS.closeGroup(this.decompGroupN);
        }
    }

    abstract ParsingStream doProcessText(CharacterIterator var1) throws DLTException;

    public static UniLexAnalyzer getUniLexAnalyzer(String string) throws DLTException {
        String string2 = string.toLowerCase();
        if (string2.equals("c")) {
            return new UniLexAnalyzerC(string);
        }
        if (string2.startsWith("en")) {
            return new UniLexAnalyzerEn(string);
        }
        if (string2.startsWith("zh")) {
            return new UniLexAnalyzerZh(string);
        }
        if (string2.startsWith("ja")) {
            return new UniLexAnalyzerJa(string);
        }
        if (string2.startsWith("fi")) {
            return new UniLexAnalyzerFi(string);
        }
        return new UniLexAnalyzerEu(string);
    }

    public ParsingStream processTextMW(CharacterIterator characterIterator, ParsingStream parsingStream) throws DLTException {
        if (parsingStream instanceof MWUParsingStream && this.morphoSyntax.mw_dictionaries != null && this.morphoSyntax.mw_dictionaries.length > 0) {
            return this.processText(characterIterator, new MWDecorator(this.morphoSyntax.mw_dictionaries, parsingStream));
        }
        return this.processText(characterIterator, parsingStream);
    }

    public ParsingStream processText(CharacterIterator characterIterator, ParsingStream parsingStream) throws DLTException {
        this.characterIterator = characterIterator;
        this.m_pLPS = parsingStream;
        if (this.m_pLPS != null) {
            this.m_pLPS.reset(this);
        }
        this.doProcessText(characterIterator);
        this.markParagraph(this.characterIterator.getIndex());
        if (this.m_pLPS != null) {
            this.m_pLPS.close();
        }
        return parsingStream;
    }

    public static final void memcpy(StringBuffer stringBuffer, CharacterIterator characterIterator, int n, int n2) {
        stringBuffer.setLength(0);
        int n3 = characterIterator.getIndex();
        int n4 = characterIterator.getEndIndex();
        if (n4 < n2) {
            n2 = n4;
        }
        characterIterator.setIndex(n);
        while (characterIterator.getIndex() != n2) {
            stringBuffer.append(characterIterator.current());
            characterIterator.next();
        }
        characterIterator.setIndex(n3);
    }

    static class DictLookupPos {
        int dictIdx;

        DictLookupPos() {
        }
    }
}

