/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Messages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class UniDictionaryManager {
    private HashMap allUsedDicts = new HashMap(17);
    static Dictionary[] EMPTY_DICT_ARRAY = new Dictionary[0];
    Dictionary[] dictionaries = EMPTY_DICT_ARRAY;
    Dictionary[] oov_dictionaries = EMPTY_DICT_ARRAY;
    Dictionary[] mw_dictionaries = EMPTY_DICT_ARRAY;
    Dictionary[] tcr_dictionaries = EMPTY_DICT_ARRAY;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public void setDictionaries(Dictionary[] dictionaryArray) throws DLTException {
        if (dictionaryArray != null) {
            for (int i = 0; i < dictionaryArray.length; ++i) {
                if (dictionaryArray[i] == null) {
                    throw new DLTException(Messages.format("dict.ref.null", i));
                }
                if (dictionaryArray[i].valid()) continue;
                throw new DLTException(Messages.format("invalid.dict1", dictionaryArray[i].getFile().getAbsolutePath()));
            }
            this.dictionaries = dictionaryArray;
        }
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3) throws DLTException {
        int n;
        this.setDictionaries(dictionaryArray);
        if (dictionaryArray2 != null) {
            for (n = 0; n < dictionaryArray2.length; ++n) {
                if (dictionaryArray2[n] != null && dictionaryArray2[n].valid()) continue;
                throw new DLTException(Messages.getString("invalid.OOVdict"));
            }
            this.oov_dictionaries = dictionaryArray2;
        }
        if (dictionaryArray3 != null) {
            for (n = 0; n < dictionaryArray3.length; ++n) {
                if (dictionaryArray3[n] != null && dictionaryArray3[n].valid()) continue;
                throw new DLTException(Messages.getString("invalid.MWdict"));
            }
            this.mw_dictionaries = dictionaryArray3;
        }
    }

    public void setDictionaries(Dictionary[] dictionaryArray, Dictionary[] dictionaryArray2, Dictionary[] dictionaryArray3, Dictionary[] dictionaryArray4) throws DLTException {
        this.setDictionaries(dictionaryArray, dictionaryArray2, dictionaryArray4);
        if (dictionaryArray3 != null) {
            for (int i = 0; i < dictionaryArray.length; ++i) {
                if (dictionaryArray[i] == null) {
                    throw new DLTException(Messages.format("dict.ref.null", i));
                }
                if (dictionaryArray[i].valid()) continue;
                throw new DLTException(Messages.format("invalid.dict1", dictionaryArray[i].getFile().getAbsolutePath()));
            }
            this.tcr_dictionaries = dictionaryArray3;
        }
    }

    public void close() throws DLTException {
        this.unlockReadDictionaries();
        this.dictionaries = EMPTY_DICT_ARRAY;
        this.oov_dictionaries = EMPTY_DICT_ARRAY;
        this.mw_dictionaries = EMPTY_DICT_ARRAY;
        this.tcr_dictionaries = EMPTY_DICT_ARRAY;
        this.allUsedDicts.clear();
    }

    void lockReadDictionaries() throws DLTException {
        Object v;
        Dictionary dictionary;
        int n;
        this.allUsedDicts.clear();
        if (this.dictionaries != null) {
            for (n = 0; n < this.dictionaries.length; ++n) {
                dictionary = this.dictionaries[n];
                v = this.allUsedDicts.get(dictionary);
                if (v != null) continue;
                this.allUsedDicts.put(dictionary, dictionary);
                dictionary.lockRead();
            }
        }
        if (this.oov_dictionaries != null) {
            for (n = 0; n < this.oov_dictionaries.length; ++n) {
                dictionary = this.oov_dictionaries[n];
                v = this.allUsedDicts.get(dictionary);
                if (v != null) continue;
                this.allUsedDicts.put(dictionary, dictionary);
                dictionary.lockRead();
            }
        }
        if (this.tcr_dictionaries != null) {
            for (n = 0; n < this.tcr_dictionaries.length; ++n) {
                dictionary = this.tcr_dictionaries[n];
                v = this.allUsedDicts.get(dictionary);
                if (v != null) continue;
                this.allUsedDicts.put(dictionary, dictionary);
                dictionary.lockRead();
            }
        }
        if (this.mw_dictionaries != null) {
            for (n = 0; n < this.mw_dictionaries.length; ++n) {
                dictionary = this.mw_dictionaries[n];
                v = this.allUsedDicts.get(dictionary);
                if (v != null) continue;
                this.allUsedDicts.put(dictionary, dictionary);
                dictionary.lockRead();
            }
        }
    }

    void unlockReadDictionaries() throws DLTException {
        Iterator iterator = this.allUsedDicts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Dictionary dictionary = (Dictionary)entry.getValue();
            dictionary.unlockRead();
        }
    }
}

