/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.MisspeltWord;
import com.ibm.dltj.Session;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniLexAnalyzerDeReform;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.LangNameGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.ParsingStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SpellCheckerSession
extends Session {
    private Dictionary[] dicts;
    private Dictionary addenda;
    private Dictionary ignored;
    public String currentLanguage;
    private static Gloss ignoreGloss;
    private static Gloss ignoreTag;
    private static Gloss ignoreMset;
    private static Gloss addendaGloss;
    public static final String ignoredWordsTagPrefix = "ignored_";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public SpellCheckerSession(Dictionary[] dictionaryArray, int n, String string) throws DLTException {
        super(string);
        if (string == null) {
            throw new DLTException(Messages.getString("null.language"));
        }
        if (dictionaryArray == null) {
            throw new DLTException(Messages.getString("null.array"));
        }
        this.currentLanguage = string.toLowerCase();
        if (this.currentLanguage.startsWith("de") && this.currentLanguage.indexOf("reform") > 0) {
            this.uan = new UniLexAnalyzerDeReform(string);
        }
        this.dicts = new Dictionary[dictionaryArray.length + 1];
        System.arraycopy(dictionaryArray, 0, this.dicts, 0, dictionaryArray.length);
        this.addenda = this.dicts[n];
        addendaGloss = this.addenda.addFeatureSetGloss(0, 1, false, false, true, true);
        String string2 = ignoredWordsTagPrefix + string + "_tokens";
        this.ignored = new Dictionary(null, 84083200, 1);
        this.ignored.registerType(15, string2);
        this.ignored.registerType(16, string2);
        this.ignored.registerType(1, string2);
        this.dicts[this.dicts.length - 1] = this.ignored;
        ignoreGloss = this.ignored.addFeatureSetGloss(0, 1, false, false, true, false);
        ignoreTag = this.ignored.addLanguageGloss(string2, 0);
        ignoreMset = this.ignored.addMorphGloss(new Gloss[]{ignoreGloss, ignoreTag});
    }

    public SpellCheckerSession(Dictionary[] dictionaryArray, String string) throws DLTException {
        super(string);
        if (string == null) {
            throw new DLTException(Messages.getString("null.language"));
        }
        if (dictionaryArray == null) {
            throw new DLTException(Messages.getString("null.array"));
        }
        this.currentLanguage = string.toLowerCase();
        if (this.currentLanguage.startsWith("de") && this.currentLanguage.indexOf("reform") > 0) {
            this.uan = new UniLexAnalyzerDeReform(string);
        }
        this.dicts = new Dictionary[dictionaryArray.length];
        System.arraycopy(dictionaryArray, 0, this.dicts, 0, dictionaryArray.length);
        this.addenda = null;
        Object var3_3 = null;
        this.ignored = null;
    }

    public SpellCheckerSession(String string) throws DLTException {
        super(string);
        String string2 = string.toLowerCase();
        if (string2.startsWith("de") && string2.indexOf("reform") > 0) {
            this.uan = new UniLexAnalyzerDeReform(string);
        }
    }

    public synchronized void open() throws DLTException {
        super.open(this.dicts, 0, 1, 0, 1);
    }

    public List checkSpelling(String string) throws DLTException {
        return this.checkSpelling(new StringCharacterIterator(string));
    }

    public synchronized List checkSpelling(CharacterIterator characterIterator) throws DLTException {
        SpellParsingStream spellParsingStream = new SpellParsingStream();
        super.processText(characterIterator, spellParsingStream);
        return spellParsingStream.retList;
    }

    public void saveAddenda() throws DLTException, FileNotFoundException, IOException {
        if (this.addenda == null) {
            return;
        }
        this.addenda.lockWrite();
        this.addenda.save();
        this.addenda.unlockWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWordToAddenda(String string) {
        if (this.addenda == null) {
            return;
        }
        try {
            this.addenda.lockWrite();
            this.addenda.addWord(string, addendaGloss);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        finally {
            try {
                this.addenda.unlockWrite();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWordToAddenda(String[] stringArray) {
        if (this.addenda == null) {
            return;
        }
        try {
            this.addenda.lockWrite();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addenda.addWord(stringArray[i], addendaGloss);
            }
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        finally {
            try {
                this.addenda.unlockWrite();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreWord(String string) {
        if (this.ignored == null) {
            return;
        }
        try {
            this.ignored.lockWrite();
            this.ignored.addWord(string, ignoreMset);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        finally {
            try {
                this.ignored.unlockWrite();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWordFromAdenda(String string) {
        try {
            this.addenda.lockWrite();
            this.addenda.removeWord(string, null);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        finally {
            try {
                this.addenda.unlockWrite();
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        }
    }

    public void dispose() {
        this.dicts = null;
    }

    private static class SpellParsingStream
    implements ParsingStream {
        final List retList = new LinkedList();

        private SpellParsingStream() {
        }

        public void reset(UniLexAnalyzer uniLexAnalyzer) {
        }

        public void close() {
        }

        public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
            if (glossCollection == null) {
                return;
            }
            Iterator iterator = glossCollection.iterator();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            while (iterator.hasNext()) {
                Gloss gloss = (Gloss)iterator.next();
                if (gloss.getType() == 1) {
                    LangNameGloss langNameGloss = (LangNameGloss)((MidGloss)gloss).getGloss(16);
                    if (langNameGloss != null && langNameGloss.value.startsWith(SpellCheckerSession.ignoredWordsTagPrefix)) {
                        bl3 = true;
                        break;
                    }
                    FeatureSetGloss featureSetGloss = ((MidGloss)gloss).getFeatureGloss();
                    if (featureSetGloss == null) continue;
                    if (featureSetGloss.isCorrectSpelling()) {
                        bl = true;
                        continue;
                    }
                    bl2 = true;
                    continue;
                }
                if (gloss.getType() != 15) continue;
                if (((FeatureSetGloss)gloss).isCorrectSpelling()) {
                    bl = true;
                    continue;
                }
                bl2 = true;
            }
            if (bl3) {
                return;
            }
            if (bl2) {
                this.createUnknown(n, n2, n3, 200);
                return;
            }
            if (bl == bl2) {
                this.createUnknown(n, n2, n3, 200);
                return;
            }
        }

        public void createBreakpoint(int n, int n2, int n3) {
        }

        public void createPunctuation(int n, int n2, int n3, int n4) {
        }

        public int startGroup(int n, int n2, int n3) {
            return 0;
        }

        public void closeGroup(int n) {
        }

        public void fork() {
        }

        public void addToFork() {
        }

        public void mergeRoutes(int n) {
        }

        public void createUnknown(int n, int n2, int n3, int n4) {
            this.retList.add(new MisspeltWord(n2, n3, n4));
        }
    }
}

