/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;

public final class PatternNameFilter
implements FilenameFilter {
    private final String pattern;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public static boolean langNameWildmatch(String string, String string2) {
        string = string.toLowerCase().replace('_', '-');
        string2 = string2.toLowerCase().replace('_', '-');
        return PatternNameFilter.wildmatch(string, string2);
    }

    public static boolean wildmatch(String string, String string2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = string2.length();
        for (n = 0; n < n6 && n4 < n5 && string.charAt(n4) != '*'; ++n4, ++n) {
            if (string.charAt(n4) == string2.charAt(n) || string.charAt(n4) == '?') continue;
            return false;
        }
        while (n < n6 && n4 < n5) {
            if (string.charAt(n4) == '*') {
                if (++n4 >= n5) {
                    return true;
                }
                n3 = n4;
                n2 = n + 1;
                continue;
            }
            if (string.charAt(n4) == string2.charAt(n) || string.charAt(n4) == '?') {
                ++n4;
                ++n;
                continue;
            }
            n4 = n3;
            n = n2++;
        }
        while (n4 < n5 && string.charAt(n4) == '*') {
            ++n4;
        }
        return n4 >= n5 && n >= n6;
    }

    public PatternNameFilter(String string) {
        this.pattern = string;
    }

    public boolean accept(File file, String string) {
        boolean bl = PatternNameFilter.wildmatch(this.pattern, string);
        return bl;
    }

    public static boolean localeWildmatch(Locale locale, Locale locale2) {
        if (locale.equals(locale2)) {
            return true;
        }
        String string = locale.getLanguage();
        if (!string.equals("*") && !string.equalsIgnoreCase(locale2.getLanguage())) {
            return false;
        }
        String string2 = locale.getCountry();
        if (!string2.equals("*") && !string2.equalsIgnoreCase(locale2.getCountry())) {
            return false;
        }
        String string3 = locale.getVariant();
        return string3.equals("*") || string3.equalsIgnoreCase(locale2.getVariant());
    }
}

