/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MWElementGloss;
import com.ibm.dltj.gloss.MWUGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.RBBICategory;
import com.ibm.dltj.util.StringBufferCharacterIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class MWDecorator
implements ParsingStream {
    CharacterIterator textIterator;
    Dictionary[] mwDictionaries;
    MWUParsingStream parsingStream;
    private ArrayList unfinishedMWUs = new ArrayList();
    private ArrayList upcomingMWUs = new ArrayList();
    private StringBuffer lemma = new StringBuffer();
    private StringBufferCharacterIterator bufferIterator = new StringBufferCharacterIterator(this.lemma);

    private void swapLists() {
        ArrayList arrayList = this.unfinishedMWUs;
        arrayList.clear();
        this.unfinishedMWUs = this.upcomingMWUs;
        this.upcomingMWUs = arrayList;
    }

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public MWDecorator(Dictionary[] dictionaryArray, ParsingStream parsingStream) throws DLTException {
        this.mwDictionaries = dictionaryArray;
        this.parsingStream = (MWUParsingStream)parsingStream;
        if (parsingStream == null) {
            throw new DLTException(Messages.getString("cannot.nullstream"));
        }
        if (dictionaryArray == null || dictionaryArray.length == 0) {
            throw new DLTException(Messages.getString("error.dict.multiword"));
        }
    }

    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.textIterator = uniLexAnalyzer.getSourceText();
        this.parsingStream.reset(uniLexAnalyzer);
    }

    public void close() {
        this.parsingStream.close();
    }

    private void clearMWUs() {
        this.unfinishedMWUs.clear();
        this.upcomingMWUs.clear();
    }

    public void createBreakpoint(int n, int n2, int n3) {
        this.clearMWUs();
        this.parsingStream.createBreakpoint(n, n2, n3);
    }

    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        try {
            GlossListElement glossListElement = glossCollection.getFirst();
            LemmaGenerator lemmaGenerator = null;
            while (glossListElement != null) {
                Gloss gloss = glossListElement.getGloss();
                if (gloss instanceof MidGloss) {
                    MidGloss midGloss = (MidGloss)gloss;
                    LemmaGenerator lemmaGenerator2 = midGloss.getLemmaGloss();
                    if (lemmaGenerator2 != null && lemmaGenerator2 != lemmaGenerator) {
                        lemmaGenerator2.getLemma(this.textIterator, n2, n3, this.lemma);
                        this.bufferIterator.setText(this.lemma);
                        this.debugPrint("\t\t\tLemma (");
                        this.debugPrint(this.lemma.toString());
                        this.debugPrint(")\n");
                        this.processLemmaForMWU(n2, n3, this.bufferIterator, midGloss);
                    }
                    lemmaGenerator = lemmaGenerator2;
                }
                glossListElement = glossListElement.next;
            }
        }
        catch (DLTException dLTException) {
            // empty catch block
        }
        this.swapLists();
        this.parsingStream.createStd(n, n2, n3, glossCollection);
    }

    private void processLemmaForMWU(int n, int n2, StringBufferCharacterIterator stringBufferCharacterIterator, MidGloss midGloss) throws DLTException {
        GlossCollection glossCollection = this.mwDictionaries[0].lookupWord(stringBufferCharacterIterator, stringBufferCharacterIterator.getEndIndex());
        if (glossCollection != null) {
            GlossListElement glossListElement = glossCollection.getFirst();
            while (glossListElement != null) {
                Gloss gloss = glossListElement.gloss;
                if (gloss instanceof MWElementGloss) {
                    MWElementGloss mWElementGloss = (MWElementGloss)gloss;
                    this.processSingleMWE(n, n2, mWElementGloss, midGloss);
                }
                glossListElement = glossListElement.next;
            }
        }
    }

    private void processSingleMWE(int n, int n2, MWElementGloss mWElementGloss, MidGloss midGloss) {
        Iterator iterator = this.unfinishedMWUs.iterator();
        while (iterator.hasNext()) {
            MWUMatch mWUMatch = (MWUMatch)iterator.next();
            if (!mWUMatch.match(mWElementGloss)) continue;
            if (mWUMatch.done()) {
                this.createMWU(mWUMatch, n2);
            } else {
                this.upcomingMWUs.add(mWUMatch);
            }
            iterator.remove();
        }
        for (int i = 0; i < mWElementGloss.element.length; ++i) {
            if (!(mWElementGloss.element[i] instanceof MWUGloss)) continue;
            MWUGloss mWUGloss = (MWUGloss)mWElementGloss.element[i];
            this.startMWU(n, n2, mWUGloss, mWElementGloss);
        }
    }

    private void startMWU(int n, int n2, MWUGloss mWUGloss, MWElementGloss mWElementGloss) {
        if (mWUGloss.element.length > 0 && mWUGloss.element[0].equals(mWElementGloss)) {
            MWUMatch mWUMatch = new MWUMatch(mWUGloss);
            mWUMatch.begin = n;
            if (mWUGloss.element.length == 1) {
                this.createMWU(mWUMatch, n2);
            } else {
                this.upcomingMWUs.add(mWUMatch);
            }
        }
    }

    private void createMWU(MWUMatch mWUMatch, int n) {
        mWUMatch.end = n;
        this.parsingStream.createMWU(0, mWUMatch.begin, mWUMatch.end, mWUMatch.mwu.getDefinitionGloss());
    }

    public void createUnknown(int n, int n2, int n3, int n4) {
        UniLexAnalyzer.memcpy(this.lemma, this.textIterator, n2, n3);
        this.bufferIterator.setText(this.lemma);
        this.debugPrint("\t\t\tUnknown (");
        this.debugPrint(this.lemma.toString());
        this.debugPrint(")\n");
        try {
            this.processLemmaForMWU(n2, n3, this.bufferIterator, null);
            if (RBBICategory.isWordLike(n4)) {
                this.lemma = new StringBuffer(this.lemma.toString().toLowerCase());
                this.bufferIterator.setText(this.lemma);
                this.processLemmaForMWU(n2, n3, this.bufferIterator, null);
            }
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        this.swapLists();
        this.parsingStream.createUnknown(n, n2, n3, n4);
    }

    public void createPunctuation(int n, int n2, int n3, int n4) {
        UniLexAnalyzer.memcpy(this.lemma, this.textIterator, n2, n3);
        this.bufferIterator.setText(this.lemma);
        this.debugPrint("\t\t\tPunctuation (");
        this.debugPrint(this.lemma.toString());
        this.debugPrint(")\n");
        try {
            this.processLemmaForMWU(n2, n3, this.bufferIterator, null);
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        this.swapLists();
        this.parsingStream.createPunctuation(n, n2, n3, n4);
    }

    public int startGroup(int n, int n2, int n3) {
        return this.parsingStream.startGroup(n, n2, n3);
    }

    public void closeGroup(int n) {
        this.parsingStream.closeGroup(n);
    }

    public void fork() {
        this.parsingStream.fork();
    }

    public void addToFork() {
        this.parsingStream.addToFork();
    }

    public void mergeRoutes(int n) {
        this.parsingStream.mergeRoutes(n);
    }

    void debugPrint(String string) {
    }

    void debugPrint(String string, MWUGloss mWUGloss, MWElementGloss mWElementGloss) {
    }

    void debugPrint(String string, MWUMatch mWUMatch) {
    }

    class MWUMatch {
        public MWUGloss mwu;
        int begin;
        int end;
        public LinkedList elementsToBeMatched = new LinkedList();

        MWUMatch() {
        }

        public boolean done() {
            return this.elementsToBeMatched.isEmpty();
        }

        public boolean match(MWElementGloss mWElementGloss) {
            if (this.elementsToBeMatched.getFirst().equals(mWElementGloss)) {
                this.elementsToBeMatched.remove(0);
                return true;
            }
            return false;
        }

        MWUMatch(int n) {
        }

        MWUMatch(MWUGloss mWUGloss) {
            for (int i = 1; i < mWUGloss.element.length; ++i) {
                this.elementsToBeMatched.add(mWUGloss.element[i]);
            }
            this.mwu = mWUGloss;
        }

        public int hashCode() {
            return this.mwu.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof MWUGloss) {
                return this.mwu.equals(object);
            }
            if (object instanceof MWUMatch) {
                return this.mwu.equals(((MWUMatch)object).mwu);
            }
            return false;
        }
    }
}

