/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import java.util.HashSet;
import java.util.Iterator;

public class LockManager {
    private boolean isClosing = false;
    private boolean isWriteLock;
    HashSet owners = new HashSet(11);
    Object readLockObject = new Object();
    Object writeLockObject = new Object();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    private void removeDeadOwners() {
        if (this.owners.size() > 0) {
            Iterator iterator = this.owners.iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                if (thread.isAlive()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockClose() throws DLTException {
        while (true) {
            this.isClosing = true;
            LockManager lockManager = this;
            synchronized (lockManager) {
                if (this.owners.size() == 0) {
                    return;
                }
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.removeDeadOwners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockWrite() throws DLTException {
        LockManager lockManager = this;
        synchronized (lockManager) {
            if (this.isClosing) {
                throw new DLTException(Messages.getString("lock.closing"));
            }
        }
        int n = 0;
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.owners.size() == 0) {
                    Thread thread = Thread.currentThread();
                    boolean bl = !this.owners.add(thread);
                    this.isWriteLock = true;
                    if (bl) {
                        throw new DLTException(Messages.getString("lock.lock"));
                    }
                    return;
                }
                if (n > 0) {
                    this.removeDeadOwners();
                }
            }
            object = this.writeLockObject;
            synchronized (object) {
                try {
                    this.writeLockObject.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new DLTException(Messages.getString("lock.get"));
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRead() throws DLTException {
        LockManager lockManager = this;
        synchronized (lockManager) {
            if (this.isClosing) {
                throw new DLTException(Messages.getString("lock.closing"));
            }
        }
        int n = 0;
        while (true) {
            Object object = this;
            synchronized (object) {
                if (this.owners.size() == 0 || !this.isWriteLock) {
                    Thread thread = Thread.currentThread();
                    boolean bl = !this.owners.add(thread);
                    this.isWriteLock = false;
                    Object object2 = this.readLockObject;
                    synchronized (object2) {
                        this.readLockObject.notify();
                    }
                    if (bl) {
                        throw new DLTException(Messages.getString("lock.lock"));
                    }
                    return;
                }
                if (n > 0) {
                    this.removeDeadOwners();
                }
            }
            object = this.readLockObject;
            synchronized (object) {
                try {
                    this.readLockObject.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlockRead() throws DLTException {
        boolean bl;
        if (this.isWriteLock) {
            throw new DLTException(Messages.getString("lock.read"));
        }
        boolean bl2 = bl = !this.owners.remove(Thread.currentThread());
        if (this.owners.size() == 0) {
            this.isWriteLock = false;
            Object object = this.writeLockObject;
            synchronized (object) {
                this.writeLockObject.notify();
            }
            object = this.readLockObject;
            synchronized (object) {
                this.readLockObject.notify();
            }
        }
        if (!this.isWriteLock) {
            Object object = this.readLockObject;
            synchronized (object) {
                this.readLockObject.notify();
            }
        }
        if (bl) {
            throw new DLTException(Messages.getString("lock.unlock"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlockWrite() throws DLTException {
        boolean bl;
        if (!this.isWriteLock) {
            throw new DLTException(Messages.getString("lock.write"));
        }
        boolean bl2 = bl = !this.owners.remove(Thread.currentThread());
        if (this.owners.size() == 0) {
            this.isWriteLock = false;
            Object object = this.writeLockObject;
            synchronized (object) {
                this.writeLockObject.notify();
            }
            object = this.readLockObject;
            synchronized (object) {
                this.readLockObject.notify();
            }
        }
        if (!this.isWriteLock) {
            Object object = this.readLockObject;
            synchronized (object) {
                this.readLockObject.notify();
            }
        }
        if (bl) {
            throw new DLTException(Messages.getString("lock.unlock"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseLock() throws DLTException {
        boolean bl;
        boolean bl2 = bl = !this.owners.remove(Thread.currentThread());
        if (this.owners.size() == 0) {
            this.isWriteLock = false;
            Object object = this.writeLockObject;
            synchronized (object) {
                this.writeLockObject.notify();
            }
            object = this.readLockObject;
            synchronized (object) {
                this.readLockObject.notify();
            }
        }
        if (!this.isWriteLock) {
            Object object = this.readLockObject;
            synchronized (object) {
                this.readLockObject.notify();
            }
        }
        if (bl) {
            throw new DLTException(Messages.getString("lock.unlock"));
        }
    }

    public synchronized boolean isOwner() {
        return this.owners.contains(Thread.currentThread());
    }

    public synchronized boolean isClosing() {
        return this.isClosing;
    }
}

