/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.HanNumeralCharacterClassfier;
import com.ibm.dltj.HanNumeralCharacterNormalizer;
import java.text.CharacterIterator;

final class HanNormalizer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    private static final String ZERO = "0";
    private static final String HYPHEN = "-";
    private static final String[] ERA = new String[]{"\u6c11\u56fd", "\u6c11\u570b", "\u660e\u6cbb", "\u5927\u6b63", "\u662d\u548c", "\u5e73\u6210"};
    private static final int[] ERA_YEAR = new int[]{1912, 1912, 1868, 1912, 1926, 1989};
    public static final int NUMBER = 1;
    public static final int ALNUM_DATE = 2;
    public static final int HAN_DATE = 3;
    private final HanNumeralCharacterNormalizer normalizer;

    public HanNormalizer(HanNumeralCharacterClassfier hanNumeralCharacterClassfier) {
        this.normalizer = new HanNumeralCharacterNormalizer(hanNumeralCharacterClassfier);
    }

    public final String normalize(CharacterIterator characterIterator, int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return this.normalizeNumber(characterIterator, n, n2);
            }
            case 2: {
                return this.normalizeAlnumDate(characterIterator, n, n2);
            }
            case 3: {
                return this.normalizeHanDate(characterIterator, n, n2);
            }
        }
        return this.normalizeNumber(characterIterator, n, n2);
    }

    final String normalizeNumber(CharacterIterator characterIterator, int n, int n2) {
        return this.normalizer.normalize(characterIterator, n, n2);
    }

    final String normalizeHanDate(CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.getIndex();
        characterIterator.setIndex(n);
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.normalizer.normalize(characterIterator, n, n2);
        try {
            int n4;
            String string2 = null;
            int n5 = 0;
            int n6 = 0;
            for (n6 = 0; n6 < ERA.length; ++n6) {
                string2 = ERA[n6];
                if (!string.startsWith(string2)) continue;
                n5 = ERA_YEAR[n6] - 1;
                break;
            }
            String string3 = ZERO;
            String string4 = ZERO;
            String string5 = ZERO;
            block20: for (int i = n4 = n6 == ERA.length ? 0 : string2.length(); i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\u5e74': 
                    case '\ub144': {
                        String string6 = string.substring(n4, i);
                        string3 = "\u5143".equals(string6) ? Integer.toString(n5 + 1) : Integer.toString(n5 + Integer.parseInt(string6));
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u6708': 
                    case '\uc6d4': {
                        string4 = string.substring(n4, i);
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c0': {
                        string4 = "1";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c1': {
                        string4 = "2";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c2': {
                        string4 = "3";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c3': {
                        string4 = "4";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c4': {
                        string4 = "5";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c5': {
                        string4 = "6";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c6': {
                        string4 = "7";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c7': {
                        string4 = "8";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c8': {
                        string4 = "9";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32c9': {
                        string4 = "10";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32ca': {
                        string4 = "11";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u32cb': {
                        string4 = "12";
                        n4 = i + 1;
                        continue block20;
                    }
                    case '\u53f7': 
                    case '\u65e5': 
                    case '\uc77c': {
                        string5 = string.substring(n4, i);
                        n4 = i + 1;
                        continue block20;
                    }
                }
            }
            characterIterator.setIndex(n3);
            return stringBuffer.append(string3).append(HYPHEN).append(string4).append(HYPHEN).append(string5).toString();
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    final String normalizeAlnumDate(CharacterIterator characterIterator, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        characterIterator.setIndex(n);
        for (n4 = n; n4 < n2 && n5 < 3; ++n4) {
            n3 = characterIterator.current();
            if (39 == n3 || 8217 == n3 || 700 == n3) {
                n6 = n5;
            } else if (48 <= n3 && n3 <= 57) {
                n7 = n7 * 10 + (n3 - 48);
            } else if (65296 <= n3 && n3 <= 65305) {
                n7 = n7 * 10 + (n3 - 65296);
            } else {
                if (47 != n3 && 46 != n3 && 45 != n3) break;
                if (n5 == 0) {
                    n8 = n7;
                    n10 = n4;
                } else if (n5 == 1) {
                    n9 = n7;
                    n11 = n4;
                }
                ++n5;
                n7 = 0;
                n12 = n3;
            }
            characterIterator.next();
        }
        if (n4 == n2) {
            int n13;
            int n14;
            if (n6 == 0) {
                n3 = n8 + (n8 <= 29 ? 2000 : 1900);
            } else if (n6 == 2) {
                n3 = n7 + (n7 <= 29 ? 2000 : 1900);
            } else if (n8 > 31 || n10 - n >= 2 && n11 - n10 == 1 && n2 - n11 == 1) {
                n3 = n8;
                n6 = 0;
            } else {
                n3 = n7 > 31 || n10 - n == 1 && n11 - n10 == 1 && n2 - n11 <= 2 ? n7 : n7;
            }
            if (n6 == 0) {
                n14 = n9;
                n13 = n7;
            } else if (n9 > 12 || n10 - n == 1 && n11 - n10 == 2) {
                n14 = n8;
                n13 = n9;
            } else {
                n13 = n8;
                n14 = n9;
            }
            return n3 + HYPHEN + n14 + HYPHEN + n13;
        }
        return null;
    }
}

