/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossTypes;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public abstract class Gloss
implements GlossTypes {
    public static final int POS_UNKNOWN = 0;
    public static final int POS_PRONOUN = 1;
    public static final int POS_VERB = 2;
    public static final int POS_NOUN = 3;
    public static final int POS_ADJECTIVE = 4;
    public static final int POS_ADVERB = 5;
    public static final int POS_ADPOSITION = 6;
    public static final int POS_INTERJECTION = 7;
    public static final int POS_CONJUNCTION = 8;
    private static final String[] TYPE_NAME = new String[255];
    private static final Map NAME_TYPE;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public static final boolean isUserGloss(int n) {
        return n >= 128;
    }

    public static final String parseStr(int n, boolean bl) throws DLTException {
        if (n >= 255 || n < 0) {
            throw new DLTException(Messages.getString("error.gloss.range"));
        }
        String string = TYPE_NAME[n];
        if (string == null && !bl) {
            string = Integer.toString(n);
        }
        return string;
    }

    public static final String parseStr(int n) throws DLTException {
        return Gloss.parseStr(n, false);
    }

    public static final int parseInt(String string) throws DLTException {
        Integer n = (Integer)NAME_TYPE.get(string);
        if (n != null) {
            return n;
        }
        int n2 = Integer.parseInt(string);
        if (n2 >= 255 || n2 < 0) {
            throw new DLTException(Messages.getString("error.gloss.range"));
        }
        return n2;
    }

    public abstract int getType();

    public String getTypeName() throws DLTException {
        return Gloss.parseStr(this.getType());
    }

    public abstract void read(DataInputStream var1, int var2) throws IOException, DLTException;

    public abstract void write(DataOutputStream var1, GlossMapper var2) throws IOException, DLTException;

    public void recalcPointers(Gloss[] glossArray) {
    }

    public abstract boolean equals(Object var1);

    public int quickHashCode() {
        return super.hashCode();
    }

    public abstract int hashCode();

    public int numChildren() {
        return 0;
    }

    public Gloss getChild(int n) {
        return null;
    }

    public void setChild(int n, Gloss gloss) {
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "Gloss";
    }

    public boolean is(int n) {
        return false;
    }

    public void set(int n) throws DLTException {
    }

    static {
        Gloss.TYPE_NAME[0] = "void";
        Gloss.TYPE_NAME[1] = "mset";
        Gloss.TYPE_NAME[2] = "poscol";
        Gloss.TYPE_NAME[4] = "jkomcol";
        Gloss.TYPE_NAME[11] = "lemma";
        Gloss.TYPE_NAME[12] = "lemcp";
        Gloss.TYPE_NAME[13] = "gramm";
        Gloss.TYPE_NAME[14] = "pcode";
        Gloss.TYPE_NAME[15] = "fset";
        Gloss.TYPE_NAME[16] = "lang";
        Gloss.TYPE_NAME[17] = "tcr";
        Gloss.TYPE_NAME[18] = "int";
        Gloss.TYPE_NAME[19] = "cat";
        Gloss.TYPE_NAME[20] = "stem";
        Gloss.TYPE_NAME[21] = "stemcp";
        Gloss.TYPE_NAME[22] = "syn";
        Gloss.TYPE_NAME[23] = "phs";
        Gloss.TYPE_NAME[24] = "sgst";
        Gloss.TYPE_NAME[26] = "morphrule";
        Gloss.TYPE_NAME[31] = "JMAgr";
        Gloss.TYPE_NAME[32] = "JAmph";
        Gloss.TYPE_NAME[33] = "JAgrm";
        Gloss.TYPE_NAME[34] = "JAgrs";
        Gloss.TYPE_NAME[40] = "ZHmph";
        Gloss.TYPE_NAME[41] = "ZHlemma";
        Gloss.TYPE_NAME[55] = "MWElement";
        Gloss.TYPE_NAME[56] = "MWUnit";
        Gloss.TYPE_NAME[60] = "string";
        Gloss.TYPE_NAME[66] = "Tstring";
        Gloss.TYPE_NAME[67] = "Tint";
        Gloss.TYPE_NAME[68] = "Tdouble";
        Gloss.TYPE_NAME[69] = "Tvector";
        Gloss.TYPE_NAME[70] = "Tarray";
        Gloss.TYPE_NAME[71] = "ArabicTC";
        Gloss.TYPE_NAME[80] = "ZHfreq";
        Gloss.TYPE_NAME[81] = "ZHcpos";
        Gloss.TYPE_NAME[82] = "ZHdecomp";
        NAME_TYPE = new TreeMap();
        for (int i = 0; i < TYPE_NAME.length; ++i) {
            if (TYPE_NAME[i] == null) continue;
            NAME_TYPE.put(TYPE_NAME[i], new Integer(i));
        }
    }

    public static interface FeatureTags
    extends FeatureSetGloss.FeatureTags {
    }
}

