/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.Dictionary;
import com.ibm.dltj.FragmentConsumer;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.MidGloss;
import java.text.CharacterIterator;

public class FragmentDecomposer {
    int skipAfter = 0;
    Dictionary[] dictionaries;
    FragmentConsumer consumer;
    MatchBuffer mb = new MatchBuffer();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public FragmentDecomposer() {
    }

    public FragmentDecomposer(int n) {
        this.skipAfter = n;
    }

    public void open(Dictionary[] dictionaryArray, FragmentConsumer fragmentConsumer) {
        this.dictionaries = dictionaryArray;
        this.consumer = fragmentConsumer;
    }

    public void close() {
        this.dictionaries = null;
        this.consumer = null;
    }

    public void extractDictionaryParts(CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.getIndex();
        for (int i = n; i < n2; ++i) {
            characterIterator.setIndex(i);
            this.mb.clear();
            this.dictionaries[0].lookupLongest(characterIterator, this.mb);
            if (this.mb.getNumMatches() <= 0) continue;
            GlossCollection glossCollection = (GlossCollection)this.mb.gloss[0];
            int[] nArray = this.mb.index;
            GlossListElement glossListElement = glossCollection.first;
            while (glossListElement != null) {
                MidGloss midGloss;
                FeatureSetGloss featureSetGloss;
                if (glossListElement.gloss instanceof MidGloss && (featureSetGloss = (midGloss = (MidGloss)glossListElement.gloss).getFeatureGloss()) != null) {
                    int n4 = featureSetGloss.getBOFA();
                    int n5 = 0;
                    if (i != n && nArray[0] != n2) {
                        n5 |= 4;
                    } else if (i == n && nArray[0] != n2) {
                        n5 |= 2;
                    } else if (i != n && nArray[0] == n2) {
                        n5 |= 8;
                    } else if (i == n && nArray[0] == n2) {
                        n5 |= 1;
                    }
                    if (0 != (n4 & n5)) {
                        this.consumer.createFragment(i, nArray[0], glossCollection, n5);
                    }
                }
                glossListElement = glossListElement.next;
            }
            if (this.skipAfter <= 0 || this.skipAfter > nArray[0] - i) continue;
            i = nArray[0] - 1;
        }
        characterIterator.setIndex(n3);
    }
}

