/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DictionaryInfo
implements Cloneable {
    String copyrightStatement = "";
    long numberOfStates;
    long headerLength;
    long version;
    int last_modified;
    long contentType;
    long headerSize;
    long numberOfLanguages;
    long numberOfCapMatEntries;
    long numberOfPools;
    long numberOfGlosses;
    boolean isBigEndian = true;
    boolean isEditable = true;
    boolean isMinimizable = true;
    boolean isMinimized = false;
    boolean isDeterministic = true;
    boolean isReversed = false;
    private TreeMap langToTypesMap = new TreeMap();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public DictionaryInfo() {
        this.version = 84083200L;
        this.isMinimizable = true;
        this.isEditable = true;
        this.isMinimizable = true;
        this.isMinimized = false;
        this.isDeterministic = true;
        this.isReversed = false;
    }

    public DictionaryInfo(long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        this.copyrightStatement = string;
        this.version = l;
        this.isEditable = bl;
        this.isMinimizable = bl2;
        this.isMinimized = bl3;
        this.isDeterministic = bl4;
        this.isReversed = bl5;
    }

    public synchronized void clear() {
        this.langToTypesMap.clear();
    }

    public synchronized String[] getLanguages() {
        Set set = this.langToTypesMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public synchronized Set getLanguagesSet() {
        return this.langToTypesMap.keySet();
    }

    public synchronized Locale[] getLocales() {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        String[] stringArray = this.getLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            hashSet.add(CapMatrix.parseLocale(string));
        }
        return hashSet.toArray(new Locale[hashSet.size()]);
    }

    public synchronized Integer[] getFunctions(String string) {
        Collection collection = (Collection)this.langToTypesMap.get(string);
        if (collection != null) {
            return collection.toArray(new Integer[collection.size()]);
        }
        return new Integer[0];
    }

    public boolean hasFunction(int n) {
        Integer n2 = new Integer(n);
        Iterator iterator = this.langToTypesMap.values().iterator();
        while (iterator.hasNext()) {
            Collection collection = (Collection)iterator.next();
            if (!collection.contains(n2)) continue;
            return true;
        }
        return false;
    }

    public synchronized String getCopyrightStatement() {
        return this.copyrightStatement;
    }

    public synchronized long getHeaderLength() {
        return this.headerLength;
    }

    public synchronized long getHeaderSize() {
        return this.headerSize;
    }

    public synchronized boolean isBigEndian() {
        return this.isBigEndian;
    }

    public synchronized boolean isDeterministic() {
        return this.isDeterministic;
    }

    public synchronized boolean isEditable() {
        return this.isEditable;
    }

    public synchronized boolean isMinimizable() {
        return this.isMinimizable;
    }

    public synchronized boolean isMinimized() {
        return this.isMinimized;
    }

    public synchronized boolean isReversed() {
        return this.isReversed;
    }

    public synchronized TreeMap getLangToTypesMap() {
        return this.langToTypesMap;
    }

    public synchronized int getLast_modified() {
        return this.last_modified;
    }

    public synchronized long getNumberOfCapMatEntries() {
        return this.numberOfCapMatEntries;
    }

    public synchronized long getNumberOfLanguages() {
        return this.numberOfLanguages;
    }

    public synchronized long getNumberOfLinks() {
        return this.numberOfGlosses;
    }

    public synchronized long getNumberOfGlosses() {
        return this.numberOfGlosses;
    }

    public synchronized long getNumberOfPools() {
        return this.numberOfPools;
    }

    public synchronized long getNumberOfStates() {
        return this.numberOfStates;
    }

    public synchronized long getVersion() {
        return this.version;
    }

    public synchronized String getVersionStr() {
        return DLT.buildVersionString((int)this.version);
    }

    public synchronized void addType(String string, int n) {
        ArrayList<Integer> arrayList = (ArrayList<Integer>)this.langToTypesMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Integer>();
            this.langToTypesMap.put(string, arrayList);
        }
        ListIterator<Integer> listIterator = arrayList.listIterator();
        Integer n2 = null;
        while (listIterator.hasNext() && null != (n2 = (Integer)listIterator.next()) && n2 < n) {
        }
        if (n2 != null) {
            if (n2 != n) {
                listIterator.add(new Integer(n));
            }
        } else {
            arrayList.add(new Integer(n));
        }
    }

    synchronized void appendType(String string, int n) {
        ArrayList<Integer> arrayList = (ArrayList<Integer>)this.langToTypesMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Integer>();
            this.langToTypesMap.put(string, arrayList);
        }
        arrayList.add(new Integer(n));
    }

    int getCheckSum() {
        int n = 0;
        n = DictionaryInfo.DLTDICT_HASHFUN(this.version, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.last_modified, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.isEditable, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.isMinimizable, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.isMinimized, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.isDeterministic, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.numberOfStates, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.headerLength, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.numberOfGlosses, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.numberOfPools, n);
        n = DictionaryInfo.DLTDICT_HASHFUN(this.contentType, n);
        Iterator iterator = this.langToTypesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            int n2;
            Map.Entry entry = iterator.next();
            Collection collection = (Collection)entry.getValue();
            String string = (String)entry.getKey();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                n2 = (Integer)iterator2.next();
                n = DictionaryInfo.DLTDICT_HASHFUN(n2, n);
            }
            n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                n = DictionaryInfo.DLTDICT_HASHFUN(string.charAt(i), n);
            }
        }
        if (this.copyrightStatement.length() > 0) {
            int n3 = this.copyrightStatement.length();
            for (int i = 0; i < n3; ++i) {
                n = DictionaryInfo.DLTDICT_HASHFUN(this.copyrightStatement.charAt(i), n);
            }
        } else {
            this.copyrightStatement = "";
        }
        return n;
    }

    synchronized int readHeader(DataInputStream dataInputStream) throws IOException, DLTException {
        int n;
        int n2 = 0;
        DictionaryInfo dictionaryInfo = this;
        int n3 = dataInputStream.readInt();
        n2 += 4;
        int n4 = dataInputStream.readInt();
        n2 += 4;
        if (n4 != 1229081924) {
            throw new DLTException(Messages.getString("wrong.dictformat"));
        }
        dataInputStream.readShort();
        n2 += 2;
        dictionaryInfo.contentType = dataInputStream.readInt();
        n2 += 4;
        dictionaryInfo.version = dataInputStream.readInt();
        n2 += 4;
        dictionaryInfo.last_modified = dataInputStream.readInt();
        n2 += 4;
        dictionaryInfo.numberOfStates = dataInputStream.readInt();
        n2 += 4;
        dictionaryInfo.headerLength = dataInputStream.readInt();
        n2 += 4;
        dictionaryInfo.numberOfGlosses = dataInputStream.readInt();
        n2 += 4;
        dictionaryInfo.numberOfPools = dataInputStream.readByte();
        ++n2;
        dictionaryInfo.isEditable = dataInputStream.readByte() != 0;
        ++n2;
        dictionaryInfo.isMinimizable = dataInputStream.readByte() != 0;
        ++n2;
        dictionaryInfo.isMinimized = dataInputStream.readByte() != 0;
        ++n2;
        byte by = dataInputStream.readByte();
        ++n2;
        dictionaryInfo.isDeterministic = (by & 1) != 0;
        dictionaryInfo.isReversed = (by & 2) != 0;
        int n5 = dataInputStream.readInt();
        n2 += 4;
        if (n5 != 1229081924) {
            throw new DLTException(Messages.getString("wrong.dictformat"));
        }
        int n6 = dataInputStream.readInt();
        n2 += 4;
        for (n = 0; n < n6; ++n) {
            short s = dataInputStream.readShort();
            n2 += 2;
            byte[] byArray = new byte[s];
            dataInputStream.read(byArray);
            n2 += s;
            String string = new String(byArray);
            int n7 = dataInputStream.readShort();
            n2 += 2;
            for (int i = 0; i < n7; ++i) {
                int n8 = dataInputStream.readByte() & 0xFF;
                ++n2;
                dictionaryInfo.appendType(string, n8);
            }
        }
        if (dictionaryInfo.headerLength > (long)n2) {
            n = dataInputStream.readInt();
            n2 += 4;
            if (n < 0 || n > 10000) {
                throw new DLTException(Messages.getString("error.dict.format"));
            }
            byte[] byArray = new byte[n];
            dataInputStream.read(byArray);
            n2 += n;
            dictionaryInfo.copyrightStatement = new String(byArray, "Latin1");
        }
        return n3;
    }

    static final int DLTDICT_HASHFUN(long l, int n) {
        return DictionaryInfo.DLTDICT_HASHFUN((int)l, n);
    }

    static final int DLTDICT_HASHFUN(boolean bl, int n) {
        return DictionaryInfo.DLTDICT_HASHFUN(bl ? 1 : 0, n);
    }

    static final int DLTDICT_HASHFUN(int n, int n2) {
        n2 = 31 * n2 + n + n2;
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        DictionaryInfo dictionaryInfo = new DictionaryInfo();
        dictionaryInfo.version = this.version;
        dictionaryInfo.contentType = this.contentType;
        dictionaryInfo.copyrightStatement = this.copyrightStatement;
        dictionaryInfo.headerLength = this.headerLength;
        dictionaryInfo.headerSize = this.headerSize;
        dictionaryInfo.isBigEndian = this.isBigEndian;
        dictionaryInfo.isDeterministic = this.isDeterministic;
        dictionaryInfo.isEditable = this.isEditable;
        dictionaryInfo.isMinimizable = this.isMinimizable;
        dictionaryInfo.isMinimized = this.isMinimized;
        dictionaryInfo.isReversed = this.isReversed;
        dictionaryInfo.last_modified = this.last_modified;
        dictionaryInfo.langToTypesMap = (TreeMap)this.langToTypesMap.clone();
        dictionaryInfo.numberOfCapMatEntries = this.numberOfCapMatEntries;
        dictionaryInfo.numberOfLanguages = this.numberOfLanguages;
        dictionaryInfo.numberOfGlosses = this.numberOfGlosses;
        dictionaryInfo.numberOfPools = this.numberOfPools;
        dictionaryInfo.numberOfStates = this.numberOfStates;
        return dictionaryInfo;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DictionaryInfo)) {
            return false;
        }
        DictionaryInfo dictionaryInfo = (DictionaryInfo)object;
        return dictionaryInfo.numberOfStates == this.numberOfStates && dictionaryInfo.headerLength == this.headerLength && dictionaryInfo.version == this.version && dictionaryInfo.contentType == this.contentType && dictionaryInfo.numberOfLanguages == this.numberOfLanguages && dictionaryInfo.numberOfPools == this.numberOfPools && dictionaryInfo.numberOfGlosses == this.numberOfGlosses && dictionaryInfo.isBigEndian == this.isBigEndian && dictionaryInfo.isEditable == this.isEditable && dictionaryInfo.isMinimizable == this.isMinimizable && dictionaryInfo.isMinimized == this.isMinimized && dictionaryInfo.isDeterministic == this.isDeterministic && dictionaryInfo.isReversed == this.isReversed && dictionaryInfo.langToTypesMap.equals(this.langToTypesMap);
    }

    int getCopyrightSize() {
        int n = this.copyrightStatement.length();
        if (n > 0) {
            return 4 + n;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("v.").append(DLT.buildVersionString((int)this.getVersion()));
        stringBuffer.append(" {");
        Iterator iterator = this.langToTypesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append('[');
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            stringBuffer.append('\"').append(string).append("\" ");
            Collection collection = (Collection)entry.getValue();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                stringBuffer.append(e);
                if (!iterator2.hasNext()) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

