/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.BackMapper;
import com.ibm.dltj.DLT;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.DLTPos;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Entry;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossFactory;
import com.ibm.dltj.LockManager;
import com.ibm.dltj.Messages;
import com.ibm.dltj.data.ja.JaTrHandler;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.MultiNetImpl;
import com.ibm.dltj.fst.MultiNetIntegerImpl;
import com.ibm.dltj.fst.NDNet;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.NodeHashIndex;
import com.ibm.dltj.gloss.BasicCutPasteGloss;
import com.ibm.dltj.gloss.CatNameGloss;
import com.ibm.dltj.gloss.CutPasteGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.GlossPool;
import com.ibm.dltj.gloss.GrammarGloss;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.JaGramSetGloss;
import com.ibm.dltj.gloss.JaMorphGloss;
import com.ibm.dltj.gloss.JkomCollectionGloss;
import com.ibm.dltj.gloss.LangNameGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.PcodeGloss;
import com.ibm.dltj.gloss.PhoneticSpellingGloss;
import com.ibm.dltj.gloss.PosCollectionGloss;
import com.ibm.dltj.gloss.StemCutPasteGloss;
import com.ibm.dltj.gloss.StemGloss;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.gloss.SynonymGloss;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.gloss.TypedDoubleGloss;
import com.ibm.dltj.gloss.TypedIntGloss;
import com.ibm.dltj.gloss.TypedStringGloss;
import com.ibm.dltj.gloss.TypedVectorGloss;
import com.ibm.dltj.gloss.UserDefinedDefaultGloss;
import com.ibm.dltj.um.JKOM;
import com.ibm.dltj.um.JPOS;
import com.ibm.dltj.util.Traverse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Dictionary
extends LockManager {
    public static final int DLT3_DEFAULT_VERSION = 768;
    public static final int DLT3_DEFAULT_TYPE = 1;
    public static final int DLT3_TYPE_DEFAULT = 1;
    public static final int DLT3_TYPE_ENCHAINED = 0x10000000;
    public static final int DLT_DEFAULT_VERSION = 84083200;
    public static final int DLT_DEFAULT_TYPE = 1;
    public static final int DLT_TYPE_DEFAULT = 1;
    public static final int DLT_TYPE_ENCHAINED = 0x10000000;
    MultiNet fsa = new MultiNetIntegerImpl();
    private DictionaryInfo summary = new DictionaryInfo();
    private File dictionaryFile = null;
    public GlossPool[] pools = new GlossPool[255];
    GlossFactory gFactory = new GlossFactoryImpl();
    private static final int DLTGLS_POOL_HEXSIGNATURE_BYTE = 1347374924;
    private static final int DLTGLS_POOL_HEXSIGNATURE_CLASS = 1347374925;
    private static final int DLTGLS_POOL_HEXSIGNATURE_CLASSDATA = 1347374926;
    static final int DLT_DICTIONARY_SIGNATURE = 1229081924;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\nASW16ZZ\n(C) Copyright IBM Corp. 2003, 2006. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    GlossPool getPoolByNumber(int n) {
        return this.pools[n];
    }

    GlossPool registerPool(int n) throws DLTException {
        this.pools[n] = GlossPool.instantiate(n);
        return this.pools[n];
    }

    GlossPool registerPool(String string, int n) throws DLTException {
        this.pools[n] = GlossPool.instantiate(string);
        return this.pools[n];
    }

    GlossPool registerPool(String string, byte[] byArray, int n) throws DLTException {
        this.pools[n] = GlossPool.instantiate(string, byArray);
        return this.pools[n];
    }

    GlossPool registerPool(Class clazz, int n, String string) throws DLTException {
        this.pools[n] = new GlossPool(clazz);
        this.summary.addType(string, n);
        return this.pools[n];
    }

    GlossPool registerPool(Class clazz, byte[] byArray, int n, String string) throws DLTException {
        this.pools[n] = new GlossPool(clazz, byArray);
        this.summary.addType(string, n);
        return this.pools[n];
    }

    public Dictionary() {
    }

    public Dictionary(File file, String string, int n, int n2) throws DLTException {
        this(file, n, n2);
    }

    public Dictionary(File file, int n, int n2) throws DLTException {
        this.dictionaryFile = file;
        this.summary.version = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dictionary(DictionaryInfo dictionaryInfo) throws DLTException {
        DictionaryInfo dictionaryInfo2 = dictionaryInfo;
        synchronized (dictionaryInfo2) {
            try {
                this.summary = (DictionaryInfo)dictionaryInfo.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DLTException(Messages.getString("cannot.clone"));
            }
            this.dictionaryFile = new File("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dictionary(File file, DictionaryInfo dictionaryInfo) throws DLTException {
        DictionaryInfo dictionaryInfo2 = dictionaryInfo;
        synchronized (dictionaryInfo2) {
            try {
                this.summary = (DictionaryInfo)dictionaryInfo.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DLTException(Messages.getString("cannot.clone"));
            }
            this.dictionaryFile = file;
            if (!this.summary.isDeterministic()) {
                this.fsa = new NDNet();
            }
        }
    }

    public static Dictionary createDictionary(DictionaryInfo dictionaryInfo) throws DLTException {
        return new Dictionary(dictionaryInfo);
    }

    public static Dictionary createDictionary(File file, DictionaryInfo dictionaryInfo) throws DLTException {
        return new Dictionary(file, dictionaryInfo);
    }

    public Dictionary(File file, boolean bl) throws DLTException {
        try {
            this.load(file, bl);
            this.dictionaryFile = file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DLTException(Messages.getString("file.notexist"));
        }
        catch (IOException iOException) {
            throw new DLTException(iOException.getMessage());
        }
    }

    public Dictionary(File file) throws DLTException {
        this(file, true);
    }

    public synchronized long getNumberOfEntries() throws DLTException {
        if (this.summary.getCopyrightStatement().indexOf("IBM") < 0 && this.summary.isDeterministic()) {
            return new CountTraverse().count();
        }
        throw new DLTException(Messages.getString("cannot.iteratedict"));
    }

    public Iterator iterator() throws DLTException {
        if (this.summary.getCopyrightStatement().indexOf("IBM") < 0) {
            return this.fsa.iterator();
        }
        throw new DLTException(Messages.getString("cannot.iteratedict"));
    }

    public static File[] find(String string, int n) throws DLTException {
        if (DLT.cm == null) {
            throw new DLTException(Messages.getString("wrong.call.find"));
        }
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("invalid.langid"));
        }
        if (n < 0 || n > 255) {
            throw new DLTException(Messages.getString("invalid.option"));
        }
        return DLT.getCapMatrix().getAvailableFiles(string, n);
    }

    public MultiNet getNet() {
        return this.fsa;
    }

    protected int getCheckSum() {
        return this.summary.getCheckSum();
    }

    public synchronized void load(File file) throws DLTException, FileNotFoundException, IOException {
        this.load(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(File file, boolean bl) throws DLTException, FileNotFoundException, IOException {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.load((DataInputStream)filterInputStream, bl);
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    public void load(DataInputStream dataInputStream) throws DLTException, IOException {
        this.load(dataInputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(DataInputStream dataInputStream, boolean bl) throws DLTException, IOException {
        DictionaryInfo dictionaryInfo = this.summary;
        synchronized (dictionaryInfo) {
            int n = Dictionary.readHeader(dataInputStream, this.summary);
            this.fsa = bl ? (!this.summary.isDeterministic() ? new NDNet() : new MultiNetIntegerImpl()) : (!this.summary.isDeterministic() ? new NDNet() : new MultiNetImpl());
            this.fsa.read_contents(dataInputStream);
            this.summary.isMinimizable = !this.fsa.getChainPolicy();
            this.summary.isMinimized = this.fsa.isContracted();
            this.loadGlosses(dataInputStream);
            int n2 = this.getCheckSum();
            if (n2 != n) {
                throw new DLTException(Messages.getString("error.dict.checksum"));
            }
        }
    }

    private void loadGlosses(DataInputStream dataInputStream) throws DLTException, IOException {
        BackMapper backMapper = new BackMapper(this.summary.getNumberOfGlosses() + 1L);
        for (long i = 0L; i < this.summary.getNumberOfPools(); ++i) {
            this.loadGlossPool(dataInputStream, backMapper);
        }
        this.fsa.processGlosses(backMapper);
        for (int i = 0; i < backMapper.backMapperArray.length; ++i) {
            if (backMapper.backMapperArray[i] == null) continue;
            backMapper.backMapperArray[i].recalcPointers(backMapper.backMapperArray);
        }
        Iterator iterator = this.getPools();
        while (iterator.hasNext()) {
            GlossPool glossPool = (GlossPool)iterator.next();
            if (glossPool == null) continue;
            glossPool.internGlosses();
        }
        this.fsa.endReading();
    }

    private void loadGlossPool(DataInputStream dataInputStream, BackMapper backMapper) throws IOException, DLTException {
        GlossPool glossPool;
        int n;
        int n2 = dataInputStream.readInt();
        if (n2 == 1347374924) {
            n = dataInputStream.readByte() & 0xFF;
            if (this.getPoolByNumber(n) != null) {
                throw new DLTException(Messages.getString("error.dict.pool"));
            }
            glossPool = this.registerPool(n);
        } else if (n2 == 1347374925) {
            String string = dataInputStream.readUTF();
            n = dataInputStream.readInt();
            if (this.getPoolByNumber(n) != null) {
                throw new DLTException(Messages.getString("error.dict.pool"));
            }
            glossPool = this.registerPool(string, n);
        } else if (n2 == 1347374926) {
            String string = dataInputStream.readUTF();
            int n3 = dataInputStream.readInt();
            byte[] byArray = new byte[n3];
            dataInputStream.read(byArray);
            n = dataInputStream.readInt();
            if (this.getPoolByNumber(n) != null) {
                throw new DLTException(Messages.getString("error.dict.pool"));
            }
            glossPool = this.registerPool(string, byArray, n);
        } else {
            throw new DLTException(Messages.getString("error.dict.pool"));
        }
        if (glossPool == null) {
            throw new DLTException(Messages.getString("cannot.instantiatepool") + n);
        }
        glossPool.read(dataInputStream, n, backMapper.backMapperArray);
    }

    public void save() throws DLTException, FileNotFoundException, IOException {
        this.internSave(this.dictionaryFile);
    }

    public void save(File file) throws DLTException, FileNotFoundException, IOException {
        this.internSave(file);
    }

    public Object oovLookup(CharacterIterator characterIterator, int n) {
        MatchBuffer matchBuffer = new MatchBuffer();
        matchBuffer.setMaxIndex(Integer.MAX_VALUE);
        this.traverseReversed(characterIterator, matchBuffer);
        Object[] objectArray = matchBuffer.gloss;
        int[] nArray = matchBuffer.index;
        for (int i = matchBuffer.mpos - 1; i >= 0; --i) {
            boolean bl = Dictionary.isGeneric(objectArray[i]);
            if (!bl && nArray[i] == n) {
                return objectArray[i];
            }
            if (!bl || nArray[i] >= n) continue;
            return objectArray[i];
        }
        return null;
    }

    private static boolean isGeneric(Object object) {
        if (object instanceof GlossCollection) {
            GlossCollection glossCollection = (GlossCollection)object;
            return glossCollection.isGeneric();
        }
        return false;
    }

    public final boolean lookupLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.fsa.traverseLongest(characterIterator, matchBuffer);
    }

    public final boolean lookupLongestReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.fsa.traverseLongestReversed(characterIterator, matchBuffer);
    }

    public final GlossCollection lookupWord(CharacterIterator characterIterator, int n) throws DLTException {
        Object object = this.fsa.get(characterIterator, n);
        return (GlossCollection)object;
    }

    public final int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.fsa.traverse(characterIterator, matchBuffer);
    }

    public final int traverseReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        return this.fsa.traverseReversed(characterIterator, matchBuffer);
    }

    public final Entry lookupWord(String string) throws DLTException {
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("wrong.string"));
        }
        GlossCollection glossCollection = this.get(new StringCharacterIterator(string), string.length());
        if (glossCollection != null) {
            return new Entry(glossCollection);
        }
        return new Entry();
    }

    public final void lookupWord(char[] cArray, int n, int n2, Entry entry) throws DLTException {
        this.lookupWordUnsafe(new String(cArray, n, n2 - n), entry);
    }

    public final void lookupWordUnsafe(String string, Entry entry) throws DLTException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        GlossCollection glossCollection = this.get(stringCharacterIterator, string.length());
        entry.set(glossCollection);
    }

    public final GlossCollection get(String string) {
        Object object = this.fsa.get(new StringCharacterIterator(string), string.length());
        return (GlossCollection)object;
    }

    public final GlossCollection get(CharacterIterator characterIterator, int n) throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        Object object = this.fsa.get(characterIterator, n);
        return (GlossCollection)object;
    }

    public static void check(File file, DictionaryInfo dictionaryInfo) throws DLTException {
        try {
            Dictionary.readHeader(file, dictionaryInfo);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DLTException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new DLTException(iOException.getMessage());
        }
    }

    public static void readHeader(File file, DictionaryInfo dictionaryInfo) throws DLTException, FileNotFoundException, IOException {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            Dictionary.readHeader((DataInputStream)filterInputStream, dictionaryInfo);
        }
        catch (DLTException dLTException) {
            throw dLTException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    public static int readHeader(DataInputStream dataInputStream, DictionaryInfo dictionaryInfo) throws DLTException, IOException {
        return dictionaryInfo.readHeader(dataInputStream);
    }

    public DictionaryInfo getSummary() {
        return this.summary;
    }

    public synchronized void registerType(int n, String string) throws DLTException {
        if (n < 0 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.registergloss"));
        }
        if (this.summary == null) {
            throw new DLTException(Messages.getString("invalid.dictinfo"));
        }
        this.registerPool(n);
        this.summary.addType(string, n);
    }

    public synchronized void registerType(int n, String string, Class clazz) throws DLTException {
        if (n < 128 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.registergloss"));
        }
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool != null && glossPool.getMainClass() != clazz) {
            throw new DLTException(Messages.getString("error.typeid"));
        }
        this.registerPool(clazz, n, string);
    }

    public synchronized void registerType(int n, String string, Class clazz, byte[] byArray) throws DLTException {
        if (n < 128 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.registergloss"));
        }
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool != null && glossPool.getMainClass() != clazz) {
            throw new DLTException(Messages.getString("error.typeid"));
        }
        this.registerPool(clazz, byArray, n, string);
    }

    public Gloss addUserGloss(int n, byte[] byArray, int n2) throws DLTException {
        if (n < 128 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.addgloss"));
        }
        if (byArray == null) {
            throw new DLTException(Messages.getString("invalid.data"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.notregister"));
        }
        return glossPool.checkIn(new UserDefinedDefaultGloss(n, byArray));
    }

    public Gloss addUserGloss(int n, Gloss gloss) throws DLTException {
        if (n < 1 || n >= 255) {
            throw new DLTException(Messages.getString("cannot.addgloss"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.notregister"));
        }
        return glossPool.checkIn(gloss);
    }

    public Gloss addGloss(int n, Gloss gloss) throws DLTException {
        return this.addUserGloss(n, gloss);
    }

    public final void addWord(String string, Gloss gloss) throws DLTException {
        if (string == null || string.length() == 0) {
            throw new DLTException(Messages.getString("invalid.surface"));
        }
        this.fsa.add(new StringCharacterIterator(string), string.length(), gloss);
    }

    public final void addWord(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        this.fsa.add(characterIterator, n, gloss);
    }

    public final void addWord(String string, Gloss[] glossArray) throws DLTException {
        for (int i = 0; i < glossArray.length; ++i) {
            Gloss gloss = glossArray[i];
            this.addWord(string, gloss);
        }
    }

    public final void put(String string, Gloss gloss) throws DLTException {
        this.addWord(string, gloss);
    }

    public final void put(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        this.addWord(characterIterator, n, gloss);
    }

    public final Gloss addMorphGloss(Gloss[] glossArray, int n) throws DLTException {
        if (glossArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(1);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new MidGloss(glossArray));
    }

    public final Gloss addMorphGloss(Gloss[] glossArray) throws DLTException {
        return this.addMorphGloss(glossArray, 0);
    }

    public final Gloss addLemmaGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(11);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new LemmaGloss(string));
    }

    public final Gloss addLanguageGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(16);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new LangNameGloss(string, n));
    }

    public final Gloss addIntegerGloss(int n) throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(18);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new IntegerGloss(n));
    }

    public final Gloss addIntegerGloss(int n, int n2) throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(18);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new IntegerGloss(n));
    }

    public final Gloss addLemmaGloss(String string) throws DLTException {
        return this.addLemmaGloss(string, 0);
    }

    public final Gloss addFeatureSetGloss(int n, int n2, int n3, int n4, int n5) throws DLTException {
        if ((n5 & 0xFFFFFF00) != 0 || (n & 0xFFFFFF00) != 0 || (n2 & 0xFFFFFF00) != 0 || (n3 & 0xFFFFFFFE) != 0 || (n4 & 0xFFFFFFFE) != 0) {
            throw new DLTException(Messages.getString("error.data"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(15);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new FeatureSetGloss(n, n2, n3, n4, n5));
    }

    public final Gloss addFeatureSetGloss(int n, int n2, int n3, int n4) throws DLTException {
        return this.addFeatureSetGloss(n, n2, n3, n4, 0);
    }

    public final Gloss addFeatureSetGloss(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws DLTException {
        if ((n & 0xFFFFFF00) != 0 || (n2 & 0xFFFFFF00) != 0) {
            throw new DLTException(Messages.getString("error.data"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(15);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new FeatureSetGloss(n, n2, bl, bl2, bl3, bl4));
    }

    public synchronized void dispose() throws DLTException {
        this.lockClose();
        this.fsa = null;
        this.summary = null;
        this.dictionaryFile = null;
        this.pools = null;
    }

    protected boolean valid() {
        return this.fsa != null && this.pools != null;
    }

    public final String[] getLanguages() throws DLTException {
        return this.getSummary().getLanguages();
    }

    public final Gloss addCatNameGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(19);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new CatNameGloss(string));
    }

    public final Gloss addCutPasteGloss(String string, String string2, int n, int n2) throws DLTException {
        BasicCutPasteGloss basicCutPasteGloss;
        if (string == null || string2 == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(n);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        switch (n) {
            case 12: {
                basicCutPasteGloss = new CutPasteGloss(string, string2);
                break;
            }
            case 21: {
                basicCutPasteGloss = new StemCutPasteGloss(string, string2);
                break;
            }
            default: {
                throw new DLTException(Messages.getString("invalid.type"));
            }
        }
        return glossPool.checkIn(basicCutPasteGloss);
    }

    public final Gloss addGrammarGloss(int[] nArray, int n) throws DLTException {
        if (nArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(13);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new GrammarGloss(nArray));
    }

    public final Gloss addJAMorphGloss(int n, int n2, int n3, int n4) throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(32);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        if (n3 != 0 && n3 != 1) {
            throw new DLTException(Messages.getString("error.parameter"));
        }
        if (n2 == 0) {
            return glossPool.checkIn(new JaMorphGloss(n, JKOM.toPOS(n).toId(), n3));
        }
        return glossPool.checkIn(new JaMorphGloss(n, n2, n3));
    }

    public final Gloss addJaGramSetGloss(long[] lArray) throws DLTException {
        if (lArray == null) {
            throw new DLTException(Messages.getString("invalid.data"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(34);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new JaGramSetGloss(lArray));
    }

    public final Gloss addJkomBasedCollectionGls(int n, Gloss[] glossArray, int n2) throws DLTException {
        if (glossArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(4);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new JkomCollectionGloss(n, glossArray, n2));
    }

    public final Gloss addPhoneticSpellingGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(23);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new PhoneticSpellingGloss(string));
    }

    public final Gloss addPosBasedCollectionGls(int n, Gloss[] glossArray, int n2) throws DLTException {
        if (glossArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(2);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new PosCollectionGloss(n, glossArray, n2));
    }

    public final Gloss addSynGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(22);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new SynonymGloss(string));
    }

    public final Gloss addStemGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(20);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new StemGloss(string));
    }

    public final Gloss addTCRGloss(int n, int n2, int n3, String string, int n4) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("invalid.rule"));
        }
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(17);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new TCRGloss(n, n2, n3, string));
    }

    public final Gloss addPcodeGloss(String string) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(14);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new PcodeGloss(string));
    }

    public final Gloss addStringGloss(String string, int n) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(60);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new StringGloss(string, n));
    }

    public final Gloss addTypedStringGloss(StringGloss stringGloss, String string, int n) throws DLTException {
        if (string == null || stringGloss == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(66);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new TypedStringGloss(stringGloss, string, n));
    }

    public final Gloss addTypedIntGloss(StringGloss stringGloss, int n, int n2) throws DLTException {
        if (stringGloss == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(67);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new TypedIntGloss(stringGloss, n, n2));
    }

    public final Gloss addTypedDoubleGloss(StringGloss stringGloss, double d, int n) throws DLTException {
        if (stringGloss == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(68);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new TypedDoubleGloss(stringGloss, d, n));
    }

    public final Gloss addTypedVectorGloss(StringGloss stringGloss, Gloss[] glossArray, int n) throws DLTException {
        if (stringGloss == null || glossArray == null) {
            throw new DLTException(Messages.getString("null.parameter"));
        }
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        GlossPool glossPool = this.getPoolByNumber(69);
        if (glossPool == null) {
            throw new DLTException(Messages.getString("error.gloss.registertype"));
        }
        return glossPool.checkIn(new TypedVectorGloss(stringGloss, glossArray, n));
    }

    public final void contract() throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        this.fsa.contract();
    }

    public final void append(Dictionary dictionary) throws DLTException {
        throw new UnsupportedOperationException(Messages.getString("notimplement"));
    }

    public final void removeEntry(String string, Entry entry) throws DLTException {
        if (entry == null) {
            throw new DLTException(Messages.getString("invalid.entry"));
        }
        Gloss gloss = entry.current == null ? null : entry.current.gloss;
        this.removeWord(string, gloss);
    }

    public final void removeWord(String string, Gloss gloss) throws DLTException {
        if (!this.valid()) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        this.fsa.removeGloss(new StringCharacterIterator(string), string.length(), gloss);
    }

    public final void stampCopyright(String string) throws DLTException {
        if (string == null) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        if (this.summary == null) {
            throw new DLTException(Messages.getString("invalid.dictinfo"));
        }
        if (this.summary.copyrightStatement.length() > 0) {
            throw new DLTException(Messages.getString("message.copyright"));
        }
        this.summary.copyrightStatement = string;
    }

    public void setVersion(int n) throws DLTException {
        this.summary.version = n;
    }

    public GlossFactory createGlossFactory() {
        return new GlossFactoryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object[] getFunctionMasks() {
        DictionaryInfo dictionaryInfo = this.summary;
        synchronized (dictionaryInfo) {
            String[] stringArray = this.summary.getLanguages();
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Integer[] integerArray = this.summary.getFunctions(stringArray[i]);
                objectArray[i] = new int[integerArray.length];
                for (int j = 0; j < integerArray.length; ++j) {
                    Integer n = integerArray[j];
                    ((int[])objectArray[i])[j] = n;
                }
            }
            return objectArray;
        }
    }

    public synchronized int getPoolNum() {
        int n = 0;
        for (int i = 0; i < this.pools.length; ++i) {
            if (this.pools[i] == null) continue;
            ++n;
        }
        return n;
    }

    Iterator getPools() {
        return Arrays.asList(this.pools).iterator();
    }

    protected synchronized int getHeaderSize() {
        int n = 0;
        n += 4;
        String[] stringArray = this.summary.getLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            n += 2;
            n += string.length();
            n += 2 + ((List)this.summary.getLangToTypesMap().get(string)).size();
        }
        return n += this.summary.getCopyrightSize();
    }

    public void save(DataOutputStream dataOutputStream) throws DLTException, IOException {
        this.save(dataOutputStream, false);
    }

    private synchronized int getPoolSizeSum() {
        int n = 0;
        Iterator iterator = this.getPools();
        while (iterator.hasNext()) {
            GlossPool glossPool = (GlossPool)iterator.next();
            if (glossPool == null) continue;
            n += glossPool.glossHash.size();
        }
        return n;
    }

    private synchronized long writeHeader(DataOutputStream dataOutputStream, NodeHashIndex nodeHashIndex) throws IOException, DLTException {
        long l = -1L;
        this.summary.contentType = 1718837599L;
        this.summary.numberOfStates = nodeHashIndex.getNodeCount();
        this.summary.numberOfGlosses = this.getPoolSizeSum();
        l = this.summary.headerLength = (long)(43 + this.getHeaderSize());
        this.summary.numberOfPools = (byte)this.getPoolNum();
        this.summary.isMinimizable = !this.fsa.getChainPolicy();
        this.summary.isMinimized = this.fsa.isContracted();
        int n = this.getCheckSum();
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(1229081924);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeInt((int)this.summary.contentType);
        dataOutputStream.writeInt((int)this.summary.version);
        dataOutputStream.writeInt(this.summary.last_modified);
        dataOutputStream.writeInt((int)this.summary.numberOfStates);
        dataOutputStream.writeInt((int)this.summary.headerLength);
        dataOutputStream.writeInt((int)this.summary.numberOfGlosses);
        dataOutputStream.writeByte((byte)this.summary.numberOfPools);
        dataOutputStream.writeByte(this.summary.isEditable ? 1 : 0);
        dataOutputStream.writeByte(this.summary.isMinimizable ? 1 : 0);
        dataOutputStream.writeByte(this.summary.isMinimized ? 1 : 0);
        int n2 = (this.summary.isDeterministic ? 1 : 0) + (this.summary.isReversed ? 2 : 0);
        dataOutputStream.writeByte(n2);
        dataOutputStream.writeInt(1229081924);
        int n3 = this.summary.getLangToTypesMap().size();
        dataOutputStream.writeInt(n3);
        String[] stringArray = this.getLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n4 = string.length();
            dataOutputStream.writeShort((short)n4);
            for (int j = 0; j < n4; ++j) {
                dataOutputStream.writeByte(string.charAt(j));
            }
            Integer[] integerArray = this.summary.getFunctions(string);
            int n5 = integerArray.length;
            dataOutputStream.writeShort((short)n5);
            for (int j = 0; j < n5; ++j) {
                dataOutputStream.writeByte(integerArray[j].byteValue());
            }
        }
        if (this.summary.copyrightStatement != null && this.summary.copyrightStatement.length() > 0) {
            byte[] byArray = this.summary.copyrightStatement.getBytes("Latin1");
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
        return l;
    }

    private synchronized long writeFSAheaders(DataOutputStream dataOutputStream, NodeHashIndex nodeHashIndex) throws IOException {
        long l = -1L;
        dataOutputStream.writeInt(-1161904401);
        l += 4L;
        dataOutputStream.writeInt(0);
        l += 4L;
        int n = nodeHashIndex.getGlossCollectionCount();
        dataOutputStream.writeInt(n);
        l += 4L;
        dataOutputStream.writeInt(-1161904401);
        l += 4L;
        int n2 = nodeHashIndex.getNodeCount();
        dataOutputStream.writeInt(n2);
        l += 4L;
        dataOutputStream.writeInt(n);
        l += 4L;
        int n3 = (this.fsa.isContracted() ? 2 : 0) | (this.fsa.getChainPolicy() ? 1 : 0);
        dataOutputStream.writeInt(n3);
        return l += 4L;
    }

    private synchronized void writeGlosses(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws DLTException, IOException {
        Iterator iterator = this.getPools();
        int n = 0;
        while (iterator.hasNext()) {
            GlossPool glossPool = (GlossPool)iterator.next();
            if (glossPool != null) {
                if (n < 128) {
                    dataOutputStream.writeInt(1347374924);
                    dataOutputStream.writeByte(n);
                } else if (glossPool.getMainClassBytes() != null) {
                    dataOutputStream.writeInt(1347374926);
                    dataOutputStream.writeUTF(glossPool.getMainClass().getName());
                    byte[] byArray = glossPool.getMainClassBytes();
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray);
                    dataOutputStream.writeInt(n);
                } else {
                    dataOutputStream.writeInt(1347374925);
                    dataOutputStream.writeUTF(glossPool.getMainClass().getName());
                    dataOutputStream.writeInt(n);
                }
                glossPool.write(dataOutputStream, glossMapper);
            }
            ++n;
        }
        glossMapper.reAssign();
    }

    public synchronized long save(DataOutputStream dataOutputStream, boolean bl) throws DLTException, IOException {
        return this.internSave(dataOutputStream);
    }

    private synchronized long internSave(DataOutputStream dataOutputStream) throws DLTException {
        NodeHashIndex nodeHashIndex;
        long l = 0L;
        try {
            nodeHashIndex = new NodeHashIndex(this.fsa.first());
            GlossMapper glossMapper = new GlossMapper(this.pools);
            long l2 = this.writeHeader(dataOutputStream, nodeHashIndex);
            l = l2 + this.writeFSAheaders(dataOutputStream, nodeHashIndex);
            nodeHashIndex.write_gloss_header(dataOutputStream, glossMapper);
            this.writeGlosses(dataOutputStream, glossMapper);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DLTException(unsupportedEncodingException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DLTException(fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DLTException(exception.getMessage());
        }
        return l += (long)nodeHashIndex.write_nodes(dataOutputStream, 0);
    }

    private synchronized void internSave(File file) throws DLTException, FileNotFoundException, IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            int n = (int)this.internSave((DataOutputStream)filterOutputStream) + 1;
            ((DataOutputStream)filterOutputStream).flush();
            filterOutputStream.close();
            filterOutputStream = null;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(26L);
            int n2 = randomAccessFile.readInt();
            randomAccessFile.seek(n2 + 4);
            randomAccessFile.writeInt(n);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new DLTException(exception.getClass().getName() + ":" + exception.getMessage());
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    public File getFile() {
        return this.dictionaryFile;
    }

    public void setFile(File file) {
        this.dictionaryFile = file;
    }

    public String toString() {
        DictionaryInfo dictionaryInfo = this.getSummary();
        return this.dictionaryFile != null ? this.dictionaryFile.getAbsolutePath() : "(no file) " + (dictionaryInfo != null ? dictionaryInfo.toString() : "[no summary]");
    }

    private final class GlossFactoryImpl
    implements GlossFactory {
        private Map cache = new HashMap();
        private Collection gSet = new LinkedList();

        private GlossFactoryImpl() {
            this.clear();
        }

        private void addFirst(Gloss gloss) throws DLTException {
            if (gloss == null) {
                throw new DLTException(Messages.getString("null.parameter"));
            }
            Iterator iterator = this.gSet.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                linkedList.addFirst(gloss);
            }
        }

        private void addLast(Gloss gloss) throws DLTException {
            if (gloss == null) {
                throw new DLTException(Messages.getString("null.parameter"));
            }
            Iterator iterator = this.gSet.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                linkedList.addLast(gloss);
            }
        }

        public void clear() {
            Iterator iterator = this.gSet.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                linkedList.clear();
            }
            this.gSet.clear();
            this.gSet.add(new LinkedList());
        }

        public Gloss createCatNameGloss(String string, int n) throws DLTException {
            return Dictionary.this.addCatNameGloss(string, n);
        }

        public Gloss createCutPasteGloss(String string, String string2, int n, int n2) throws DLTException {
            return Dictionary.this.addCutPasteGloss(string, string2, n, n2);
        }

        public Gloss createFeatureSetGloss(int n, int n2, int n3, int n4, int n5) throws DLTException {
            return Dictionary.this.addFeatureSetGloss(n, n2, n3, n4, n5);
        }

        public Gloss createGrammarGloss(int[] nArray, int n) throws DLTException {
            return Dictionary.this.addGrammarGloss(nArray, n);
        }

        public Gloss createIntegerGloss(int n, int n2) throws DLTException {
            return Dictionary.this.addIntegerGloss(n, n2);
        }

        public Gloss createJaGramSetGloss(String string, int n, int n2, int n3, long[] lArray, int n4) throws DLTException {
            return Dictionary.this.addJaGramSetGloss(lArray);
        }

        public Gloss createJaMorphGloss(int n, int n2, int n3, int n4) throws DLTException {
            return Dictionary.this.addJAMorphGloss(n, n2, n3, n4);
        }

        public Gloss[] createJkomBasedCollectionGls(int n, int n2) throws DLTException {
            Gloss[] glossArray = new Gloss[this.gSet.size()];
            int n3 = 0;
            Iterator iterator = this.gSet.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                Gloss[] glossArray2 = linkedList.toArray(new Gloss[linkedList.size()]);
                glossArray[n3++] = Dictionary.this.addJkomBasedCollectionGls(n, glossArray2, n2);
            }
            return glossArray;
        }

        public Gloss createLanguageGloss(String string, int n) throws DLTException {
            return Dictionary.this.addLanguageGloss(string, n);
        }

        public Gloss createLemmaGloss(String string, int n) throws DLTException {
            return Dictionary.this.addLemmaGloss(string, n);
        }

        public Gloss[] createMorphGloss(int n) throws DLTException {
            Gloss[] glossArray = new Gloss[this.gSet.size()];
            int n2 = 0;
            Iterator iterator = this.gSet.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                Gloss[] glossArray2 = linkedList.toArray(new Gloss[linkedList.size()]);
                glossArray[n2++] = Dictionary.this.addMorphGloss(glossArray2, n);
            }
            return glossArray;
        }

        public Gloss createPhoneticSpellingGloss(String string, int n) throws DLTException {
            return Dictionary.this.addPhoneticSpellingGloss(string, n);
        }

        public Gloss[] createPosBasedCollectionGloss(int n, int n2) throws DLTException {
            if ((n & 0xFFFFFF00) != 0) {
                throw new DLTException(Messages.getString("error.data"));
            }
            Gloss[] glossArray = new Gloss[this.gSet.size()];
            int n3 = 0;
            Iterator iterator = this.gSet.iterator();
            while (iterator.hasNext()) {
                LinkedList linkedList = (LinkedList)iterator.next();
                Gloss[] glossArray2 = linkedList.toArray(new Gloss[linkedList.size()]);
                glossArray[n3++] = Dictionary.this.addPosBasedCollectionGls(n, glossArray2, n2);
            }
            return glossArray;
        }

        public Gloss createStemGloss(String string, int n) throws DLTException {
            return Dictionary.this.addStemGloss(string, n);
        }

        public Gloss createSynGloss(String string, int n) throws DLTException {
            return Dictionary.this.addSynGloss(string, n);
        }

        public Gloss createTCRGloss(int n, int n2, int n3, String string, int n4) throws DLTException {
            return Dictionary.this.addTCRGloss(n, n2, n3, string, n4);
        }

        public Gloss createUserGloss(int n, byte[] byArray, int n2) throws DLTException {
            return Dictionary.this.addUserGloss(n, byArray, n2);
        }

        public void setCatNameGloss(String string, int n) throws DLTException {
            this.addLast(this.createCatNameGloss(string, n));
        }

        public void setCutPasteGloss(String string, String string2, int n, int n2) throws DLTException {
            this.addLast(this.createCutPasteGloss(string, string2, n, n2));
        }

        public void setFeatureSetGloss(int n, int n2, int n3, int n4, int n5) throws DLTException {
            this.addLast(this.createFeatureSetGloss(n, n2, n3, n4, n5));
        }

        public void setGrammarGloss(int[] nArray, int n) throws DLTException {
            this.addLast(this.createGrammarGloss(nArray, n));
        }

        public void setIntegerGloss(int n, int n2) throws DLTException {
            this.addLast(this.createIntegerGloss(n, n2));
        }

        public void setJaGramSetGloss(String string, int n, int n2, int n3, long[] lArray, int n4) throws DLTException {
            JaGramSetGloss jaGramSetGloss = null;
            if (n2 != 0) {
                JaTrHandler.Ternary ternary;
                HashMap<JaTrHandler.Ternary, JaGramSetGloss> hashMap = (HashMap<JaTrHandler.Ternary, JaGramSetGloss>)this.cache.get(string);
                if (hashMap == null) {
                    hashMap = new HashMap<JaTrHandler.Ternary, JaGramSetGloss>();
                    this.cache.put(string, hashMap);
                }
                if ((jaGramSetGloss = (JaGramSetGloss)hashMap.get(ternary = new JaTrHandler.Ternary(n, n2, n3))) == null) {
                    jaGramSetGloss = (JaGramSetGloss)this.createJaGramSetGloss(string, n, n2, n3, lArray, n4);
                    hashMap.put(ternary, jaGramSetGloss);
                } else {
                    jaGramSetGloss.add(lArray);
                }
                this.addFirst(jaGramSetGloss);
            }
        }

        public void setJaMorphGloss(int n, int n2, int n3, int n4) throws DLTException {
            if (!this.cache.containsKey("isSupportedJapaneseLex")) {
                this.cache.put("isSupportedJapaneseLex", Boolean.TRUE);
                this.supportJapaneseLex();
            }
            if (n2 == 0) {
                Collection collection;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                JaTrHandler.Ternary ternary = new JaTrHandler.Ternary(n, n2, n3);
                HashSet hashSet = (HashSet)this.cache.get(ternary);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    this.cache.put(ternary, hashSet);
                    Object object6 = object5 = n != 0 ? JaTrHandler.getInstance().getData1(n) : JaTrHandler.getInstance().getData2(n);
                    if (object5 != null) {
                        object4 = object5.entrySet();
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            Object object7;
                            object2 = (Map.Entry)object3.next();
                            object = (JaTrHandler.Ternary)object2.getKey();
                            collection = (Set)object2.getValue();
                            long[] lArray = new long[collection.size()];
                            int n5 = 0;
                            Object object8 = collection.iterator();
                            while (object8.hasNext()) {
                                object7 = (JaTrHandler.Ternary)object8.next();
                                lArray[n5++] = ((long)((JaTrHandler.Ternary)object7).val3 & 0xFFFFFFFFFFFFFFFFL) << 32 | ((long)((JaTrHandler.Ternary)object7).val1 & 0xFFFFL) << 16 | (long)((JaTrHandler.Ternary)object7).val2 & 0xFFFFL;
                            }
                            object8 = this.createJaMorphGloss(((JaTrHandler.Ternary)object).val1, ((JaTrHandler.Ternary)object).val2, ((JaTrHandler.Ternary)object).val3, 0);
                            object7 = this.createJaGramSetGloss(null, ((JaTrHandler.Ternary)object).val1, ((JaTrHandler.Ternary)object).val2, ((JaTrHandler.Ternary)object).val3, lArray, 0);
                            DLTPos dLTPos = JPOS.toPOS(((JaTrHandler.Ternary)object).val2);
                            int n6 = (((JaTrHandler.Ternary)object).val2 != 0 ? JPOS.isStopword(((JaTrHandler.Ternary)object).val2) : JKOM.isStopword(((JaTrHandler.Ternary)object).val1)) ? 1 : 0;
                            Gloss gloss = this.createFeatureSetGloss(dLTPos.toId(), 0, 0, n6, 0);
                            LinkedList<Object> linkedList = new LinkedList<Object>();
                            linkedList.add(object7);
                            linkedList.add(object8);
                            linkedList.add(gloss);
                            hashSet.add(linkedList);
                        }
                    }
                }
                object5 = new LinkedList();
                object4 = this.gSet.iterator();
                while (object4.hasNext()) {
                    object3 = (LinkedList)object4.next();
                    object2 = hashSet.iterator();
                    while (object2.hasNext()) {
                        object = (LinkedList)object2.next();
                        collection = new LinkedList(object);
                        ((LinkedList)collection).addAll(object3);
                        object5.add(collection);
                    }
                }
                this.clear();
                this.gSet = null;
                this.gSet = object5;
            } else {
                this.addLast(this.createJaMorphGloss(n, n2, n3, n4));
                DLTPos dLTPos = JPOS.toPOS(n2);
                int n7 = (n2 != 0 ? JPOS.isStopword(n2) : JKOM.isStopword(n)) ? 1 : 0;
                this.addLast(this.createFeatureSetGloss(dLTPos.toId(), 0, 0, n7, 0));
            }
        }

        public void setLanguageGloss(String string, int n) throws DLTException {
            this.addLast(this.createLanguageGloss(string, n));
        }

        public void setLemmaGloss(String string, int n) throws DLTException {
            this.addLast(this.createLemmaGloss(string, n));
        }

        public void setPhoneticSpellingGloss(String string, int n) throws DLTException {
            this.addLast(this.createPhoneticSpellingGloss(string, n));
        }

        public void setStemGloss(String string, int n) throws DLTException {
            this.addLast(this.createStemGloss(string, n));
        }

        public void setSynGloss(String string, int n) throws DLTException {
            this.addLast(this.createSynGloss(string, n));
        }

        public void setTCRGloss(int n, int n2, int n3, String string, int n4) throws DLTException {
            this.addLast(this.createTCRGloss(n, n2, n3, string, n4));
        }

        public void setUserGloss(int n, byte[] byArray, int n2) throws DLTException {
            this.addLast(this.createUserGloss(n, byArray, n2));
        }

        public Gloss createPcodeGloss(String string) throws DLTException {
            return Dictionary.this.addPcodeGloss(string);
        }

        public void setPcodeGloss(String string) throws DLTException {
            this.addLast(this.createPcodeGloss(string));
        }

        private void supportJapaneseLex() throws DLTException {
            if (this != Dictionary.this.gFactory) {
                class FuncOpr {
                    private final /* synthetic */ GlossFactoryImpl this$1;

                    FuncOpr(GlossFactoryImpl glossFactoryImpl) {
                        this.this$1 = glossFactoryImpl;
                    }

                    void process(String string, int n) throws DLTException {
                        GlossFactoryImpl.access$200((GlossFactoryImpl)this.this$1).gFactory.clear();
                        GlossFactoryImpl.access$200((GlossFactoryImpl)this.this$1).gFactory.setLemmaGloss("", 0);
                        GlossFactoryImpl.access$200((GlossFactoryImpl)this.this$1).gFactory.setLanguageGloss("ja", 0);
                        GlossFactoryImpl.access$200((GlossFactoryImpl)this.this$1).gFactory.setJaMorphGloss(n, 0, 0, 0);
                        DLTPos dLTPos = DLTPos.UNKNOWN;
                        int n2 = JKOM.isStopword(n) ? 1 : 0;
                        GlossFactoryImpl.access$200((GlossFactoryImpl)this.this$1).gFactory.setFeatureSetGloss(dLTPos.toId(), 0, 0, n2, 0);
                        Gloss[] glossArray = GlossFactoryImpl.access$200((GlossFactoryImpl)this.this$1).gFactory.createMorphGloss(0);
                        GlossFactoryImpl.access$200(this.this$1).addWord(string, glossArray);
                        GlossFactoryImpl.access$200((GlossFactoryImpl)this.this$1).gFactory.clear();
                    }
                }
                if (Dictionary.this.lookupWord("\ufffe__IBM_LANGUAGEWARE_4_JAPANESE_MICHIGO__") == null) {
                    new FuncOpr(this).process("\ufffe__IBM_LANGUAGEWARE_4_JAPANESE_MICHIGO__", 97);
                }
                if (Dictionary.this.lookupWord("\ufffe__IBM_LANGUAGEWARE_4_JAPANESE_MICHI_KOYUU_MEISHI__") == null) {
                    new FuncOpr(this).process("\ufffe__IBM_LANGUAGEWARE_4_JAPANESE_MICHI_KOYUU_MEISHI__", 104);
                }
                if (Dictionary.this.lookupWord("\ufffe__IBM_LANGUAGEWARE_4_JAPANESE_NUMERAL__") == null) {
                    new FuncOpr(this).process("\ufffe__IBM_LANGUAGEWARE_4_JAPANESE_NUMERAL__", 103);
                }
                if (Dictionary.this.lookupWord("\ufffe__IBM_LANGUAGEWARE_4_JAPANESE_LAST_EPSILON__") == null) {
                    new FuncOpr(this).process("\ufffe__IBM_LANGUAGEWARE_4_JAPANESE_LAST_EPSILON__", 0);
                }
            }
        }

        static /* synthetic */ Dictionary access$200(GlossFactoryImpl glossFactoryImpl) {
            return glossFactoryImpl.Dictionary.this;
        }
    }

    private class CountTraverse
    extends Traverse {
        private long count;

        private CountTraverse() {
        }

        public void process(Node node) {
            ++this.count;
        }

        public long count() {
            this.count = 0L;
            this.doTraverse(Dictionary.this.fsa.first());
            return this.count;
        }
    }
}

