/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.ConstraintChecker;
import com.ibm.dltj.Decomposer;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.Messages;
import com.ibm.dltj.ObjectBuffer;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.Node;
import java.text.CharacterIterator;

abstract class ConstraintDecomposer
implements Decomposer {
    public static final int DECOMP_POLICY_FIRST = 0;
    public static final int DECOMP_POLICY_ALL = 1;
    protected int policy = 1;
    protected CharacterIterator pItr;
    protected ConstraintChecker pChk;
    protected int num_decomp = -1;
    protected int upto_index;
    protected final MatchBuffer match_buffer = new MatchBuffer();
    protected final ObjectBuffer component_buffer = new ObjectBuffer();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    protected ConstraintDecomposer() {
        this.component_buffer.add(new Decomposer.Component());
    }

    public void reset() {
        this.num_decomp = 0;
    }

    protected void decompose(int n, int n2, CharacterIterator characterIterator, ConstraintChecker constraintChecker) {
        if (this.num_decomp == -1) {
            throw new IllegalStateException(Messages.getString("wrong.call.reset"));
        }
        this.upto_index = n;
        this.pItr = characterIterator;
        this.pChk = constraintChecker;
        this.match_buffer.clear();
        this.decompose(n, n2, (Decomposer.Component)this.component_buffer.getFirst(), this.pChk.init_state(), 0);
    }

    private void decompose(int n, int n2, Decomposer.Component component, Node node, int n3) {
        this.upto_index = this.upto_index > n ? this.upto_index : n;
        Decomposer.Component component2 = (Decomposer.Component)this.component_buffer.get(n3);
        if (component2 == null) {
            component2 = new Decomposer.Component();
            this.component_buffer.add(component2);
        }
        component.next = component2;
        int n4 = this.match_buffer.mpos;
        this.pItr.setIndex(n);
        this.lookup();
        block0: for (int i = this.match_buffer.mpos - 1; i >= n4; --i) {
            if (!this.can_proceed()) {
                return;
            }
            GlossCollection glossCollection = (GlossCollection)this.match_buffer.gloss[i];
            int n5 = this.match_buffer.index[i];
            GlossListElement glossListElement = glossCollection.first;
            while (glossListElement != null) {
                if (!this.can_proceed()) {
                    return;
                }
                Node node2 = this.pChk.next_state(glossListElement, node, n5, n2);
                if (node2 != null) {
                    int n6 = this.pChk.next_index(glossCollection, node2, n5, n2);
                    component2.start = n;
                    component2.end = n6;
                    component2.element = this.pChk.get_element(node2, glossCollection);
                    if (this.pChk.is_final(glossCollection, node2, n6, n2)) {
                        component2.next = null;
                        this.store_sequence(n, n6, (Decomposer.Component)this.component_buffer.getFirst(), this.num_decomp++);
                        continue block0;
                    }
                    this.decompose(n6, n2, component2, node2, n3 + 1);
                    continue block0;
                }
                glossListElement = glossListElement.next;
            }
        }
        this.match_buffer.mpos = n4;
    }

    protected abstract void lookup();

    protected boolean can_proceed() {
        return this.policy == 1 ? true : this.num_decomp == 0;
    }
}

