/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.Buffer;
import com.ibm.dltj.Messages;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.Poolable;

public class CharacterBuffer
implements Buffer,
Poolable {
    public static final int DLTAID_MAX_STRLEN = 127;
    public int length;
    public char[] string;
    public int id = -1;
    public Pool pool = null;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public boolean equals(CharacterBuffer characterBuffer) {
        if (characterBuffer.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (characterBuffer.string[i] == this.string[i]) continue;
            return false;
        }
        return true;
    }

    public CharacterBuffer() {
        this.init(127);
    }

    public CharacterBuffer(String string) {
        this.init(string.length());
        if (this.string != null) {
            System.arraycopy(string.toCharArray(), 0, this.string, 0, string.length());
            this.length = string.length();
        }
    }

    public CharacterBuffer(int n) {
        this.init(n);
    }

    protected void init(int n) {
        this.length = 0;
        this.string = (char[])(n > 127 ? null : new char[n]);
    }

    public String toString() {
        return new String(this.string, 0, this.length);
    }

    public void addAll(Buffer buffer) {
        throw new IllegalArgumentException(Messages.getString("notimplement"));
    }

    public void clear() {
        this.length = 0;
    }

    public int grow() {
        char[] cArray = new char[this.string.length * 2];
        System.arraycopy(this.string, 0, cArray, 0, this.string.length);
        this.string = cArray;
        return this.string.length;
    }

    public int limit() {
        return this.string.length;
    }

    public void add(char c) {
        if (this.string.length == this.length) {
            this.grow();
        }
        this.string[this.length] = c;
        ++this.length;
    }

    public int position() {
        return this.length;
    }

    public int remaining() {
        return this.string.length - this.length;
    }

    public void reg4pool(int n, Pool pool) {
        this.id = n;
        this.pool = pool;
    }
}

