/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.DictionaryInfo;
import com.ibm.dltj.Messages;
import com.ibm.dltj.PatternNameFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class CapMatrix {
    private String theDataSpec = "";
    private Collection entries = new LinkedList();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public CapMatrix(String string) throws DLTException {
        this.setDataSpec(string);
    }

    public synchronized String[] getAvailableLangs() throws DLTException {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            DictionaryInfo dictionaryInfo = entry.getDictInfo();
            Object[] objectArray = dictionaryInfo.getLanguages();
            if (objectArray == null) continue;
            CapMatrix.addAll(hashSet, objectArray);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public Integer[] getAvailableFuncs(Locale locale) throws DLTException {
        return this.getAvailableFuncs(locale, LocaleComparator.COMP);
    }

    public Integer[] getAvailableFuncs(String string) throws DLTException {
        return this.getAvailableFuncs(string, StringComparator.COMP);
    }

    private synchronized Integer[] getAvailableFuncs(Object object, Comparator comparator) {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            DictionaryInfo dictionaryInfo = entry.getDictInfo();
            String[] stringArray = dictionaryInfo.getLanguages();
            for (int i = 0; i < stringArray.length; ++i) {
                Object[] objectArray;
                if (comparator.compare(object, stringArray[i]) != 0 || (objectArray = dictionaryInfo.getFunctions(stringArray[i])) == null) continue;
                CapMatrix.addAll(hashSet, objectArray);
            }
        }
        return hashSet.toArray(new Integer[hashSet.size()]);
    }

    public synchronized Entry getEntryByFilename(String string) throws DLTException {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            File file = entry.getFile();
            if (!file.getName().equalsIgnoreCase(string)) continue;
            return entry;
        }
        return null;
    }

    public synchronized Entry getEntryByFile(File file) throws DLTException {
        Entry entry;
        if (file == null || !file.exists()) {
            throw new DLTException(Messages.getString("file.notexist"));
        }
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            entry = (Entry)iterator.next();
            File file2 = entry.getFile();
            if (!file.equals(file2)) continue;
            return entry;
        }
        entry = null;
        try {
            entry = new Entry(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DLTException(Messages.getString("file.notexist"));
        }
        catch (IOException iOException) {
            throw new DLTException(Messages.getString("invalid.dict") + "\n" + iOException.getLocalizedMessage());
        }
        if (entry != null) {
            this.entries.add(entry);
        }
        return entry;
    }

    public Entry[] getAvailableEntries(String string, int n) throws DLTException {
        Collection collection = this.getAvailableEntries((Object)string, n, StringComparator.COMP);
        return collection.toArray(new Entry[collection.size()]);
    }

    private synchronized Collection getAvailableEntries(Object object, int n, Comparator comparator) {
        HashSet<Entry> hashSet = new HashSet<Entry>();
        Integer n2 = n != 0 ? new Integer(n) : null;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            DictionaryInfo dictionaryInfo = entry.getDictInfo();
            String[] stringArray = dictionaryInfo.getLanguages();
            block1: for (int i = 0; i < stringArray.length; ++i) {
                Integer[] integerArray;
                if (comparator.compare(object, stringArray[i]) != 0 || (integerArray = dictionaryInfo.getFunctions(stringArray[i])) == null) continue;
                if (n2 == null) {
                    hashSet.add(entry);
                    continue;
                }
                for (int j = 0; j < integerArray.length; ++j) {
                    if (!integerArray[j].equals(n2)) continue;
                    hashSet.add(entry);
                    continue block1;
                }
            }
        }
        return hashSet;
    }

    public Entry[] getAvailableEntries(String string, int[] nArray) throws DLTException {
        return this.getAvailableEntries((Object)string, nArray, StringComparator.COMP);
    }

    public Entry[] getEntries(Locale locale, int[] nArray) throws DLTException {
        return this.getAvailableEntries((Object)locale, nArray, LocaleComparator.COMP);
    }

    public synchronized Entry[] getAllEntries() {
        Entry[] entryArray = new Entry[this.entries.size()];
        this.entries.toArray(entryArray);
        return entryArray;
    }

    private synchronized Entry[] getAvailableEntries(Object object, int[] nArray, Comparator comparator) {
        HashSet<Entry> hashSet = new HashSet<Entry>();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            DictionaryInfo dictionaryInfo = entry.getDictInfo();
            String[] stringArray = dictionaryInfo.getLanguages();
            block1: for (int i = 0; i < stringArray.length; ++i) {
                Integer[] integerArray;
                if (comparator.compare(object, stringArray[i]) != 0 || (integerArray = dictionaryInfo.getFunctions(stringArray[i])) == null) continue;
                if (nArray == null) {
                    hashSet.add(entry);
                    continue;
                }
                block2: for (int j = 0; j < nArray.length; ++j) {
                    int n = nArray[j];
                    for (int k = 0; k < integerArray.length; ++k) {
                        int n2 = integerArray[k];
                        if (n > 0) {
                            if (n2 != n) continue;
                            continue block2;
                        }
                        if (n2 == -n) continue block1;
                    }
                    if (n > 0) continue block1;
                }
                hashSet.add(entry);
            }
        }
        return hashSet.toArray(new Entry[hashSet.size()]);
    }

    public File[] getAvailableFiles(Locale locale, int n) throws DLTException {
        return this.getAvailableFiles(locale, n, LocaleComparator.COMP);
    }

    public File[] getAvailableFiles(String string, int n) throws DLTException {
        return this.getAvailableFiles(string, n, StringComparator.COMP);
    }

    private synchronized File[] getAvailableFiles(Object object, int n, Comparator comparator) {
        Collection collection = this.getAvailableEntries(object, n, comparator);
        File[] fileArray = new File[collection.size()];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            fileArray[n2] = ((Entry)iterator.next()).getFile();
            ++n2;
        }
        return fileArray;
    }

    public synchronized Dictionary[] getActivatedDicts() {
        HashSet<Dictionary> hashSet = new HashSet<Dictionary>();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.isActivated()) continue;
            hashSet.add(entry.getDict());
        }
        return hashSet.toArray(new Dictionary[hashSet.size()]);
    }

    public synchronized Entry[] activate(Locale locale, int n) throws DLTException {
        return this.activate(locale, n, LocaleComparator.COMP);
    }

    public synchronized Entry[] activate(String string, int n) throws DLTException {
        return this.activate(string, n, StringComparator.COMP);
    }

    private Entry[] activate(Object object, int n, Comparator comparator) throws DLTException {
        HashSet<Entry> hashSet = new HashSet<Entry>();
        Integer n2 = n != 0 ? new Integer(n) : null;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            DictionaryInfo dictionaryInfo = entry.getDictInfo();
            String[] stringArray = dictionaryInfo.getLanguages();
            block1: for (int i = 0; i < stringArray.length; ++i) {
                Integer[] integerArray;
                if (comparator.compare(object, stringArray[i]) != 0 || (integerArray = dictionaryInfo.getFunctions(stringArray[i])) == null) continue;
                if (n2 == null) {
                    entry.activate();
                    hashSet.add(entry);
                    continue;
                }
                for (int j = 0; j < integerArray.length; ++j) {
                    if (!integerArray[j].equals(n2)) continue;
                    entry.activate();
                    hashSet.add(entry);
                    continue block1;
                }
            }
        }
        return hashSet.toArray(new Entry[hashSet.size()]);
    }

    public synchronized void deactivateAll() throws DLTException {
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            entry.deactivate();
        }
    }

    public synchronized void deactivateFuzzy(int n) throws DLTException {
        Collection<Entry> collection;
        Object object;
        TreeMap<Object, ArrayList<Entry>> treeMap = new TreeMap<Object, ArrayList<Entry>>();
        int n2 = 0;
        Iterator<Object> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.isActivated() || entry.isNoDeactivateFuzzy()) continue;
            object = new Long(entry.getActivatedTime());
            collection = (Collection)treeMap.get(object);
            if (collection == null) {
                collection = new ArrayList<Entry>();
                treeMap.put(object, (ArrayList<Entry>)collection);
            }
            collection.add(entry);
            ++n2;
        }
        int n3 = n2 - n;
        if (n3 <= 0) {
            return;
        }
        iterator = treeMap.values().iterator();
        do {
            object = (Collection)iterator.next();
            collection = object.iterator();
            while (collection.hasNext() && n3 > 0) {
                Entry entry = (Entry)collection.next();
                entry.deactivate();
                --n3;
            }
        } while (n3 > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry registerDictionary(File file, Dictionary dictionary) throws DLTException {
        Object object = dictionary.readLockObject;
        synchronized (object) {
            Entry entry = new Entry(file, dictionary);
            this.entries.add(entry);
            return entry;
        }
    }

    public synchronized void registerEntry(Entry entry) throws DLTException {
        this.entries.add(entry);
    }

    public synchronized String getDataSpec() {
        return this.theDataSpec;
    }

    public synchronized void setDataSpec(String string) {
        this.setDataSpec(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDataSpec(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.theDataSpec = string;
        Map map = this.getEntriesMap();
        Set set = CapMatrix.getRequestedFiles(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.isFile()) continue;
            try {
                Object object;
                Entry entry = (Entry)map.get(file);
                if (entry != null) {
                    object = new DictionaryInfo();
                    Dictionary.readHeader(file, (DictionaryInfo)object);
                    Entry entry2 = entry;
                    synchronized (entry2) {
                        if (!bl || ((DictionaryInfo)object).equals(entry.getDictInfo())) {
                            continue;
                        }
                    }
                }
                object = new Entry(file);
                this.entries.add(object);
            }
            catch (DLTException dLTException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
    }

    private Map getEntriesMap() {
        HashMap<File, Entry> hashMap = new HashMap<File, Entry>();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            hashMap.put(entry.getFile(), entry);
        }
        return hashMap;
    }

    private static Set getRequestedFiles(String string) {
        HashSet<File> hashSet = new HashSet<File>();
        char c = File.pathSeparatorChar;
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(c, n2);
            String string2 = string.substring(n2, n != -1 ? n : string.length());
            File file = new File(string2);
            if (file.isDirectory()) {
                CapMatrix.addAll(hashSet, file.listFiles());
            } else if (file.isFile()) {
                hashSet.add(file);
            } else {
                String string3 = file.getName();
                String string4 = file.getAbsolutePath();
                string4 = string4.substring(0, string4.length() - string3.length());
                File file2 = new File(string4);
                CapMatrix.addAll(hashSet, file2.listFiles(new PatternNameFilter(string3)));
            }
            n2 = n + 1;
        }
        return hashSet;
    }

    private static void addAll(Set set, Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            set.add(objectArray[i]);
        }
    }

    public void setDictCacheSize(int n) {
    }

    public int getDictCacheSize() {
        return 0;
    }

    static Locale parseLocale(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-_");
        String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        String string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        return new Locale(string2, string3, string4);
    }

    private static class LocaleComparator
    implements Comparator {
        static final Comparator COMP = new LocaleComparator();

        private LocaleComparator() {
        }

        public int compare(Object object, Object object2) {
            return PatternNameFilter.localeWildmatch((Locale)object, CapMatrix.parseLocale((String)object2)) ? 0 : 1;
        }
    }

    private static class StringComparator
    implements Comparator {
        static final Comparator COMP = new StringComparator();

        private StringComparator() {
        }

        public int compare(Object object, Object object2) {
            return PatternNameFilter.langNameWildmatch((String)object, (String)object2) ? 0 : 1;
        }
    }

    public static class Entry {
        private Reference dict;
        private DictionaryInfo cachedInfo;
        private final File file;
        private final String description;
        private long activatedTime;
        private boolean noDeactivateFuzzy;

        Entry(File file) throws FileNotFoundException, IOException, DLTException {
            this.file = file;
            this.dict = new SoftReference<Object>(null);
            this.cachedInfo = new DictionaryInfo();
            Dictionary.readHeader(this.file, this.cachedInfo);
            this.description = this.buildDescription();
        }

        Entry(File file, Dictionary dictionary) throws DLTException {
            if (dictionary == null || !dictionary.valid()) {
                throw new DLTException(Messages.getString("invalid.dict"));
            }
            this.file = file;
            this.dict = new SoftReference<Dictionary>(dictionary);
            this.cachedInfo = dictionary.getSummary();
            this.description = this.buildDescription();
        }

        private String buildDescription() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.file.getName());
            stringBuffer.append('(');
            String[] stringArray = this.cachedInfo.getLanguages();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append(')');
            if (stringBuffer.capacity() > stringBuffer.length()) {
                return new String(stringBuffer.toString());
            }
            return stringBuffer.toString();
        }

        public File getFile() {
            return this.file;
        }

        public synchronized DictionaryInfo getDictInfo() {
            return this.cachedInfo;
        }

        public Dictionary getDict() {
            try {
                return this.activate();
            }
            catch (DLTException dLTException) {
                return null;
            }
        }

        public synchronized Dictionary activate() throws DLTException {
            return this.activate(true);
        }

        public synchronized Dictionary activate(boolean bl) throws DLTException {
            Dictionary dictionary = (Dictionary)this.dict.get();
            if (dictionary == null || !dictionary.valid()) {
                dictionary = new Dictionary(this.file, bl);
                this.dict = new SoftReference<Dictionary>(dictionary);
                this.cachedInfo = dictionary.getSummary();
            }
            this.activatedTime = System.currentTimeMillis();
            return dictionary;
        }

        public synchronized void deactivate() {
            this.dict.clear();
        }

        public synchronized boolean isActivated() {
            Dictionary dictionary = (Dictionary)this.dict.get();
            return dictionary != null && dictionary.valid();
        }

        public String getDescription() {
            return this.description;
        }

        public long getActivatedTime() {
            return this.activatedTime;
        }

        public boolean isNoDeactivateFuzzy() {
            return this.noDeactivateFuzzy;
        }

        public void setNoDeactivateFuzzy(boolean bl) {
            this.noDeactivateFuzzy = bl;
        }

        public String toString() {
            return this.description;
        }
    }
}

