/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class AutoGlossSupport {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    private AutoGlossSupport() {
    }

    public static int getHashCode(List list) {
        int n = 17;
        if (list == null) {
            return n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            n = n * 37 + e.hashCode();
        }
        return n;
    }

    public static void readStringList(DataInputStream dataInputStream, List list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(dataInputStream.readUTF());
        }
    }

    public static void writeStringList(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeInt(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            dataOutputStream.writeUTF(string);
        }
    }

    public static void readBooleanList(DataInputStream dataInputStream, List list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(dataInputStream.readBoolean());
        }
    }

    public static void writeBooleanList(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeInt(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Boolean bl = (Boolean)iterator.next();
            dataOutputStream.writeBoolean(bl);
        }
    }

    public static void readByteList(DataInputStream dataInputStream, List list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(new Byte(dataInputStream.readByte()));
        }
    }

    public static void writeByteList(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeInt(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Byte by = (Byte)iterator.next();
            dataOutputStream.writeByte(by.byteValue());
        }
    }

    public static void readIntegerList(DataInputStream dataInputStream, List list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(new Integer(dataInputStream.readInt()));
        }
    }

    public static void writeIntegerList(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeInt(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            dataOutputStream.writeInt(n);
        }
    }

    public static void readShortList(DataInputStream dataInputStream, List list) throws IOException {
        list.clear();
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            list.add(new Short(dataInputStream.readShort()));
        }
    }

    public static void writeShortList(DataOutputStream dataOutputStream, List list) throws IOException {
        dataOutputStream.writeInt(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Short s = (Short)iterator.next();
            dataOutputStream.writeShort(s.shortValue());
        }
    }

    public static int compareList(List list, List list2) {
        if (list.size() != list2.size()) {
            return list.size() - list2.size();
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            Comparable comparable;
            Comparable comparable2 = (Comparable)iterator.next();
            int n = comparable2.compareTo(comparable = (Comparable)iterator2.next());
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public static String readString(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readUTF();
    }

    public static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeUTF(string);
    }

    public static Boolean readBoolean(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readBoolean();
    }

    public static void writeBoolean(DataOutputStream dataOutputStream, Boolean bl) throws IOException {
        dataOutputStream.writeBoolean(bl);
    }

    public static Byte readByte(DataInputStream dataInputStream) throws IOException {
        return new Byte(dataInputStream.readByte());
    }

    public static void writeByte(DataOutputStream dataOutputStream, Byte by) throws IOException {
        dataOutputStream.writeByte(by.byteValue());
    }

    public static Integer readInteger(DataInputStream dataInputStream) throws IOException {
        return new Integer(dataInputStream.readInt());
    }

    public static void writeInteger(DataOutputStream dataOutputStream, Integer n) throws IOException {
        dataOutputStream.writeInt(n);
    }

    public static Short readShort(DataInputStream dataInputStream) throws IOException {
        return new Short(dataInputStream.readShort());
    }

    public static void writeShort(DataOutputStream dataOutputStream, Short s) throws IOException {
        dataOutputStream.writeShort(s.shortValue());
    }

    public static Long readLong(DataInputStream dataInputStream) throws IOException {
        return new Long(dataInputStream.readLong());
    }

    public static void writeLong(DataOutputStream dataOutputStream, Long l) throws IOException {
        dataOutputStream.writeLong(l);
    }

    public static Float readFloat(DataInputStream dataInputStream) throws IOException {
        return new Float(dataInputStream.readFloat());
    }

    public static void writeFloat(DataOutputStream dataOutputStream, Float f) throws IOException {
        dataOutputStream.writeFloat(f.floatValue());
    }

    public static Double readDouble(DataInputStream dataInputStream) throws IOException {
        return new Double(dataInputStream.readDouble());
    }

    public static void writeDouble(DataOutputStream dataOutputStream, Double d) throws IOException {
        dataOutputStream.writeDouble(d);
    }
}

