/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.file.FileAdapter;
import com.ibm.es.nuvo.crawler.util.fenced.ProcessManager;
import java.io.File;

public class WinApiHandler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private boolean isWindows;
    protected ProcessManager securityService;

    public WinApiHandler() throws AdapterException {
        try {
            this.setSecurityService(null);
            if (FileAdapter.isGlobalACLSupport()) {
                this.checkWindows();
                if (this.isWindows()) {
                    this.setSecurityService(ProcessManager.getInstance());
                }
            }
        }
        catch (ExtendedException ee) {
            throw new AdapterException((Throwable)ee);
        }
    }

    public ProcessManager getSecurityService() {
        return this.securityService;
    }

    private void setSecurityService(ProcessManager ss) {
        this.securityService = ss;
    }

    private void checkWindows() {
        if (File.separator.equals("/")) {
            this.setWindows(false);
        } else {
            this.setWindows(true);
        }
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    private void setWindows(boolean b) {
        this.isWindows = b;
    }
}

