/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.crawler.adapter.file.FSFile;
import com.ibm.es.nuvo.crawler.adapter.file.FSFileFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class WildcardSubDirectoryFilter
implements FSFileFilter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String pattern;
    private List<String> tokens;
    private boolean isExactMatch = false;
    private boolean isWildcardEnd = false;
    private boolean caseSensitive = File.separatorChar != '\\';
    private boolean isDirectoryPattetn = false;
    private boolean inverseDecision = false;

    public WildcardSubDirectoryFilter(String pattern) {
        String string = this.pattern = this.caseSensitive ? pattern : pattern.toLowerCase();
        if (this.pattern.endsWith(File.separator)) {
            this.isDirectoryPattetn = true;
            this.pattern = this.pattern.substring(0, this.pattern.length() - File.separator.length());
        }
        if (this.pattern.startsWith("-")) {
            this.pattern = this.pattern.substring(1);
            this.inverseDecision = true;
            this.pattern = String.valueOf(this.pattern) + File.separator;
        }
        this.tokens = new ArrayList<String>();
        this.isExactMatch = !this.pattern.contains("*");
        boolean bl = this.isWildcardEnd = this.pattern.endsWith("*");
        if (!this.isExactMatch) {
            StringTokenizer tokenizer = new StringTokenizer(this.pattern, "*");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                this.tokens.add(token);
            }
        }
    }

    public boolean accept(FSFile file) {
        boolean result = true;
        if (file != null && file.isDirectory()) {
            if (!this.inverseDecision) {
                result = this.acceptChildren(file);
            }
        } else if (file != null && file.isFile()) {
            String filePath = "";
            if (!this.isDirectoryPattetn) {
                filePath = file.getAbsolutePath();
            } else {
                filePath = file.getParent();
                if (this.isWildcardEnd && !filePath.endsWith(File.separator)) {
                    filePath = String.valueOf(filePath) + File.separator;
                }
            }
            result = this.inverseDecision ? file.getAbsolutePath().contains(this.pattern) : !this.match(filePath);
        }
        return result;
    }

    public boolean acceptChildren(FSFile file) {
        if (file != null && file.isDirectory()) {
            String dirname = file.getAbsolutePath();
            if (this.isWildcardEnd && !dirname.endsWith(File.separator)) {
                dirname = String.valueOf(dirname) + File.separator;
            }
            return !this.match(dirname);
        }
        return false;
    }

    public boolean match(String filepath) {
        String lastToken = null;
        if (filepath != null) {
            if (!this.caseSensitive) {
                filepath = filepath.toLowerCase();
            }
            if (this.isExactMatch) {
                if (filepath.equals(this.pattern)) {
                    return true;
                }
                if (filepath.startsWith(this.pattern)) {
                    String tail = filepath.substring(this.pattern.length());
                    return tail.startsWith(File.separator);
                }
                return false;
            }
            for (String token : this.tokens) {
                int index;
                block13: {
                    try {
                        index = filepath.indexOf(token);
                        if (index != -1) break block13;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                filepath = filepath.substring(index + token.length(), filepath.length());
                lastToken = token;
            }
            if (filepath.length() == 0) {
                return true;
            }
            if (filepath.startsWith(File.separator)) {
                return true;
            }
            if (!this.isWildcardEnd) {
                if (filepath.contains(lastToken)) {
                    filepath = filepath.substring(filepath.lastIndexOf(lastToken) + 1, filepath.length());
                }
                return filepath.length() == 0;
            }
            return true;
        }
        return false;
    }
}

