/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Stack;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwapFiledStack<T> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_THRESHOLD = 10000;
    private static final int DEFAULT_CAPACITY = 100;
    private static final ExtendedLogger logger = ExtendedLogger.getLogger((String)("com.ibm.es.nuvo." + SwapFiledStack.class.getName()));
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger((String)("NuvoTracer." + SwapFiledStack.class.getName()));
    private Stack<T> stack = new Stack();
    private File swapDir;
    private Stack<File> swapFiles = new Stack();
    private int threshold;
    private int initial;

    public SwapFiledStack(int threshold, File swapDir) {
        this.threshold = threshold;
        this.initial = 100;
        this.swapDir = swapDir;
    }

    public SwapFiledStack(int initial, int threshold, File swapDir) {
        this(threshold, swapDir);
        this.stack.ensureCapacity(initial);
        this.initial = initial;
    }

    public SwapFiledStack(int threshold) {
        this(threshold, new File(System.getProperty("java.io.tmpdir")));
    }

    public SwapFiledStack() {
        this(10000);
    }

    public boolean empty() {
        return this.stack.empty() && this.swapFiles.empty();
    }

    public void clear() {
        this.stack.clear();
        while (!this.swapFiles.empty()) {
            File file = this.swapFiles.pop();
            file.delete();
        }
    }

    public Object pop() {
        if (this.stack.empty() && !this.swapFiles.empty()) {
            this.loadStack();
        }
        return this.stack.pop();
    }

    public T push(T item) {
        if (this.stack.size() >= this.threshold) {
            this.storeStack();
        }
        return this.stack.push(item);
    }

    private void storeStack() {
        block8: {
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "exceed the item size threshold.");
            }
            try {
                File file = File.createTempFile("~esfsp", ".tmp", this.swapDir);
                try {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "storing the items into the temporary file " + file.getAbsolutePath());
                    }
                    ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
                    out.writeObject(this.stack);
                    this.swapFiles.push(file);
                    out.close();
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "successfully stored the items into the temporary file " + file.getAbsolutePath());
                    }
                    this.stack = new Stack();
                    this.stack.ensureCapacity(this.initial);
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        Message msg = new Message("C4506E.FILE_FAILED_TO_STORE_TMPFILE");
                        msg.addArgument((Object)file);
                        ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                        logger.log(Level.SEVERE, ee);
                    }
                }
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.SEVERE)) break block8;
                Message msg = new Message("C4504E.FILE_NOT_CREATE_TEMPFILE");
                msg.addArgument((Object)this.swapDir);
                ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                logger.log(Level.SEVERE, ee);
            }
        }
    }

    private void loadStack() {
        block6: {
            File file = this.swapFiles.pop();
            try {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "trying to load the item from the temporary file " + file.getAbsolutePath());
                }
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                this.stack = (Stack)in.readObject();
                in.close();
                file.delete();
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "successfully loaded the item from the temporary file " + file.getAbsolutePath());
                }
            }
            catch (ClassNotFoundException e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    Message msg = new Message("C4505E.FILE_FAILED_TO_LOAD_TMPFILE");
                    msg.addArgument(file.getAbsolutePath());
                    ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                    logger.log(Level.SEVERE, ee);
                }
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.SEVERE)) break block6;
                Message msg = new Message("C4505E.FILE_FAILED_TO_LOAD_TMPFILE");
                msg.addArgument(file.getAbsolutePath());
                ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                logger.log(Level.SEVERE, ee);
            }
        }
    }
}

