/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.crawler.adapter.file.FSFile;
import com.ibm.es.nuvo.crawler.adapter.file.FSFileFilter;
import java.io.File;

public class SubDirectoryFilter
implements FSFileFilter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int LEVEL_INFINITE = -1;
    private final FSFile filterRoot;
    private String filter;
    private final int filterLevel;
    private final boolean caseSensitive;

    public SubDirectoryFilter(FSFile filterRoot, int filterLevel) {
        this.filterRoot = filterRoot;
        this.filterLevel = filterLevel;
        this.filterRoot.activate();
        this.caseSensitive = File.separatorChar != '\\';
        String string = this.filter = this.caseSensitive ? this.filterRoot.getAbsolutePath() : this.filterRoot.getAbsolutePath().toLowerCase();
        if (this.filter.endsWith("*")) {
            this.filter = this.filter.substring(0, this.filter.length() - "*".length());
        }
    }

    public boolean accept(FSFile file) {
        String filename = file.getAbsolutePath();
        if (this.contains(filename)) {
            if (this.filterLevel == -1) {
                return false;
            }
            int diffLevel = file.getDirLevel() - this.filterRoot.getDirLevel();
            return diffLevel < 0 || diffLevel > this.filterLevel;
        }
        return true;
    }

    public boolean acceptChildren(FSFile file) {
        if (file != null && file.isDirectory()) {
            String filename = file.getAbsolutePath();
            return this.filterLevel != -1 || !this.contains(filename);
        }
        return false;
    }

    private boolean contains(String filepath) {
        if (filepath != null) {
            if (!this.caseSensitive) {
                filepath = filepath.toLowerCase();
            }
            return filepath.startsWith(this.filter);
        }
        return false;
    }
}

