/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.crawler.adapter.file.FSFile;
import com.ibm.es.nuvo.crawler.adapter.file.FSFileFilter;
import java.io.File;
import java.util.regex.Pattern;

public class SimpleFileFilter
implements FSFileFilter {
    private static final char SEPARATOR = File.separatorChar;
    private static final String WILDCARD_DIR_PATTERN = "(?:.*\\" + SEPARATOR + ")?";
    private static final String NOT_SEPARATOR_PATTERN = "[^\\" + SEPARATOR + "]";
    private boolean caseSensitive;
    private Pattern pattern;
    private int cutLength;
    private boolean dirRule;
    private boolean exclude;

    public SimpleFileFilter(String patternStr, File spaceDir) {
        this.cutLength = spaceDir.getAbsolutePath().length();
        if (patternStr.startsWith("!")) {
            this.dirRule = true;
            patternStr = patternStr.substring(1);
        } else {
            this.dirRule = false;
        }
        this.exclude = patternStr.startsWith("-");
        this.caseSensitive = File.separatorChar != '\\';
        patternStr = this.fix(patternStr);
        this.pattern = Pattern.compile(this.makeRegexPatternStr(patternStr.substring(1)));
    }

    private String fix(String str) {
        str = str.replace('\\', SEPARATOR);
        str = str.replace('/', SEPARATOR);
        return str;
    }

    /*
     * Unable to fully structure code
     */
    private String makeRegexPatternStr(String input) {
        result = new StringBuilder();
        if (!this.caseSensitive) {
            result.append("(?i)");
            input = input.toLowerCase();
        }
        numStars = 0;
        endsWithDir = false;
        i = 0;
        while (i < input.length()) {
            block12: {
                block11: {
                    c = input.charAt(i);
                    if (c != '*') break block11;
                    ++numStars;
                    break block12;
                }
                if (numStars < 2) ** GOTO lbl23
                if (c == SimpleFileFilter.SEPARATOR || i == input.length() - 1) {
                    result.append(SimpleFileFilter.WILDCARD_DIR_PATTERN);
                    endsWithDir = true;
                    numStars = 0;
                } else {
                    numStars = 1;
lbl23:
                    // 2 sources

                    endsWithDir = false;
                    if (numStars == 1) {
                        result.append(SimpleFileFilter.NOT_SEPARATOR_PATTERN).append('*');
                        numStars = 0;
                    }
                    if (c == '?') {
                        result.append(SimpleFileFilter.NOT_SEPARATOR_PATTERN).append('?');
                    } else {
                        if (c == SimpleFileFilter.SEPARATOR) {
                            endsWithDir = true;
                        }
                        result.append("\\Q");
                        result.append(c);
                        result.append("\\E");
                    }
                }
            }
            ++i;
        }
        if (numStars >= 2) {
            result.append(SimpleFileFilter.WILDCARD_DIR_PATTERN);
            endsWithDir = false;
            numStars = 0;
        }
        if (numStars == 1) {
            result.append(SimpleFileFilter.NOT_SEPARATOR_PATTERN).append('*');
            numStars = 0;
            endsWithDir = false;
        }
        if (endsWithDir) {
            result.append(SimpleFileFilter.WILDCARD_DIR_PATTERN);
        }
        return result.toString();
    }

    public String toOriginal() {
        String result = this.pattern.pattern();
        if (this.caseSensitive && result.length() >= 4) {
            result = result.substring(4);
        }
        result = result.replace(NOT_SEPARATOR_PATTERN, "");
        result = result.replace(WILDCARD_DIR_PATTERN, "**/");
        result = result.replace("\\Q", "");
        result = result.replace("\\E", "");
        result = this.exclude ? String.valueOf('-') + result : String.valueOf('+') + result;
        result = result.replace('\\', '/');
        return result;
    }

    private String getShortenedName(FSFile file) {
        String result = file.getAbsolutePath().substring(this.cutLength);
        if (result.charAt(0) == '/' || result.charAt(0) == '\\') {
            result = result.substring(1);
        }
        return result;
    }

    public boolean accept(FSFile file) {
        String shortName = this.getShortenedName(file);
        boolean result = this.pattern.matcher(shortName).matches();
        if (this.exclude) {
            result = !result;
        }
        return result;
    }

    public boolean acceptChildren(FSFile file) {
        return this.accept(file);
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public boolean isDirRule() {
        return this.dirRule;
    }
}

