/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.crawler.adapter.file.FSFile;
import com.ibm.es.nuvo.crawler.adapter.file.FSFileFilter;
import com.ibm.es.nuvo.crawler.adapter.file.FileCursor;
import java.util.ArrayList;
import java.util.List;

public abstract class FilteredFileCursor
implements FileCursor {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<FSFileFilter> filters = null;

    protected boolean accept(FSFile file) {
        boolean accept = true;
        if (this.filters != null) {
            int size = this.filters.size();
            int i = 0;
            while (i < size && accept) {
                accept &= this.filters.get(i).accept(file);
                ++i;
            }
        }
        return accept;
    }

    protected boolean acceptChildren(FSFile file) {
        boolean accept = true;
        if (this.filters != null) {
            int size = this.filters.size();
            int i = 0;
            while (i < size && accept) {
                accept &= this.filters.get(i).acceptChildren(file);
                ++i;
            }
        }
        return accept;
    }

    public void addFilter(FSFileFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<FSFileFilter>();
        }
        this.filters.add(filter);
    }

    public void removeFilter(FSFileFilter filter) {
        if (this.filters != null) {
            this.filters.remove(filter);
            if (this.filters.size() == 0) {
                this.filters = null;
            }
        }
    }
}

