/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ItemFinder;
import com.ibm.es.nuvo.crawler.adapter.ItemSet;
import com.ibm.es.nuvo.crawler.adapter.file.FileItemSet;
import com.ibm.es.nuvo.crawler.util.fenced.ProcessManager;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcessException;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import java.util.ArrayList;
import java.util.List;

public class FileItemFinder
extends ItemFinder {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<String> itemList = new ArrayList<String>();
    private String user;
    private String password;

    public void addItem(String uri) {
        super.addItem(uri);
        this.itemList.add(uri);
    }

    public ItemSet execute() throws AdapterException {
        ProcessManager processManager = ProcessManager.getInstance();
        FileItemSet fileItemSet = new FileItemSet();
        try {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String uri : this.itemList) {
                String filePath;
                String loweruri = uri.toLowerCase();
                if (loweruri.startsWith("file://localhost/")) {
                    filePath = FSURIUtil.getFileObject((String)uri).getAbsolutePath();
                } else {
                    int index = uri.indexOf("file://");
                    if (index != -1) {
                        filePath = uri.substring("file:".length());
                    } else {
                        throw new AdapterException((Throwable)new RuntimeException());
                    }
                }
                boolean rc = processManager.impersonate(this.getUser(), this.getPassword(), filePath);
                if (!rc) continue;
                resultList.add(uri);
            }
            fileItemSet.setResult(resultList.iterator());
        }
        catch (WinSecurityProcessException e) {
            throw new AdapterException((Throwable)e);
        }
        return fileItemSet;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String u) {
        this.user = u;
    }
}

