/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.crawler.adapter.Acl;
import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationMap;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentQuery;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.Credentials;
import com.ibm.es.nuvo.crawler.adapter.FieldDefinition;
import com.ibm.es.nuvo.crawler.adapter.FieldType;
import com.ibm.es.nuvo.crawler.adapter.ItemFinder;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import com.ibm.es.nuvo.crawler.adapter.SimpleBuilder;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.adapter.Space;
import com.ibm.es.nuvo.crawler.adapter.URINormalizer;
import com.ibm.es.nuvo.crawler.adapter.UserPasswordCredentials;
import com.ibm.es.nuvo.crawler.adapter.file.DirectoryTraverser;
import com.ibm.es.nuvo.crawler.adapter.file.FSException;
import com.ibm.es.nuvo.crawler.adapter.file.FSFile;
import com.ibm.es.nuvo.crawler.adapter.file.FSFileFilter;
import com.ibm.es.nuvo.crawler.adapter.file.FileAclHandler;
import com.ibm.es.nuvo.crawler.adapter.file.FileAdapterConstants;
import com.ibm.es.nuvo.crawler.adapter.file.FileItemFinder;
import com.ibm.es.nuvo.crawler.adapter.file.FilteredFileCursor;
import com.ibm.es.nuvo.crawler.adapter.file.ListFileFilter;
import com.ibm.es.nuvo.crawler.adapter.file.SharedFolderHandler;
import com.ibm.es.nuvo.crawler.adapter.file.SimpleFileFilter;
import com.ibm.es.nuvo.crawler.adapter.file.WildcardSubDirectoryFilter;
import com.ibm.es.nuvo.crawler.common.CrawlerConstants;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntryContent;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.config.GlobalConfig;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;

public class FileAdapter
extends Adapter
implements FileAdapterConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String myClassName = FileAdapter.class.getName();
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger((String)("NuvoTracer." + myClassName));
    private static final int NO_LIMIT_SUBDIR_LEVEL = -1;
    private static final int DEFAULT_SUBDIR_LEVEL = -1;
    private static final FieldDefinition FILENAME_FIELD = new FieldDefinition("filename", null, FieldType.STRING, true);
    private static final FieldDefinition DIRNAME_FIELD = new FieldDefinition("dirname", null, FieldType.STRING, true);
    private static final FieldDefinition CONTENT_SIZE_FIELD = new FieldDefinition("contentsize", null, FieldType.LONG, true);
    private static final FieldDefinition[] SYSTEM_FIELDS = new FieldDefinition[]{FILENAME_FIELD, DIRNAME_FIELD, CONTENT_SIZE_FIELD};
    private static final String RELINFO_SYSTEM = "System";
    private static final String RELINFO_SECURITY = "SecuritySupported";
    private static Boolean isGlobalACLSupport = null;
    private FileAclHandler aclHandler;
    private SharedFolderHandler sharedFolderHandler;
    private static URINormalizer FS_NORMALIZER = new URINormalizer(){

        public String normalize(String uri) {
            String normalizedUri = uri.replaceAll("\\+", "%20");
            if (File.separator.equals("\\")) {
                normalizedUri = normalizedUri.replaceAll("%3A", ":");
            }
            return normalizedUri;
        }
    };

    static synchronized boolean isGlobalACLSupport() throws ExtendedException {
        if (isGlobalACLSupport == null) {
            boolean b;
            ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
            if (releaseInfo != null) {
                b = releaseInfo.getValueAsBoolean(RELINFO_SYSTEM, RELINFO_SECURITY, false);
                if (b) {
                    GlobalConfig globalConfig = ConfigurationLoader.getGlobalConfig();
                    b = globalConfig.getAuthenticationModule().isLocalOSLoginRequired();
                }
            } else {
                b = false;
            }
            isGlobalACLSupport = b;
        }
        return isGlobalACLSupport;
    }

    synchronized FileAclHandler getAclHandler() {
        return this.aclHandler;
    }

    synchronized FileAclHandler getAclHandler(File f) throws AdapterException {
        if (this.aclHandler == null) {
            this.aclHandler = new FileAclHandler(f);
        }
        return this.aclHandler;
    }

    synchronized SharedFolderHandler getSharedFolderHandler() throws AdapterException {
        if (this.sharedFolderHandler == null) {
            this.sharedFolderHandler = new SharedFolderHandler();
        }
        return this.sharedFolderHandler;
    }

    public void close() throws AdapterException {
    }

    public Space getRootSpace() throws AdapterException {
        return new ServerSpace("localhost");
    }

    public ItemFinder createItemFinder(Credentials credentail) throws AdapterException {
        UserPasswordCredentials userCredential = (UserPasswordCredentials)credentail;
        String user = userCredential.getUser();
        String password = userCredential.getPassword();
        FileItemFinder fif = new FileItemFinder();
        fif.setUser(user);
        fif.setPassword(password);
        return fif;
    }

    public URINormalizer createURINormalizer() {
        return FS_NORMALIZER;
    }

    public static boolean checkReadPermissionOnDirectory(File file) {
        if (File.separator.equals("/")) {
            if (file != null) {
                return file.canRead();
            }
            return false;
        }
        if (file != null) {
            FileFilter tmpFilter = new FileFilter(){

                public boolean accept(File f) {
                    return false;
                }
            };
            File[] files = file.listFiles(tmpFilter);
            return files != null;
        }
        return false;
    }

    private class ServerSpace
    extends Space {
        private final ConfigurationMap serverSpaceConfigs;
        private ConfigurationElement networkUser;
        private ConfigurationElement networkPassword;
        private ConfigurationElement networkFolder;

        private ServerSpace(String serverName) {
            super(null, serverName, true, false);
            this.serverSpaceConfigs = new ConfigurationMap();
            this.networkUser = this.serverSpaceConfigs.add("network_user", null, false);
            this.networkPassword = this.serverSpaceConfigs.add("network_password", null, false);
            this.networkFolder = this.serverSpaceConfigs.add("network_folder", null, false);
            CrawlerConstants.addCrawlerCommon((ConfigurationMap)this.serverSpaceConfigs);
        }

        public ConfigurationMap getConfigurations() {
            return this.serverSpaceConfigs;
        }

        public Space getSubSpace(String name) throws AdapterException {
            if (this.networkFolder.getString() != null) {
                File netFolder = new File(this.networkFolder.getString());
                return new FileSpace((Space)this, netFolder.getPath(), netFolder);
            }
            File spaceDir = new File(name);
            return new FileSpace(this, name, spaceDir, FileAdapter.checkReadPermissionOnDirectory(spaceDir));
        }

        public Space[] getSubSpaces() throws AdapterException {
            if (this.networkFolder.getString() != null) {
                FileAdapter.this.getSharedFolderHandler().netConnection(this.networkUser.getString(), this.networkPassword.getString(), this.networkFolder.getString());
                File netFolder = new File(this.networkFolder.getString());
                ArrayList<FileSpace> spaces = new ArrayList<FileSpace>(1);
                spaces.add(new FileSpace((Space)this, netFolder.getPath(), netFolder));
                return spaces.toArray(new FileSpace[0]);
            }
            File[] children = File.listRoots();
            ArrayList<FileSpace> spaces = new ArrayList<FileSpace>(children.length);
            int i = 0;
            while (i < children.length) {
                if (children[i].isDirectory()) {
                    String name = children[i].getPath();
                    if (name.charAt(name.length() - 1) == '\\') {
                        name = name.substring(0, name.length() - 1);
                    }
                    spaces.add(new FileSpace(this, children[i].getPath(), children[i], FileAdapter.checkReadPermissionOnDirectory(children[i])));
                }
                ++i;
            }
            return spaces.toArray(new FileSpace[0]);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FileSpace
        extends Space {
            private final File dir;
            private ConfigurationMap fileSpaceConfigs;

            private FileSpace(Space parent, File file) {
                this(parent, file.getName(), file);
            }

            private FileSpace(Space parent, String name, File file) {
                super(parent, name, true, true);
                this.dir = file;
            }

            private FileSpace(Space parent, String name, File file, boolean isCrawlSpace) {
                super(parent, name, true, isCrawlSpace);
                this.dir = file;
            }

            public ConfigurationMap getCrawlSpaceConfigurations() {
                if (this.fileSpaceConfigs == null) {
                    this.fileSpaceConfigs = new ConfigurationMap();
                    CrawlerConstants.addCrawlSpaceCommon((ConfigurationMap)this.fileSpaceConfigs);
                    EnumSet<ConfigurationElement.Attribute> subdirLevelOption = EnumSet.noneOf(ConfigurationElement.Attribute.class);
                    subdirLevelOption.add(ConfigurationElement.Attribute.NO_FORCE);
                    subdirLevelOption.add(ConfigurationElement.Attribute.MANDATORY);
                    this.fileSpaceConfigs.add("subdirectory_level", -1L, subdirLevelOption);
                    EnumSet<ConfigurationElement.Attribute> excludedPatternOption = EnumSet.noneOf(ConfigurationElement.Attribute.class);
                    excludedPatternOption.add(ConfigurationElement.Attribute.NO_FORCE);
                    this.fileSpaceConfigs.add("exclude_patterns", excludedPatternOption, ListConfiguration.Style.MULTI);
                }
                return this.fileSpaceConfigs;
            }

            public Space getSubSpace(String name) throws AdapterException {
                File child = new File(this.dir, name);
                return new FileSpace((Space)this, child.getName(), child, FileAdapter.checkReadPermissionOnDirectory(child));
            }

            public Space[] getSubSpaces() throws AdapterException {
                File[] children = this.dir.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory();
                    }
                });
                if (children == null) {
                    return new Space[0];
                }
                ArrayList<FileSpace> spaces = new ArrayList<FileSpace>(children.length);
                int i = 0;
                while (i < children.length) {
                    if (children[i].isDirectory()) {
                        spaces.add(new FileSpace((Space)this, children[i].getName(), children[i], FileAdapter.checkReadPermissionOnDirectory(children[i])));
                    }
                    ++i;
                }
                return spaces.toArray(new FileSpace[0]);
            }

            public ContentQuery createContentQuery() throws AdapterException {
                return new ContentQuery(){
                    private Long maxLastModified = null;

                    public void setMaxLastModified(long l) {
                        this.maxLastModified = l;
                    }

                    public ContentSet execute() throws AdapterException {
                        ListConfiguration lclist;
                        HashSet<String> exPatterns = new HashSet<String>();
                        if (FileSpace.this.fileSpaceConfigs != null && (lclist = FileSpace.this.fileSpaceConfigs.get("exclude_patterns").getList()) != null) {
                            ListConfiguration.Item[] itemArray = lclist.getItems();
                            int n = itemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ListConfiguration.Item item = itemArray[n2];
                                exPatterns.add(item.getValue());
                                ++n2;
                            }
                        }
                        if (!FileSpace.this.dir.isDirectory()) {
                            FileNotFoundException fnfe = new FileNotFoundException(FileSpace.this.dir.toString());
                            Message msg = new Message("C3010E.CRWL_GEN_FETCH_EXCEPTION");
                            throw new AdapterException(msg, (Throwable)fnfe);
                        }
                        return new DirectoryContentSet(FileSpace.this, FileSpace.this.dir, CrawlerConstants.extractExcludedExtensions((ConfigurationMap)FileSpace.this.fileSpaceConfigs), exPatterns, FileSpace.this.fileSpaceConfigs != null ? (int)FileSpace.this.fileSpaceConfigs.get("subdirectory_level").getLong() : -1, this.maxLastModified);
                    }
                };
            }

            public Content getContent(String uri) throws AdapterException {
                if (ArchiveEntryContent.isArchiveFile((String)uri)) {
                    ArchiveEntryContent aec = new ArchiveEntryContent(uri, null);
                    return aec.getArchiveContent();
                }
                return this.createContentFromFile(FSURIUtil.getFileObject((String)uri), null, null, null, -1, null, null);
            }

            public FieldDefinition[] getFields() throws AdapterException {
                return SYSTEM_FIELDS;
            }

            private Content createContentFromFile(final File f, final Set<String> excludedExts, final Set<String> excludedPat, final ListFileFilter filter, final int dirLimit, final Long maxLastModified, Acl acl) throws AdapterException {
                SimpleContent content = null;
                if (f.isDirectory()) {
                    content = SimpleBuilder.newContent((SimpleContent.SubContentsRequestHandler)new SimpleContent.SubContentsRequestHandler(){

                        public ContentSet getSubContents() throws AdapterException {
                            int newDirLimit = dirLimit == -1 ? -1 : (dirLimit > 0 ? dirLimit - 1 : -2);
                            return new DirectoryContentSet(new FileSpace((Space)FileSpace.this, f), f, excludedExts, excludedPat, filter, newDirLimit, maxLastModified);
                        }
                    }, (boolean)false);
                } else {
                    content = SimpleBuilder.newContent();
                    try {
                        content.createBody(f);
                    }
                    catch (IOException e) {
                        throw new AdapterException((Throwable)e);
                    }
                    content.setDate(new Date(f.lastModified()));
                    content.addField(FILENAME_FIELD.getName(), f.getName());
                    content.addField(DIRNAME_FIELD.getName(), f.getParent());
                    content.addField(CONTENT_SIZE_FIELD.getName(), f.length());
                    if (acl != null) {
                        content.setAcl(acl);
                    }
                }
                return content;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class DirectoryContentSet
            extends ContentSet
            implements FSFileFilter,
            ContentSet.ShortenedNameAvailable {
                private ListFileFilter fileFilter;
                private final FileSpace space;
                private final Set<String> excludedExts;
                private String uri;
                private File file;
                private final int dirLimit;
                private final Long maxLastModified;
                private FilteredFileCursor cursor;
                private FSFile current;
                private FSFile fsdir;
                private Set<String> wildCardPatterns;
                Acl fileACL;

                private DirectoryContentSet(FileSpace pspace, File pdir, Set<String> exext, Set<String> expat, int pdirLimit, Long pmaxLastModified) {
                    this(pspace, pdir, exext, expat, null, pdirLimit, pmaxLastModified);
                }

                private DirectoryContentSet(FileSpace pspace, File pdir, Set<String> exext, Set<String> expat, ListFileFilter filter, int pdirLimit, Long pmaxLastModified) {
                    this.space = pspace;
                    this.excludedExts = exext;
                    if (filter != null) {
                        this.wildCardPatterns = expat;
                        this.fileFilter = filter;
                    } else {
                        this.wildCardPatterns = new HashSet<String>();
                        TreeMap<Integer, String> inclusionRules = new TreeMap<Integer, String>();
                        for (String pattern : expat) {
                            if (File.separator.equals("\\") && pattern.contains("/")) {
                                pattern = pattern.replace("/", "\\");
                            }
                            if (pattern.startsWith("<")) {
                                int index = pattern.indexOf(62);
                                if (index < 0 || index + 1 >= pattern.length()) continue;
                                try {
                                    inclusionRules.put(Integer.valueOf(pattern.substring(1, index)), pattern.substring(index + 1));
                                }
                                catch (NumberFormatException e) {}
                                continue;
                            }
                            this.wildCardPatterns.add(pattern);
                        }
                        this.fileFilter = new ListFileFilter();
                        for (String pattern : inclusionRules.values()) {
                            this.fileFilter.addNextFilter(new SimpleFileFilter(pattern, this.space.dir));
                        }
                    }
                    this.dirLimit = pdirLimit;
                    this.maxLastModified = pmaxLastModified;
                    this.cursor = new DirectoryTraverser();
                    this.cursor.addFilter(this);
                    this.cursor.addFilter(this.fileFilter);
                    if (this.wildCardPatterns != null) {
                        for (String pattern : this.wildCardPatterns) {
                            this.cursor.addFilter(new WildcardSubDirectoryFilter(pattern));
                            if (!tracer.isLoggable(Level.FINE)) continue;
                            tracer.log(Level.FINE, "Excluded folder pattern: " + pattern);
                        }
                    }
                    this.fsdir = new FSFile(pdir);
                    this.current = null;
                }

                public String getShortenedName() {
                    String result = this.file.getAbsolutePath().substring(this.space.dir.getAbsolutePath().length());
                    if (result.charAt(0) == '/' || result.charAt(0) == '\\') {
                        result = result.substring(1);
                    }
                    return result;
                }

                public Content getContent() throws AdapterException {
                    return this.space.createContentFromFile(this.file, this.excludedExts, this.wildCardPatterns, this.fileFilter, this.dirLimit, this.maxLastModified, this.fileACL);
                }

                public long getHash() {
                    if (this.file.isDirectory()) {
                        return System.currentTimeMillis();
                    }
                    if (this.fileACL != null) {
                        return this.fileACL.getAclHash(false);
                    }
                    return 0L;
                }

                public long getLastModified() {
                    if (this.file.isDirectory()) {
                        return 0L;
                    }
                    return this.file.lastModified();
                }

                public void close() throws AdapterException {
                    if (this.current != null) {
                        this.current.deactivate();
                        this.current = null;
                    }
                    if (this.cursor != null) {
                        try {
                            try {
                                this.cursor.close();
                            }
                            catch (FSException fSException) {
                                this.cursor = null;
                            }
                        }
                        finally {
                            this.cursor = null;
                        }
                    }
                }

                public String getURI() {
                    return this.uri;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean next() throws AdapterException {
                    if (this.current != null) {
                        this.current.deactivate();
                    } else {
                        this.cursor.pushRoot(this.fsdir);
                    }
                    try {
                        this.fileACL = null;
                        do {
                            if (Thread.currentThread().isInterrupted() || !this.cursor.hasNext()) {
                                return false;
                            }
                            this.current = this.cursor.next();
                            this.current.activate();
                        } while (!this.current.canRead());
                        this.file = this.current.getFileObject();
                        this.uri = FSURIUtil.getEncodedUri((String)ServerSpace.this.getName(), (File)this.file);
                        if (FileAdapter.this.getAclHandler(this.file).isAclSupport()) {
                            this.fileACL = FileAdapter.this.getAclHandler().getAcl(this.file);
                        }
                        return true;
                    }
                    catch (FSException e) {
                        throw new AdapterException((Throwable)((Object)e));
                    }
                }

                @Override
                public boolean accept(FSFile f) {
                    if (this.dirLimit != -1 && this.dirLimit < 0) {
                        return false;
                    }
                    if (f != null && f.isFile()) {
                        f.activate();
                        if (this.maxLastModified != null && f.lastModified() < this.maxLastModified) {
                            return false;
                        }
                        String ext = f.getExtension();
                        return ext != null && !this.excludedExts.contains(ext.toLowerCase());
                    }
                    return true;
                }

                @Override
                public boolean acceptChildren(FSFile f) {
                    if (f != null) {
                        return f.isDirectory() && (this.dirLimit == -1 || this.dirLimit >= 0);
                    }
                    return false;
                }
            }
        }
    }
}

