/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.Acl;
import com.ibm.es.nuvo.crawler.adapter.AclDomain;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.acl.AclNormalizer;
import com.ibm.es.nuvo.crawler.adapter.acl.WindowsAclNormalizer;
import com.ibm.es.nuvo.crawler.adapter.file.FileAdapter;
import com.ibm.es.nuvo.crawler.adapter.file.WinApiHandler;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcessException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class FileAclHandler
extends WinApiHandler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final AclDomain aclDomain = new AclDomain("default", "windowsfs", "native");
    private boolean aclSupport;
    private boolean isNTFS;
    private boolean isDomain;
    private boolean isNetwork;
    private boolean isMappedDrive;

    public FileAclHandler(File f) throws AdapterException {
        this.init(f);
    }

    private void init(File f) throws AdapterException {
        this.setNTFS(true);
        this.setDomain(false);
        this.setNetwork(false);
        this.setMappedDrive(false);
        this.setAclSupport(false);
        try {
            if (FileAdapter.isGlobalACLSupport() && this.isWindows()) {
                this.setNTFS(true);
                this.setDomain(false);
                this.setNetwork(false);
                this.setMappedDrive(false);
                this.checkDomain();
                this.checkNTFS(f);
                this.checkNetwork(f);
                this.checkMappedDrive(f);
                this.setAclSupport(false);
                if (this.isNetwork()) {
                    if (this.isDomain()) {
                        this.setAclSupport(true);
                    } else {
                        this.setAclSupport(false);
                    }
                } else if (this.isNTFS()) {
                    if (!this.isDomain() && this.isMappedDrive()) {
                        this.setAclSupport(false);
                    } else {
                        this.setAclSupport(true);
                    }
                } else {
                    this.setAclSupport(false);
                }
            }
        }
        catch (WinSecurityProcessException e) {
            throw new AdapterException((Throwable)e);
        }
        catch (ExtendedException ee) {
            throw new AdapterException((Throwable)ee);
        }
    }

    public Acl getAcl(File file) throws AdapterException {
        if (!this.isAclSupport()) {
            return null;
        }
        String logFileName = null;
        Acl acl = null;
        try {
            acl = new Acl(aclDomain);
            acl.setNormalizer((AclNormalizer)new WindowsAclNormalizer());
            String fileName = file.getCanonicalPath();
            String parentDir = file.getParentFile().getCanonicalPath();
            logFileName = String.valueOf(parentDir) + "(dir)";
            ArrayList accounts = this.securityService.getACL(parentDir);
            if (accounts != null) {
                for (String account : accounts) {
                    acl.addEntry(account, 1);
                }
            }
            logFileName = fileName;
            accounts = this.getSecurityService().getACL(fileName);
            if (accounts != null) {
                for (String account : accounts) {
                    acl.addEntry(account, 2);
                }
            }
        }
        catch (IOException ioe) {
            Message msg = new Message("C4502E.FILE_OPEN_ERROR");
            msg.addArgument(file.toString());
            throw new AdapterException(msg, (Throwable)ioe);
        }
        catch (WinSecurityProcessException wspe) {
            Message msg = new Message("C4514E.FAIL_TO_GETACL_WINDOWS");
            msg.addArgument(logFileName);
            msg.addArgument(wspe.getWin32err());
            msg.addArgument(wspe.getLocalMessageForWindows());
            throw new AdapterException(msg, (Throwable)wspe);
        }
        return acl;
    }

    public boolean isAclSupport() {
        return this.aclSupport;
    }

    private void setAclSupport(boolean b) {
        this.aclSupport = b;
    }

    protected boolean isNTFS() {
        return this.isNTFS;
    }

    private void setNTFS(boolean b) {
        this.isNTFS = b;
    }

    private boolean isDomain() {
        return this.isDomain;
    }

    private void setDomain(boolean b) {
        this.isDomain = b;
    }

    private boolean isNetwork() {
        return this.isNetwork;
    }

    private void setNetwork(boolean b) {
        this.isNetwork = b;
    }

    private void checkDomain() throws WinSecurityProcessException {
        String domain = this.securityService.getDomainName();
        if (domain == null) {
            this.setDomain(false);
        } else {
            this.setDomain(true);
        }
    }

    private void checkNetwork(File f) throws WinSecurityProcessException {
        try {
            String filename = f.getCanonicalPath();
            if (filename.startsWith("\\")) {
                this.setNetwork(true);
            } else {
                this.setNetwork(false);
            }
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException((Throwable)ioe);
        }
    }

    private void checkNTFS(File f) throws WinSecurityProcessException {
        try {
            boolean bret = this.securityService.isNTFS(f.getCanonicalPath());
            this.setNTFS(bret);
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException((Throwable)ioe);
        }
    }

    private void checkMappedDrive(File f) throws WinSecurityProcessException {
        try {
            boolean bret = this.securityService.isMappedDrive(f.getCanonicalPath());
            this.setMappedDrive(bret);
        }
        catch (IOException ioe) {
            throw new WinSecurityProcessException((Throwable)ioe);
        }
    }

    private boolean isMappedDrive() {
        return this.isMappedDrive;
    }

    private void setMappedDrive(boolean b) {
        this.isMappedDrive = b;
    }
}

