/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSFile
implements Serializable,
Comparable<FSFile> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;
    private static final int kAll = -1;
    private int dirLevel;
    private volatile File file = null;
    private String localFileName;
    private String canonicalFileName;
    private final boolean isDirectory;
    private final boolean exists;

    public FSFile(File root) {
        this.file = root;
        this.localFileName = this.file.getAbsolutePath();
        try {
            this.canonicalFileName = this.file.getCanonicalPath();
        }
        catch (IOException ignore) {
            this.canonicalFileName = this.localFileName;
        }
        this.isDirectory = this.file.isDirectory();
        this.exists = this.file.exists();
        this.dirLevel = 0;
        this.file = null;
        FSFile.normalize(this);
    }

    public FSFile(FSFile parent, String name) {
        if (name == null || parent == null) {
            throw new NullPointerException();
        }
        if (!parent.isDirectory) {
            throw new IllegalAccessError();
        }
        int fromIndex = 0;
        int toIndex = -1;
        int parentLevel = parent.getDirLevel();
        StringBuffer parentPath = new StringBuffer(parent.localFileName);
        while ((toIndex = name.indexOf(File.separatorChar, fromIndex)) != -1) {
            parentPath.append(name.substring(fromIndex, toIndex + 1));
            fromIndex = toIndex + 1;
            ++parentLevel;
        }
        String filename = name.substring(fromIndex);
        this.file = new File(parentPath.toString(), filename);
        this.localFileName = this.file.getAbsolutePath();
        this.isDirectory = this.file.isDirectory();
        this.exists = this.file.exists();
        this.dirLevel = this.isDirectory && filename.length() > 0 ? parentLevel + 1 : parentLevel;
        this.file = null;
        FSFile.normalize(this);
    }

    public FSFile(String rootPath, File nodeDir) {
        this(nodeDir);
        if (this.localFileName != null && rootPath != null) {
            String directoryPath = this.localFileName;
            int level = 0;
            if (!rootPath.endsWith(File.separator)) {
                StringBuilder str = new StringBuilder(rootPath).append(File.separator);
                rootPath = str.toString();
            }
            if (directoryPath.startsWith(rootPath)) {
                int i;
                String diff = directoryPath.substring(rootPath.length(), directoryPath.length());
                while ((i = diff.indexOf(File.separator)) != -1) {
                    diff = diff.substring(i + 1, diff.length());
                    ++level;
                }
            }
            this.dirLevel = level;
        }
    }

    boolean isScope(int currentLevel) {
        if (this.dirLevel == -1) {
            return true;
        }
        return this.dirLevel < currentLevel;
    }

    public void activate() {
        this.file = new File(this.localFileName);
    }

    public void deactivate() {
        this.file = null;
    }

    public String getExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(".");
        if (index == -1 || index == name.length()) {
            return ".";
        }
        return name.substring(index);
    }

    public int getDirLevel() {
        return this.dirLevel;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return !this.isDirectory;
    }

    public boolean canRead() {
        boolean readable;
        boolean wasActive;
        block24: {
            wasActive = false;
            if (this.file == null) {
                wasActive = true;
                this.activate();
            }
            readable = true;
            if (!this.file.exists()) {
                return false;
            }
            if (File.separator.equals("\\")) {
                if (this.isDirectory()) {
                    if (this.getFileObject().list() == null) {
                        readable = false;
                    }
                } else if (this.isFile()) {
                    FileInputStream fis = null;
                    try {
                        try {
                            fis = new FileInputStream(this.getFileObject());
                            readable = true;
                        }
                        catch (FileNotFoundException e) {
                            readable = false;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else if (!this.file.canRead()) {
                readable = false;
            }
        }
        if (wasActive) {
            this.deactivate();
        }
        return readable;
    }

    public String getParent() {
        return this.file.getParent();
    }

    public String getParent(boolean pathEnds) {
        String parent = this.file.getParent();
        if (pathEnds && !parent.endsWith(File.separator)) {
            parent = String.valueOf(parent) + File.separator;
        }
        return parent;
    }

    public String getAbsolutePath() {
        return this.localFileName;
    }

    public File getAbsoluteFile() {
        return this.file.getAbsoluteFile();
    }

    public String getCanonicalPath() {
        return this.canonicalFileName;
    }

    public File getCanonicalFile() throws IOException {
        return this.file.getCanonicalFile();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public String getName() {
        return this.file.getName();
    }

    public long length() {
        return this.file.length();
    }

    public File getFileObject() {
        return this.file;
    }

    public String[] list() {
        return this.file.list();
    }

    public boolean exists() {
        return this.exists;
    }

    public static FSFile normalize(FSFile file) {
        if (file.isDirectory) {
            StringBuffer buf;
            if (file.localFileName != null && !file.localFileName.endsWith(File.separator)) {
                buf = new StringBuffer(file.localFileName).append(File.separatorChar);
                file.localFileName = buf.toString();
            }
            if (file.canonicalFileName != null && !file.canonicalFileName.endsWith(File.separator)) {
                buf = new StringBuffer(file.canonicalFileName).append(File.separatorChar);
                file.canonicalFileName = buf.toString();
            }
        }
        return file;
    }

    @Override
    public int compareTo(FSFile target) {
        return this.canonicalFileName.compareTo(target.canonicalFileName);
    }

    public boolean equals(Object target) {
        return target instanceof FSFile && this.canonicalFileName.equals(((FSFile)target).canonicalFileName);
    }

    public int hashCode() {
        if (this.canonicalFileName != null) {
            return this.canonicalFileName.hashCode();
        }
        return 0;
    }

    public boolean contains(Object o) {
        FSFile target = (FSFile)o;
        return target.canonicalFileName.startsWith(this.canonicalFileName);
    }
}

