/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.file;

import com.ibm.es.nuvo.crawler.adapter.file.FSException;
import com.ibm.es.nuvo.crawler.adapter.file.FSFile;
import com.ibm.es.nuvo.crawler.adapter.file.FilteredFileCursor;
import com.ibm.es.nuvo.crawler.adapter.file.SwapFiledStack;
import java.io.File;

public class DirectoryTraverser
extends FilteredFileCursor {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private FSFile root;
    private SwapFiledStack<FSFile> fileStack;
    private FSFile file;

    public DirectoryTraverser() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.fileStack = new SwapFiledStack(1000, 10000, tmpDir);
    }

    public void pushRoot(FSFile node) {
        this.root = node;
        this.root.deactivate();
        this.file = node;
        this.file.activate();
        String[] list = this.file.list();
        if (list != null) {
            boolean acceptChildren = this.acceptChildren(this.file);
            boolean accept = this.accept(this.file);
            this.storeChildren(this.file, list, acceptChildren, accept);
        }
    }

    public boolean hasNext() throws FSException {
        if (this.file != null) {
            this.file.deactivate();
        }
        if (!this.fileStack.empty()) {
            this.file = (FSFile)this.fileStack.pop();
            this.file.activate();
            return true;
        }
        return false;
    }

    private void storeChildren(FSFile parent, String[] children, boolean storeDirs, boolean storeFiles) {
        int i = 0;
        while (i < children.length) {
            if (i % 5 == 0 && Thread.currentThread().isInterrupted()) {
                return;
            }
            FSFile child = new FSFile(parent, children[i]);
            child.activate();
            if (child.isDirectory() && storeDirs) {
                this.fileStack.push(child);
            } else if (child.isFile() && storeFiles && this.accept(child)) {
                this.fileStack.push(child);
            }
            child.deactivate();
            ++i;
        }
    }

    public FSFile next() throws FSException {
        return this.file;
    }

    public void close() throws FSException {
        if (this.file != null) {
            this.file.deactivate();
            this.file = null;
        }
        this.fileStack.clear();
    }
}

