/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ibmjsse;

import com.ibm.jsse.IBMJSSEProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.JsseListener;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Password;

public class IbmJsseListener
extends JsseListener {
    private static Log log = LogFactory.getLog(IbmJsseListener.class);
    private String _keystore = DEFAULT_KEYSTORE;
    private transient Password _password;
    private transient Password _keypassword;
    private String _keystore_type = DEFAULT_KEYSTORE_TYPE;
    private String _keystore_provider_name = DEFAULT_KEYSTORE_PROVIDER_NAME;
    private String _keystore_provider_class = DEFAULT_KEYSTORE_PROVIDER_CLASS;

    public void setKeystore(String keystore) {
        this._keystore = keystore;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public void setPassword(String password) {
        this._password = Password.getPassword((String)"jetty.ssl.password", (String)password, null);
    }

    public void setKeyPassword(String password) {
        this._keypassword = Password.getPassword((String)"jetty.ssl.keypassword", (String)password, null);
    }

    public void setKeystoreType(String keystore_type) {
        this._keystore_type = keystore_type;
    }

    public String getKeystoreType() {
        return this._keystore_type;
    }

    public void setKeystoreProviderName(String name) {
        this._keystore_provider_name = name;
    }

    public String getKeystoreProviderName() {
        return this._keystore_provider_name;
    }

    public String getKeystoreProviderClass() {
        return this._keystore_provider_class;
    }

    public void setKeystoreProviderClass(String classname) {
        this._keystore_provider_class = classname;
    }

    public IbmJsseListener() throws IOException {
    }

    public IbmJsseListener(InetAddrPort p_address) throws IOException {
        super(p_address);
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        this._keystore = System.getProperty("jetty.ssl.keystore", this._keystore);
        log.info((Object)("jetty.ssl.keystore=" + this._keystore));
        if (this._password == null) {
            this._password = Password.getPassword((String)"jetty.ssl.password", null, null);
        }
        log.info((Object)("jetty.ssl.password=" + this._password.toStarString()));
        if (this._keypassword == null) {
            this._keypassword = Password.getPassword((String)"jetty.ssl.keypassword", null, (String)this._password.toString());
        }
        log.info((Object)("jetty.ssl.keypassword=" + this._keypassword.toStarString()));
        KeyStore ks = null;
        log.info((Object)("jetty.ssl.keystore.type=" + this._keystore_type));
        if (this._keystore_provider_class != null) {
            Provider[] installed_providers = Security.getProviders();
            Provider myprovider = null;
            for (int i = 0; i < installed_providers.length; ++i) {
                if (!installed_providers[i].getClass().getName().equals(this._keystore_provider_class)) continue;
                myprovider = installed_providers[i];
                break;
            }
            if (myprovider == null) {
                myprovider = (Provider)Class.forName(this._keystore_provider_class).newInstance();
                Security.addProvider(myprovider);
            }
            log.info((Object)("jetty.ssl.keystore.provider.class=" + this._keystore_provider_class));
            ks = KeyStore.getInstance(this._keystore_type, myprovider.getName());
        } else if (this._keystore_provider_name != null) {
            log.info((Object)("jetty.ssl.keystore.provider.name=" + this._keystore_provider_name));
            ks = KeyStore.getInstance(this._keystore_type, this._keystore_provider_name);
        } else {
            ks = KeyStore.getInstance(this._keystore_type);
            log.info((Object)"jetty.ssl.keystore.provider.name=[DEFAULT]");
        }
        ks.load(new FileInputStream(new File(this._keystore)), this._password.toString().toCharArray());
        KeyManagerFactory km = KeyManagerFactory.getInstance("IbmX509");
        km.init(ks, this._keypassword.toString().toCharArray());
        KeyManager[] kma = km.getKeyManagers();
        TrustManagerFactory tm = TrustManagerFactory.getInstance("IbmX509");
        tm.init(ks);
        TrustManager[] tma = tm.getTrustManagers();
        SSLContext sslc = SSLContext.getInstance("SSL");
        sslc.init(kma, tma, SecureRandom.getInstance("IBMSecureRandom"));
        SSLServerSocketFactory ssfc = sslc.getServerSocketFactory();
        log.info((Object)("SSLServerSocketFactory=" + ssfc));
        return ssfc;
    }

    static {
        Security.addProvider((Provider)new IBMJSSEProvider());
    }
}

