/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc.active;

import com.ibm.es.nuvo.crawler.adapter.jdbc.FetchColumnException;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.AbstractColumn;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StringColumn
extends AbstractColumn {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String value;

    StringColumn(String name, int type) {
        super(name, type);
    }

    public String getString() {
        return this.value;
    }

    protected void readColumn(ResultSet result, int parameterIndex) throws SQLException, FetchColumnException {
        this.value = this.tryRead(result, parameterIndex);
        if (this.value != null && this.value.length() > 0 && this.value.charAt(this.value.length() - 1) == '\u0000') {
            int position;
            for (position = this.value.length() - 1; this.value.charAt(position) == '\u0000' && position != 0; --position) {
            }
            this.value = this.value.substring(0, position);
        }
        this.wasNull = result.wasNull();
    }

    protected void setParameter(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setString(parameterIndex, this.value);
    }

    public long getHash() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0L;
    }

    private String tryRead(ResultSet result, int parameterIndex) throws FetchColumnException {
        String v = null;
        try {
            v = result.getString(parameterIndex);
        }
        catch (SQLException e) {
            throw new FetchColumnException(this.name, e);
        }
        return v;
    }
}

