/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc.active;

import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcTimestampHandler;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.TimestampColumn;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class NormalTimestampHandler
implements JdbcTimestampHandler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private long lastModified;
    private Timestamp max;
    private String name;
    private Long maxLastModified;

    NormalTimestampHandler(String name, Long maxLastModified) {
        this.name = name;
        this.maxLastModified = maxLastModified;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public boolean readData(JdbcColumn column) {
        Timestamp timestamp = ((TimestampColumn)column).getTimestamp();
        if (timestamp != null) {
            this.lastModified = timestamp.getTime();
            if (this.max == null || timestamp.compareTo(this.max) > 0) {
                this.max = timestamp;
            }
            return true;
        }
        this.lastModified = System.currentTimeMillis();
        return false;
    }

    public String getSQLRepresentaion() {
        if (this.maxLastModified != null) {
            return this.name + " > ? ";
        }
        return null;
    }

    public int setParameter(PreparedStatement stmt, int beginIndex) throws SQLException {
        if (this.maxLastModified != null) {
            stmt.setTimestamp(beginIndex, new Timestamp(this.maxLastModified));
            return 1;
        }
        return 0;
    }
}

