/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc.active;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.jdbc.FetchColumnException;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCondition;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursorConfig;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcTimestampHandler;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcUtils;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.AbstractColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.AbstractCursor;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.BinaryTimestampHandler;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.NormalTimestampHandler;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

public class DefaultCursor
extends AbstractCursor {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private PreparedStatement pstmt;
    private ResultSet result;
    private int commitCount;
    private int count;
    private JdbcTimestampHandler timestampHandler;
    private long maxLastModified;
    private static final ExtendedLogger logger = ExtendedLogger.getLogger((String)("com.ibm.es.nuvo." + DefaultCursor.class.getName()));

    public DefaultCursor(JdbcCursorConfig config, Connection connection, JdbcColumn[] columns) {
        super(config, connection, columns);
        this.maxLastModified = config.getMaxLastModified();
    }

    public void open() throws AdapterException {
        boolean quickmode = this.maxLastModified != 0L;
        StringBuilder sql = new StringBuilder(100);
        try {
            boolean isCaseSensitive = JdbcUtils.isColumnNameCaseSensitive(this.connection);
            String detectUpdateColumnName = this.config.getDetectUpdateColumnName();
            if (detectUpdateColumnName != null) {
                for (JdbcColumn column : this.columns) {
                    if (!column.getName().equals(detectUpdateColumnName)) continue;
                    if (column.getType() == 93) {
                        this.timestampHandler = new NormalTimestampHandler(column.getName(), this.maxLastModified);
                        continue;
                    }
                    if (column.getType() == -2) {
                        this.timestampHandler = new BinaryTimestampHandler(column.getName(), this.maxLastModified);
                        continue;
                    }
                    Message msg = new Message("C4207E.JDBC_INVALID_TIMESTAMP_FIELD");
                    String dburl = this.connection.getMetaData().getURL();
                    String table = this.config.getSchemaName() + "." + this.config.getTableName();
                    msg.addArgument(dburl);
                    msg.addArgument(table);
                    msg.addArgument(column.getName());
                    msg.addArgument((long)column.getType());
                    throw new AdapterException(msg);
                }
            }
            sql.append("SELECT ");
            for (JdbcColumn column : this.columns) {
                if (isCaseSensitive) {
                    sql.append("\"").append(column.getName()).append("\"");
                } else {
                    sql.append(column.getName());
                }
                sql.append(",");
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(" FROM ").append(isCaseSensitive ? "\"" : "").append(this.config.getSchemaName()).append(isCaseSensitive ? "\".\"" : ".").append(this.config.getTableName()).append(isCaseSensitive ? "\"" : "");
            JdbcCondition condition = this.config.getCondition();
            if (condition != null && condition.getSQLRepresentaion() != null && condition.getSQLRepresentaion().length() != 0) {
                sql.append(" WHERE ").append(condition.getSQLRepresentaion());
            }
            if (quickmode && this.timestampHandler != null && this.timestampHandler.getSQLRepresentaion() != null) {
                if (condition != null) {
                    sql.append(" AND ");
                } else {
                    sql.append(" WHERE ");
                }
                sql.append(this.timestampHandler.getSQLRepresentaion());
            }
            this.pstmt = this.connection.prepareStatement(sql.toString());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Crawling Sql:" + sql);
            }
            int paramIndex = 1;
            if (condition != null) {
                paramIndex += condition.setParameter(this.pstmt, paramIndex);
            }
            if (quickmode && this.timestampHandler != null) {
                this.timestampHandler.setParameter(this.pstmt, paramIndex);
            }
            this.result = this.pstmt.executeQuery();
            boolean stream = false;
            for (JdbcColumn column : this.columns) {
                if (column.getType() != 2004 && column.getType() != 2005) continue;
                stream = true;
                break;
            }
            int n = this.commitCount = stream ? 1 : 0;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Commit?:" + this.commitCount);
            }
        }
        catch (SQLException e) {
            String dbUrl = null;
            int errCode = e.getErrorCode();
            String sqlState = e.getSQLState();
            if (this.connection != null) {
                try {
                    DatabaseMetaData mData = this.connection.getMetaData();
                    dbUrl = mData.getURL();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
            }
            Message msg = JdbcUtils.getMessage(e, dbUrl, null, sql.toString(), "C4209E.JDBC_DATABASE_ERROR", new Object[]{dbUrl, errCode, sqlState});
            throw new AdapterException(msg, (Throwable)e);
        }
    }

    public boolean next() throws AdapterException {
        try {
            if (this.commitCount > 0 && this.count >= this.commitCount) {
                this.commit();
                this.count = 0;
            }
            ++this.count;
            return this.result.next();
        }
        catch (SQLException e) {
            Message msg = JdbcUtils.getDefaultMessage(e, this.connection, null);
            throw new AdapterException(msg, (Throwable)e);
        }
    }

    public JdbcColumn getColumn(int i) throws AdapterException, FetchColumnException {
        try {
            ((AbstractColumn)this.columns[i - 1]).readColumn(this.result, i);
        }
        catch (SQLException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Fail to read a column. " + this.columns[i - 1]);
            }
            Message msg = JdbcUtils.getDefaultMessage(e, this.connection, null);
            throw new AdapterException(msg, (Throwable)e);
        }
        return this.columns[i - 1];
    }

    public void close() throws AdapterException {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
            }
        }
        catch (SQLException e1) {
            // empty catch block
        }
        try {
            if (this.result != null) {
                this.result.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public JdbcTimestampHandler getTimestampHandler() {
        return this.timestampHandler;
    }
}

