/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc.active;

import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursor;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursorConfig;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursorFactory;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.BinaryColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.BinaryStreamColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.BooleanColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.CharacterStreamColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.DateColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.DefaultCursor;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.DoubleColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.LongColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.NullColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.StringColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.TimeColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.TimestampColumn;
import java.sql.Connection;

public class CursorFactory
extends JdbcCursorFactory {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    protected JdbcColumn getColumn(String name, int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return new LongColumn(name, type);
            }
            case -2: {
                return new BinaryColumn(name, type);
            }
            case -4: 
            case -3: 
            case 2004: {
                return new BinaryStreamColumn(name, type);
            }
            case 2005: {
                return new CharacterStreamColumn(name, type);
            }
            case -7: 
            case -1: 
            case 1: 
            case 12: {
                return new StringColumn(name, type);
            }
            case 91: {
                return new DateColumn(name, type);
            }
            case 92: {
                return new TimeColumn(name, type);
            }
            case 93: {
                return new TimestampColumn(name, type);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return new DoubleColumn(name, type);
            }
            case 16: {
                return new BooleanColumn(name, type);
            }
        }
        return new NullColumn(name, type);
    }

    protected JdbcCursor doCreateCursor(JdbcCursorConfig config, Connection connection, JdbcColumn[] columns) {
        return new DefaultCursor(config, connection, columns);
    }
}

