/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc.active;

import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcTimestampHandler;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcUtils;
import com.ibm.es.nuvo.crawler.adapter.jdbc.active.BinaryColumn;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BinaryTimestampHandler
implements JdbcTimestampHandler {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private byte[] data;
    private byte[] min;
    private byte[] max;
    private String name;
    private byte[] maxLastModified;

    public BinaryTimestampHandler(String name, long maxLastModified) {
        this.name = name;
        if (maxLastModified != 0L) {
            this.maxLastModified = this.toBinaryTimestamp(maxLastModified);
        }
    }

    public Long getLastModified() {
        return this.toLong(this.max);
    }

    public boolean readData(JdbcColumn column) {
        BinaryColumn binaryColumn = (BinaryColumn)column;
        this.data = binaryColumn.getBytes();
        if (this.data != null) {
            if (this.min == null || JdbcUtils.compareArray(this.data, this.min) > 0) {
                this.min = this.data;
            }
            if (this.max == null || JdbcUtils.compareArray(this.data, this.max) < 0) {
                this.max = this.data;
            }
            return true;
        }
        return false;
    }

    public String getSQLRepresentaion() {
        if (this.maxLastModified != null) {
            return this.name + " > ? ";
        }
        return null;
    }

    public int setParameter(PreparedStatement stmt, int beginIndex) throws SQLException {
        if (this.maxLastModified != null) {
            stmt.setBytes(beginIndex, this.maxLastModified);
            return 1;
        }
        return 0;
    }

    private long toLong(byte[] timestamp) {
        long l = 0L;
        for (int i = 0; i < timestamp.length; ++i) {
            l <<= 8;
            l = (long)(timestamp[i] & 0xFF) | l;
        }
        return l;
    }

    private byte[] toBinaryTimestamp(long l) {
        String lStr = Long.toBinaryString(l);
        int length = 64 - lStr.length();
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            str.append(0);
        }
        str.append(lStr);
        byte[] timestamp = new byte[8];
        int index = 0;
        for (int i = 0; i <= 56; i += 8) {
            String binaryStr = str.substring(i, i + 8);
            int it = Integer.parseInt(binaryStr, 2);
            timestamp[index] = (byte)it;
            ++index;
        }
        return timestamp;
    }
}

