/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc.active;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.jdbc.FetchColumnException;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursor;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursorConfig;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractCursor
implements JdbcCursor {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    JdbcColumn[] columns;
    Connection connection;
    JdbcCursorConfig config;

    public AbstractCursor(JdbcCursorConfig config, Connection connection, JdbcColumn[] columns) {
        this.config = config;
        this.columns = columns;
        this.connection = connection;
    }

    public abstract void open() throws AdapterException;

    public abstract boolean next() throws AdapterException;

    public abstract JdbcColumn getColumn(int var1) throws AdapterException, FetchColumnException;

    public int getColumnCount() {
        return this.columns.length;
    }

    public abstract void close() throws AdapterException;

    protected void commit() throws AdapterException {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            int errCode = e.getErrorCode();
            String sqlState = e.getSQLState();
            Message msg = JdbcUtils.getMessage(e, null, null, null, "C4209E.JDBC_DATABASE_ERROR", new Object[]{"", errCode, sqlState});
            throw new AdapterException(msg, (Throwable)e);
        }
    }
}

