/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc;

import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.SpaceFilter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpaceFilterRepository {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String Default = "default";
    private static final String DB2 = "jdbc:db2:";
    private static final String ORACLE = "jdbc:oracle:";
    private static final String MSSQL2000 = "jdbc:microsoft:sqlserver:";
    private static final String MSSQL2005 = "jdbc:sqlserver:";
    private static final String MYSQL = "jdbc:mysql:";
    private Map<String, SpaceFilter> map = new HashMap<String, SpaceFilter>();
    private static SpaceFilterRepository repository = new SpaceFilterRepository();

    private SpaceFilterRepository() {
        this.map.put(Default, new DefaultSpaceFilter());
    }

    public static SpaceFilterRepository getInstance() {
        return repository;
    }

    public SpaceFilter getFilter(String dburl) {
        if (dburl != null) {
            if (dburl.startsWith(DB2)) {
                if (!this.map.containsKey(DB2)) {
                    this.map.put(DB2, new DB2SpaceFilter());
                }
                return this.map.get(DB2);
            }
            if (dburl.startsWith(ORACLE)) {
                if (!this.map.containsKey(ORACLE)) {
                    this.map.put(ORACLE, new OracleSpaceFilter());
                }
                return this.map.get(ORACLE);
            }
            if (dburl.startsWith(MSSQL2000)) {
                if (!this.map.containsKey(MSSQL2000)) {
                    this.map.put(MSSQL2000, new MSSQL2000SpaceFilter());
                }
                return this.map.get(MSSQL2000);
            }
            if (dburl.startsWith(MSSQL2005)) {
                if (!this.map.containsKey(MSSQL2005)) {
                    this.map.put(MSSQL2005, new MSSQL2005SpaceFilter());
                }
                return this.map.get(MSSQL2005);
            }
            if (dburl.startsWith(MYSQL)) {
                if (!this.map.containsKey(MYSQL)) {
                    this.map.put(MYSQL, new MySQLSpaceFilter());
                }
                return this.map.get(MYSQL);
            }
        }
        return this.map.get(Default);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MySQLSpaceFilter
    implements SpaceFilter {
        private SpaceFilter defaultFilter = new DefaultSpaceFilter();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canSelect(Connection conn, String schema, String table) {
            if (conn == null) {
                return true;
            }
            Statement stmt = null;
            StringBuilder checkSQL = new StringBuilder("SELECT 1 FROM ");
            checkSQL.append(schema);
            checkSQL.append(".");
            checkSQL.append(table);
            checkSQL.append(" WHERE 1 = 0");
            try {
                stmt = conn.createStatement();
                stmt.execute(checkSQL.toString());
            }
            catch (SQLException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {}
                }
            }
            return true;
        }

        @Override
        public boolean isSystemSchema(String schema) {
            return this.defaultFilter.isSystemSchema(schema);
        }

        @Override
        public boolean isSystemTable(String table) {
            return this.defaultFilter.isSystemTable(table);
        }

        @Override
        public boolean isUpdateType(int dataType, String typeName) {
            return this.defaultFilter.isUpdateType(dataType, typeName);
        }

        @Override
        public boolean isContentType(int dataType, String typeName) {
            return this.defaultFilter.isContentType(dataType, typeName);
        }

        @Override
        public boolean isSupportedType(int dataType, String typeName) {
            return this.defaultFilter.isSupportedType(dataType, typeName);
        }

        @Override
        public int mapType(int type, String typeName) {
            return this.defaultFilter.mapType(type, typeName);
        }

        @Override
        public void sortColumns(List<JdbcColumn> columns) {
        }

        @Override
        public boolean isDocumentDateType(int dataType, String typeName) {
            return this.defaultFilter.isDocumentDateType(dataType, typeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MSSQL2005SpaceFilter
    implements SpaceFilter {
        private SpaceFilter defaultFilter = new DefaultSpaceFilter();
        private Set<String> systemSchemas = new HashSet<String>();
        private Set<String> systemTables;

        public MSSQL2005SpaceFilter() {
            this.systemSchemas.add("db_accessadmin");
            this.systemSchemas.add("db_backupoperator");
            this.systemSchemas.add("db_datareader");
            this.systemSchemas.add("db_datawriter");
            this.systemSchemas.add("db_ddladmin");
            this.systemSchemas.add("db_denydatareader");
            this.systemSchemas.add("db_denydatawriter");
            this.systemSchemas.add("db_owner");
            this.systemSchemas.add("db_securityadmin");
            this.systemTables = new HashSet<String>();
            this.systemTables.add("dtproperties");
            this.systemTables.add("sysconstraints");
            this.systemTables.add("syssegments");
        }

        @Override
        public boolean canSelect(Connection conn, String schemaName, String tableName) {
            return this.defaultFilter.canSelect(conn, schemaName, tableName);
        }

        @Override
        public boolean isContentType(int dataType, String typeName) {
            if (typeName.equalsIgnoreCase("text") || typeName.equalsIgnoreCase("ntext")) {
                return true;
            }
            if (typeName.equalsIgnoreCase("timestamp")) {
                return false;
            }
            return this.defaultFilter.isContentType(dataType, typeName);
        }

        @Override
        public boolean isSystemSchema(String schemaName) {
            if (this.systemSchemas.contains(schemaName)) {
                return true;
            }
            return this.defaultFilter.isSystemSchema(schemaName);
        }

        @Override
        public boolean isSystemTable(String tableName) {
            if (this.systemTables.contains(tableName)) {
                return true;
            }
            return this.defaultFilter.isSystemTable(tableName);
        }

        @Override
        public boolean isUpdateType(int dataType, String typeName) {
            if (typeName.equalsIgnoreCase("timestamp")) {
                return true;
            }
            return this.defaultFilter.isUpdateType(dataType, typeName);
        }

        @Override
        public boolean isSupportedType(int dataType, String typeName) {
            if (typeName.equals("sql_variant")) {
                return false;
            }
            return this.defaultFilter.isSupportedType(dataType, typeName);
        }

        @Override
        public int mapType(int dataType, String typeName) {
            return this.defaultFilter.mapType(dataType, typeName);
        }

        @Override
        public void sortColumns(List<JdbcColumn> columns) {
        }

        @Override
        public boolean isDocumentDateType(int dataType, String typeName) {
            return this.defaultFilter.isDocumentDateType(dataType, typeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MSSQL2000SpaceFilter
    implements SpaceFilter {
        private SpaceFilter defaultFilter;
        private Set<String> systemTables = new HashSet<String>();

        public MSSQL2000SpaceFilter() {
            this.defaultFilter = new DefaultSpaceFilter();
            this.systemTables.add("dtproperties");
            this.systemTables.add("sysconstraints");
            this.systemTables.add("syssegments");
        }

        @Override
        public boolean canSelect(Connection conn, String schemaName, String tableName) {
            return this.defaultFilter.canSelect(conn, schemaName, tableName);
        }

        @Override
        public boolean isContentType(int dataType, String typeName) {
            if (typeName.equalsIgnoreCase("timestamp")) {
                return false;
            }
            if (typeName.equalsIgnoreCase("text") || typeName.equalsIgnoreCase("ntext")) {
                return true;
            }
            return this.defaultFilter.isContentType(dataType, typeName);
        }

        @Override
        public boolean isSystemSchema(String schemaName) {
            return this.defaultFilter.isSystemSchema(schemaName);
        }

        @Override
        public boolean isSystemTable(String tableName) {
            if (this.systemTables.contains(tableName)) {
                return true;
            }
            return this.defaultFilter.isSystemTable(tableName);
        }

        @Override
        public boolean isUpdateType(int dataType, String typeName) {
            if (typeName.equalsIgnoreCase("timestamp")) {
                return true;
            }
            return this.defaultFilter.isUpdateType(dataType, typeName);
        }

        @Override
        public boolean isSupportedType(int dataType, String typeName) {
            return this.defaultFilter.isSupportedType(dataType, typeName);
        }

        @Override
        public int mapType(int dataType, String typeName) {
            return this.defaultFilter.mapType(dataType, typeName);
        }

        @Override
        public void sortColumns(List<JdbcColumn> columns) {
        }

        @Override
        public boolean isDocumentDateType(int dataType, String typeName) {
            return this.defaultFilter.isDocumentDateType(dataType, typeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OracleSpaceFilter
    implements SpaceFilter {
        private SpaceFilter defaultFilter;
        private Set<String> systemSchema = new HashSet<String>();

        public OracleSpaceFilter() {
            this.defaultFilter = new DefaultSpaceFilter();
            this.systemSchema.add("CTXSYS");
            this.systemSchema.add("DBSNMP");
            this.systemSchema.add("MDSYS");
            this.systemSchema.add("ODM");
            this.systemSchema.add("ODM_MTR");
            this.systemSchema.add("OUTLN");
            this.systemSchema.add("OLAPSYS");
            this.systemSchema.add("ORDSYS");
            this.systemSchema.add("ORDPLUGINS");
            this.systemSchema.add("RMAN");
            this.systemSchema.add("SYS");
            this.systemSchema.add("SYSTEM");
            this.systemSchema.add("TSMSYS");
            this.systemSchema.add("WKSYS");
            this.systemSchema.add("WKPROXY");
            this.systemSchema.add("WMSYS");
            this.systemSchema.add("XDB");
        }

        @Override
        public boolean canSelect(Connection conn, String schemaName, String tableName) {
            return this.defaultFilter.canSelect(conn, schemaName, tableName);
        }

        @Override
        public boolean isContentType(int dataType, String typeName) {
            if (dataType == 1111) {
                return typeName.equalsIgnoreCase("BLOB") || typeName.equalsIgnoreCase("CLOB") || typeName.equalsIgnoreCase("NCLOB");
            }
            if (dataType == -1 && typeName.equals("LONG")) {
                return true;
            }
            return this.defaultFilter.isContentType(dataType, typeName);
        }

        @Override
        public boolean isSystemSchema(String schemaName) {
            if (this.systemSchema.contains(schemaName.toUpperCase())) {
                return true;
            }
            return this.defaultFilter.isSystemSchema(schemaName);
        }

        @Override
        public boolean isSystemTable(String tableName) {
            return this.defaultFilter.isSystemTable(tableName);
        }

        @Override
        public boolean isUpdateType(int dataType, String typeName) {
            if (typeName.toUpperCase().startsWith("TIMESTAMP(") ? typeName.toUpperCase().endsWith(")") || typeName.toUpperCase().endsWith("WITH TIME ZONE") : dataType == -101) {
                return true;
            }
            if (typeName.equalsIgnoreCase("DATE")) {
                return false;
            }
            return this.defaultFilter.isUpdateType(dataType, typeName);
        }

        @Override
        public boolean isSupportedType(int dataType, String typeName) {
            if (dataType == 1111) {
                if (typeName.equalsIgnoreCase("NCHAR") || typeName.equalsIgnoreCase("NVARCHAR2") || typeName.equalsIgnoreCase("BLOB") || typeName.equalsIgnoreCase("CLOB") || typeName.equalsIgnoreCase("NCLOB") || typeName.equalsIgnoreCase("FLOAT")) {
                    return true;
                }
                return typeName.toUpperCase().startsWith("TIMESTAMP(") && (typeName.toUpperCase().endsWith(")") || typeName.toUpperCase().endsWith("WITH TIME ZONE"));
            }
            if (dataType == -101) {
                return true;
            }
            return this.defaultFilter.isSupportedType(dataType, typeName);
        }

        @Override
        public int mapType(int type, String typeName) {
            if (type == 1111) {
                if (typeName.equalsIgnoreCase("NCHAR")) {
                    return 1;
                }
                if (typeName.equalsIgnoreCase("NVARCHAR2")) {
                    return 12;
                }
                if (typeName.equalsIgnoreCase("BLOB")) {
                    return 2004;
                }
                if (typeName.equalsIgnoreCase("CLOB") || typeName.equalsIgnoreCase("NCLOB")) {
                    return 2005;
                }
                if (typeName.equalsIgnoreCase("FLOAT")) {
                    return 6;
                }
                if (typeName.toUpperCase().startsWith("TIMESTAMP") && (typeName.toUpperCase().endsWith(")") || typeName.toUpperCase().endsWith("WITH TIME ZONE"))) {
                    return 93;
                }
            } else if (type == -101 || typeName.equals("TIMESTAMPTZ")) {
                return 93;
            }
            return this.defaultFilter.mapType(type, typeName);
        }

        @Override
        public void sortColumns(List<JdbcColumn> columns) {
            int counter = 0;
            int firstLobIndex = -1;
            ArrayList<Integer> longIndexes = new ArrayList<Integer>();
            JdbcColumn longTmp = null;
            for (JdbcColumn column : columns) {
                if (column.getType() == 2004 || column.getType() == 2005) {
                    firstLobIndex = firstLobIndex != -1 ? firstLobIndex : counter;
                } else if (column.getType() == -1) {
                    longIndexes.add(counter);
                }
                ++counter;
            }
            if (longIndexes.size() > 0 && firstLobIndex != -1) {
                for (int i = 0; i < longIndexes.size(); ++i) {
                    int j = (Integer)longIndexes.get(i);
                    longTmp = columns.remove(j);
                    if (j < firstLobIndex) {
                        --firstLobIndex;
                    }
                    columns.add(firstLobIndex, longTmp);
                    ++firstLobIndex;
                }
            }
        }

        @Override
        public boolean isDocumentDateType(int dataType, String typeName) {
            if (dataType == 1111) {
                return typeName.toUpperCase().startsWith("TIMESTAMP(") && (typeName.toUpperCase().endsWith(")") || typeName.toUpperCase().endsWith("WITH TIME ZONE"));
            }
            if (dataType == -101) {
                return true;
            }
            return this.defaultFilter.isDocumentDateType(dataType, typeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DB2SpaceFilter
    implements SpaceFilter {
        private SpaceFilter defaultFilter = new DefaultSpaceFilter();

        @Override
        public boolean isSystemSchema(String schema) {
            return schema.toUpperCase().startsWith("SYS") || schema.toUpperCase().startsWith("IBM") || schema.toUpperCase().startsWith("ASN");
        }

        @Override
        public boolean isSystemTable(String table) {
            return table.toUpperCase().startsWith("EXPLAIN_");
        }

        @Override
        public boolean canSelect(Connection conn, String schema, String table) {
            return this.defaultFilter.canSelect(conn, schema, table);
        }

        @Override
        public boolean isUpdateType(int dataType, String typeName) {
            return this.defaultFilter.isUpdateType(dataType, typeName);
        }

        @Override
        public boolean isContentType(int dataType, String typeName) {
            if (typeName.equalsIgnoreCase("XML")) {
                return true;
            }
            return this.defaultFilter.isContentType(dataType, typeName);
        }

        @Override
        public boolean isSupportedType(int dataType, String typeName) {
            if (typeName.equalsIgnoreCase("XML")) {
                return true;
            }
            return this.defaultFilter.isSupportedType(dataType, typeName);
        }

        @Override
        public int mapType(int type, String typeName) {
            if (typeName.equals("XML")) {
                return 2005;
            }
            return this.defaultFilter.mapType(type, typeName);
        }

        @Override
        public void sortColumns(List<JdbcColumn> columns) {
        }

        @Override
        public boolean isDocumentDateType(int dataType, String typeName) {
            return this.defaultFilter.isDocumentDateType(dataType, typeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSpaceFilter
    implements SpaceFilter {
        private DefaultSpaceFilter() {
        }

        @Override
        public boolean isSystemSchema(String schema) {
            return false;
        }

        @Override
        public boolean isSystemTable(String table) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canSelect(Connection conn, String schema, String table) {
            if (conn == null) {
                return true;
            }
            Statement stmt = null;
            StringBuilder checkSQL = new StringBuilder("SELECT 1 FROM \"");
            checkSQL.append(schema);
            checkSQL.append("\".\"");
            checkSQL.append(table);
            checkSQL.append("\" WHERE 1 = 0");
            try {
                stmt = conn.createStatement();
                stmt.execute(checkSQL.toString());
            }
            catch (SQLException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {}
                }
            }
            return true;
        }

        @Override
        public boolean isUpdateType(int dataType, String typeName) {
            switch (dataType) {
                case 93: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isContentType(int dataType, String typeName) {
            switch (dataType) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: 
                case 2005: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isSupportedType(int dataType, String typeName) {
            switch (dataType) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 92: 
                case 93: 
                case 2004: 
                case 2005: {
                    return true;
                }
                case 0: 
                case 16: 
                case 70: 
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2006: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public int mapType(int type, String typeName) {
            return type;
        }

        @Override
        public void sortColumns(List<JdbcColumn> columns) {
        }

        @Override
        public boolean isDocumentDateType(int dataType, String typeName) {
            switch (dataType) {
                case 91: 
                case 93: {
                    return true;
                }
            }
            return false;
        }
    }
}

