/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc;

import com.ibm.es.nuvo.common.Message;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;

public class JdbcUtils {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final int DB2_AUTHENTICATION_FAILD = -30082;
    static final int DB2_DATABASE_NOT_FOUND = -4499;
    static final int DB2_OBJECT_NOT_FOUND = -204;
    static final int DB2_INVALID_NAME = -206;
    static final int DB2_SYNTAX_ERROR = -104;
    static final int DB2_NOT_CONNECT_PRIV = -551;
    static final int DB2_NOT_SELECT_PRIV = 1060;
    static final int DB2_CONNECTION_OVERFLOW = -1226;
    static final int DB2_DISCONNECT_FROM_SERVER = -1224;
    static final int MSSQL2000_AUTHENTICATION_FAILD = 18456;
    static final int MSSQL2000_DATABASE_NOT_FOUND = 4060;
    static final int MSSQL2000_OBJECT_NOT_FOUND = 208;
    static final int MSSQL2000_INVALID_NAME = 207;
    static final int MSSQL2000_SYNTAX_ERROR = 170;
    static final int MSSQL2000_NOT_SELECT_PRIV = 229;
    static final int MSSQL2005_AUTHENTICATION_FAILD = 18456;
    static final int MSSQL2005_DATABASE_NOT_FOUND = 4060;
    static final int MSSQL2005_OBJECT_NOT_FOUND = 208;
    static final int MSSQL2005_INVALID_NAME = 207;
    static final int MSSQL2005_SYNTAX_ERROR = 102;
    static final int MSSQL2005_NOT_SELECT_PRIV = 229;
    static final int ORACLE9I_AUTHENTICATION_FAILD = 1017;
    static final int ORACLE9I_DATABASE_NOT_FOUND = 17002;
    static final int ORACLE9I_OBJECT_NOT_FOUND = 942;
    static final int ORACLE9I_INVALID_NAME = 904;
    static final int ORACLE9I_SYNTAX_ERROR = 936;

    static Connection getConnection(String dbURL, String userName, String password, String jdbcDriverName, Properties connectionProperty) throws ClassNotFoundException, SQLException {
        Connection connection = null;
        Class.forName(jdbcDriverName);
        Driver driver = DriverManager.getDriver(dbURL);
        boolean isV82 = false;
        if (driver != null) {
            isV82 = driver.getMajorVersion() == 2 && driver.getMinorVersion() > 2;
        }
        Properties prop = new Properties();
        if (isV82) {
            prop.setProperty("fullyMaterializeLobData", "false");
        }
        if (connectionProperty != null) {
            prop.putAll((Map<?, ?>)connectionProperty);
        }
        if (userName != null) {
            prop.setProperty("user", userName);
        }
        if (password != null) {
            prop.setProperty("password", password);
        }
        connection = DriverManager.getConnection(dbURL, prop);
        try {
            connection.setReadOnly(true);
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            try {
                connection.close();
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw e;
        }
        DatabaseMetaData metadata = connection.getMetaData();
        if (metadata.supportsTransactionIsolationLevel(1)) {
            try {
                connection.setTransactionIsolation(1);
            }
            catch (SQLException e) {
                JdbcUtils.closeConnection(connection);
                throw e;
            }
        }
        return connection;
    }

    static void closeConnection(Connection con) {
        if (con != null) {
            try {
                if (!con.getAutoCommit()) {
                    con.commit();
                }
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static final void closeForce(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        rs = null;
    }

    static final void closeForce(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static boolean isColumnNameCaseSensitive(Connection conn) throws SQLException {
        DatabaseMetaData metadata = conn.getMetaData();
        String url = metadata.getURL();
        return !url.startsWith("jdbc:mysql:");
    }

    public static int compareArray(byte[] a, byte[] b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return 1;
        }
        if (b == null) {
            return -1;
        }
        int len = a.length > b.length ? b.length : a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == b[i]) continue;
            return b[i] - a[i];
        }
        if (a.length == len) {
            if (b.length == len) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public static Message getMessage(SQLException e, String dbURL, String table, String sql, String defaultMessageCode, Object[] defaultArgs) {
        int errorCode = e.getErrorCode();
        Message msg = null;
        if (dbURL != null && dbURL.startsWith("jdbc:db2:")) {
            switch (errorCode) {
                case -30082: {
                    msg = new Message("C4202E.JDBC_AUTHENTICATION_FAILD");
                    msg.addArgument(dbURL);
                    break;
                }
                case -4499: {
                    msg = new Message("C4201E.JDBC_DATABASE_NOT_FOUND");
                    msg.addArgument(dbURL);
                    break;
                }
                case -204: {
                    msg = new Message("C4203E.JDBC_TABLE_NOT_FOUND");
                    msg.addArgument(table);
                    break;
                }
                case -206: {
                    msg = new Message("C4204E.JDBC_INVALID_FIELDS");
                    break;
                }
                case -104: {
                    msg = new Message("C4205E.JDBC_SQL_SYNTAX_ERROR");
                    msg.addArgument(dbURL);
                    msg.addArgument(sql);
                    break;
                }
                default: {
                    msg = new Message(defaultMessageCode);
                    msg.addArguments(defaultArgs);
                    break;
                }
            }
        } else if (dbURL != null && dbURL.startsWith("jdbc:microsoft:sqlserver:")) {
            switch (errorCode) {
                case 18456: {
                    msg = new Message("C4202E.JDBC_AUTHENTICATION_FAILD");
                    msg.addArgument(dbURL);
                    break;
                }
                case 4060: {
                    msg = new Message("C4201E.JDBC_DATABASE_NOT_FOUND");
                    msg.addArgument(dbURL);
                    break;
                }
                case 208: {
                    msg = new Message("C4203E.JDBC_TABLE_NOT_FOUND");
                    msg.addArgument(table);
                    break;
                }
                case 207: {
                    msg = new Message("C4204E.JDBC_INVALID_FIELDS");
                    break;
                }
                case 170: {
                    msg = new Message("C4205E.JDBC_SQL_SYNTAX_ERROR");
                    msg.addArgument(dbURL);
                    msg.addArgument(sql);
                    break;
                }
                default: {
                    msg = new Message(defaultMessageCode);
                    msg.addArguments(defaultArgs);
                    break;
                }
            }
        } else if (dbURL != null && dbURL.startsWith("jdbc:sqlserver:")) {
            switch (errorCode) {
                case 18456: {
                    msg = new Message("C4202E.JDBC_AUTHENTICATION_FAILD");
                    msg.addArgument(dbURL);
                    break;
                }
                case 4060: {
                    msg = new Message("C4201E.JDBC_DATABASE_NOT_FOUND");
                    msg.addArgument(dbURL);
                    break;
                }
                case 208: {
                    msg = new Message("C4203E.JDBC_TABLE_NOT_FOUND");
                    msg.addArgument(table);
                    break;
                }
                case 207: {
                    msg = new Message("C4204E.JDBC_INVALID_FIELDS");
                    break;
                }
                case 102: {
                    msg = new Message("C4205E.JDBC_SQL_SYNTAX_ERROR");
                    msg.addArgument(dbURL);
                    msg.addArgument(sql);
                    break;
                }
                default: {
                    msg = new Message(defaultMessageCode);
                    msg.addArguments(defaultArgs);
                    break;
                }
            }
        } else if (dbURL != null && dbURL.startsWith("jdbc:oracle:")) {
            switch (errorCode) {
                case 1017: {
                    msg = new Message("C4202E.JDBC_AUTHENTICATION_FAILD");
                    msg.addArgument(dbURL);
                    break;
                }
                case 17002: {
                    msg = new Message("C4201E.JDBC_DATABASE_NOT_FOUND");
                    msg.addArgument(dbURL);
                    break;
                }
                case 942: {
                    msg = new Message("C4203E.JDBC_TABLE_NOT_FOUND");
                    msg.addArgument(table);
                    break;
                }
                case 904: {
                    msg = new Message("C4204E.JDBC_INVALID_FIELDS");
                    break;
                }
                case 936: {
                    msg = new Message("C4205E.JDBC_SQL_SYNTAX_ERROR");
                    msg.addArgument(dbURL);
                    msg.addArgument(sql);
                    break;
                }
                default: {
                    msg = new Message(defaultMessageCode);
                    msg.addArguments(defaultArgs);
                    break;
                }
            }
        } else {
            msg = new Message(defaultMessageCode);
            msg.addArguments(defaultArgs);
        }
        return msg;
    }

    public static Message getDefaultMessage(SQLException e, Connection connection, String dburl) {
        Message msg = null;
        dburl = dburl == null ? "" : dburl;
        try {
            if (dburl == null && connection != null) {
                dburl = connection.getMetaData().getURL();
            }
        }
        catch (Exception e1) {
            // empty catch block
        }
        int errCode = e.getErrorCode();
        String sqlState = e.getSQLState();
        msg = JdbcUtils.getMessage(e, dburl, null, null, "C4209E.JDBC_DATABASE_ERROR", new Object[]{dburl, errCode, sqlState});
        return msg;
    }

    public static String decodeUri(String encodedUri) {
        String prefix = "jdbc://";
        StringBuilder str = new StringBuilder(encodedUri.length());
        str.append("jdbc://");
        encodedUri = encodedUri.substring("jdbc://".length(), encodedUri.length());
        if (encodedUri.length() != 0) {
            String[] parts;
            for (String part : parts = encodedUri.split("/")) {
                try {
                    str.append(URLDecoder.decode(part, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    str.append(part);
                }
                str.append("/");
            }
            str.delete(str.length() - 1, str.length());
        }
        return str.toString();
    }
}

