/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursor;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursorConfig;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcUtils;
import com.ibm.es.nuvo.crawler.adapter.jdbc.SpaceFilter;
import com.ibm.es.nuvo.crawler.adapter.jdbc.SpaceFilterRepository;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class JdbcCursorFactory {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static JdbcCursorFactory getFactory(String className) throws AdapterException {
        JdbcCursorFactory factory = null;
        try {
            factory = (JdbcCursorFactory)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new AdapterException((Throwable)e);
        }
        return factory;
    }

    public JdbcCursor createCursor(JdbcCursorConfig config, Connection connection) throws AdapterException {
        ArrayList<JdbcColumn> columns = new ArrayList<JdbcColumn>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            boolean isCaseSensitive = JdbcUtils.isColumnNameCaseSensitive(connection);
            StringBuilder sql = new StringBuilder().append("SELECT ");
            for (String columnName : config.getTargetColumns()) {
                if (isCaseSensitive) {
                    sql.append("\"").append(columnName).append("\"");
                } else {
                    sql.append(columnName);
                }
                sql.append(",");
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(" FROM ").append(isCaseSensitive ? "\"" : "").append(config.getSchemaName()).append(isCaseSensitive ? "\".\"" : ".").append(config.getTableName()).append(isCaseSensitive ? "\"" : "");
            stmt = connection.prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            ResultSetMetaData metadata = rs.getMetaData();
            SpaceFilter filter = SpaceFilterRepository.getInstance().getFilter(connection.getMetaData().getURL());
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                String name = metadata.getColumnName(i);
                int type = metadata.getColumnType(i);
                String typeName = metadata.getColumnTypeName(i);
                columns.add(this.getColumn(name, filter.mapType(type, typeName)));
            }
            filter.sortColumns(columns);
        }
        catch (SQLException e) {
            try {
                int errCode = e.getErrorCode();
                String sqlState = e.getSQLState();
                String dburl = null;
                if (connection != null) {
                    try {
                        DatabaseMetaData dMetadata = connection.getMetaData();
                        dburl = dMetadata.getURL();
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                }
                Message msg = JdbcUtils.getMessage(e, dburl, config.getSchemaName() + "." + config.getTableName(), null, "C4209E.JDBC_DATABASE_ERROR", new Object[]{"", errCode, sqlState});
                throw new AdapterException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcCursorFactory.closeForce(rs);
                JdbcCursorFactory.closeForce(stmt);
                throw throwable;
            }
        }
        JdbcCursorFactory.closeForce(rs);
        JdbcCursorFactory.closeForce(stmt);
        return this.doCreateCursor(config, connection, columns.toArray(new JdbcColumn[0]));
    }

    protected abstract JdbcColumn getColumn(String var1, int var2);

    protected abstract JdbcCursor doCreateCursor(JdbcCursorConfig var1, Connection var2, JdbcColumn[] var3);

    protected static void closeForce(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected static void closeForce(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

