/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.adapter.jdbc;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationMap;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentQuery;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.FieldDefinition;
import com.ibm.es.nuvo.crawler.adapter.FieldType;
import com.ibm.es.nuvo.crawler.adapter.ItemNotFoundException;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import com.ibm.es.nuvo.crawler.adapter.SimpleBuilder;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.adapter.Space;
import com.ibm.es.nuvo.crawler.adapter.jdbc.FetchColumnException;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcColumn;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCondition;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursor;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursorConfig;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcCursorFactory;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcTimestampHandler;
import com.ibm.es.nuvo.crawler.adapter.jdbc.JdbcUtils;
import com.ibm.es.nuvo.crawler.adapter.jdbc.SpaceFilter;
import com.ibm.es.nuvo.crawler.adapter.jdbc.SpaceFilterRepository;
import com.ibm.es.nuvo.crawler.common.CrawlerConstants;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabaseSpace
extends Space {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String PARAM_DBURL = "dburl";
    private static final String PARAM_DRIVER = "driver";
    private static final String PARAM_USER = "user";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_PRIMARY_KEY = "primary_key";
    private static final String PARAM_UPDATE_COLUMN = "detect_update";
    private static final String PARAM_CONDITION = "condition";
    private static final String PARAM_CONTENT_COLUMN = "content_column";
    private static final String PARAM_DOCUMENT_DATE = "document_date";
    private FieldDefinition fixedDatabaseUrlField;
    private final ConfigurationElement dburl;
    private final ConfigurationElement driver;
    private final ConfigurationElement user;
    private final ConfigurationElement password;
    private Connection connection;
    private ConfigurationMap databaseSpaceConfigs = new ConfigurationMap();
    private static final String DEFAULT_URI_ENCODING = "UTF-8";
    private static final String URI_PREFIX = "jdbc://";
    private static final String MYSQL_PREFIX = "jdbc:mysql:";
    private SpaceFilter filter;
    private static final ExtendedLogger logger = ExtendedLogger.getLogger((String)("com.ibm.es.nuvo." + DatabaseSpace.class.getName()));

    DatabaseSpace() {
        super(null, "jdbc", true, false);
        this.dburl = this.databaseSpaceConfigs.add(PARAM_DBURL, "jdbc:derby:testdb", true);
        this.driver = this.databaseSpaceConfigs.add(PARAM_DRIVER, "org.apache.derby.jdbc.EmbeddedDriver", true);
        this.user = this.databaseSpaceConfigs.add(PARAM_USER, null, false);
        EnumSet<ConfigurationElement.Attribute> passwordOption = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        passwordOption.add(ConfigurationElement.Attribute.ENCRYPT);
        this.password = this.databaseSpaceConfigs.add(PARAM_PASSWORD, null, passwordOption);
        CrawlerConstants.addCrawlerCommon((ConfigurationMap)this.databaseSpaceConfigs);
        this.filter = SpaceFilterRepository.getInstance().getFilter("jdbc:derby:testdb");
    }

    public ConfigurationMap getConfigurations() {
        return this.databaseSpaceConfigs;
    }

    private void ensureConnection() throws AdapterException {
        if (this.connection != null) {
            return;
        }
        try {
            this.connection = JdbcUtils.getConnection(this.dburl.getString(), this.user.getString(), this.password.getString(), this.driver.getString(), new Properties());
        }
        catch (ClassNotFoundException e) {
            Message msg = new Message("C4200E.JDBC_LOAD_DRIVER_FAIL");
            msg.addArgument(this.driver.getString());
            throw new AdapterException(msg);
        }
        catch (SQLException e) {
            String dbUrl = this.dburl.getString();
            Message msg = JdbcUtils.getDefaultMessage(e, null, dbUrl);
            throw new AdapterException(msg, (Throwable)e);
        }
    }

    public void open() throws AdapterException {
        this.ensureConnection();
        this.filter = SpaceFilterRepository.getInstance().getFilter(this.dburl.getString());
        this.fixedDatabaseUrlField = new FieldDefinition(ImplicitField.DBURL.toString().toLowerCase(), null, FieldType.STRING, true, this.dburl.getString());
    }

    public void close() throws AdapterException {
        JdbcUtils.closeConnection(this.connection);
        this.connection = null;
    }

    private String handleDbSchemaSynonym() throws AdapterException, SQLException {
        if (this.dburl.getString().startsWith(MYSQL_PREFIX)) {
            return this.connection.getCatalog();
        }
        return null;
    }

    public Space[] getSubSpaces() throws AdapterException {
        return new Space[]{new ServerSpace(this.dburl.getString())};
    }

    public Space getSubSpace(String name) throws AdapterException {
        String dbUrl = this.dburl.getString();
        if (dbUrl.equals(name)) {
            return new ServerSpace(dbUrl);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SimpleContent buildContent(JdbcCursor cursor, int documentDateIndex, int metadataIndex, String contentColumnName) throws AdapterException, FetchColumnException {
        boolean isContentAlreadySet;
        SimpleContent content;
        block38: {
            block39: {
                content = SimpleBuilder.newContent();
                isContentAlreadySet = false;
                if (documentDateIndex == 1) break block39;
                JdbcColumn column = null;
                try {
                    column = cursor.getColumn(documentDateIndex);
                }
                catch (FetchColumnException e) {
                    // empty catch block
                }
                if (column != null && !column.wasNull()) {
                    if (column.getType() == 91) {
                        content.setDate(new Date(column.getDate().getTime()));
                        break block38;
                    } else {
                        content.setDate(new Date(column.getTimestamp().getTime()));
                    }
                    break block38;
                } else {
                    content.setDate(new Date(0L));
                }
                break block38;
            }
            content.setDate(new Date(System.currentTimeMillis()));
        }
        int i = metadataIndex;
        while (true) {
            JdbcColumn column;
            block41: {
                FieldType type;
                int sqlType;
                String name;
                block42: {
                    block40: {
                        if (i > cursor.getColumnCount()) {
                            return content;
                        }
                        column = cursor.getColumn(i);
                        name = column.getName();
                        sqlType = column.getType();
                        type = DatabaseSpace.mapType(sqlType, null, null);
                        if (!column.wasNull()) break block40;
                        content.addNullField(name, type);
                        break block41;
                    }
                    if (!type.equals((Object)FieldType.STRING)) break block42;
                    if (name.equals(contentColumnName) && !isContentAlreadySet) {
                        try {
                            content.createBody((Reader)new StringReader(column.getString()));
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        isContentAlreadySet = true;
                        break block41;
                    } else {
                        content.addField(name, column.getString());
                    }
                    break block41;
                }
                if (type.equals((Object)FieldType.LONG)) {
                    content.addField(name, column.getLong());
                } else if (type.equals((Object)FieldType.DATE)) {
                    switch (sqlType) {
                        case 91: {
                            Date date = column.getDate();
                            content.addField(name, date, date.toString());
                            break;
                        }
                        case 92: {
                            Date date = column.getTime();
                            content.addField(name, date, date.toString());
                            break;
                        }
                        case 93: {
                            Date date = column.getTimestamp();
                            content.addField(name, date, date.toString());
                            break;
                        }
                    }
                } else if (type.equals((Object)FieldType.DOUBLE)) {
                    content.addField(name, column.getDouble());
                } else if (type.equals((Object)FieldType.BOOLEAN)) {
                    content.addField(name, column.getBoolean());
                } else if (type.equals((Object)FieldType.READER)) {
                    try {
                        Reader reader = column.getCharacterStream();
                        if (name.equals(contentColumnName) && !isContentAlreadySet) {
                            content.createBody(reader);
                            isContentAlreadySet = true;
                        }
                        content.addField(name, reader);
                    }
                    catch (IOException e) {
                        throw new AdapterException((Throwable)e);
                    }
                } else {
                    if (!type.equals((Object)FieldType.UNKNOWN)) {
                        String dbUrl = "";
                        String tableName = "";
                        Message msg = new Message("C4206E.JDBC_INVALID_DATA_TYPE");
                        msg.addArgument(dbUrl);
                        msg.addArgument(tableName);
                        msg.addArgument(column.getName());
                        msg.addArgument((long)column.getType());
                        throw new AdapterException(msg);
                    }
                    InputStream stream = null;
                    try {
                        switch (sqlType) {
                            case -2: {
                                stream = new ByteArrayInputStream(column.getBytes());
                                break;
                            }
                            case -4: 
                            case -3: 
                            case 2004: {
                                stream = column.getBinaryStream();
                                break;
                            }
                        }
                        if (name.equals(contentColumnName) && !isContentAlreadySet) {
                            content.createBody(stream, null);
                            isContentAlreadySet = true;
                        }
                    }
                    catch (IOException e) {
                        throw new AdapterException((Throwable)e);
                    }
                }
            }
            column.close();
            ++i;
        }
    }

    private static FieldType mapType(int type, String typeName, SpaceFilter filter) {
        int mappedType = type;
        if (typeName != null && filter != null) {
            mappedType = filter.mapType(type, typeName);
        }
        switch (mappedType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return FieldType.LONG;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return FieldType.UNKNOWN;
            }
            case 2005: {
                return FieldType.READER;
            }
            case -7: 
            case -1: 
            case 1: 
            case 12: {
                return FieldType.STRING;
            }
            case 91: 
            case 92: 
            case 93: {
                return FieldType.DATE;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return FieldType.DOUBLE;
            }
            case 16: {
                return FieldType.BOOLEAN;
            }
        }
        return FieldType.UNKNOWN;
    }

    private static List<String> getSelectedItemList(ListConfiguration list, ListConfiguration.Style listStyle) {
        ArrayList<String> selectedItemNameList = new ArrayList<String>();
        if (list.getItems() != null && list.getItems().length != 0) {
            ListConfiguration.Item[] items;
            for (ListConfiguration.Item item : items = list.getItems()) {
                if (!item.isSelected()) continue;
                selectedItemNameList.add(item.getValue());
                if (listStyle == ListConfiguration.Style.SINGLE) break;
            }
        }
        return selectedItemNameList;
    }

    private static String normalizeTypeName(String nativeDataType) {
        if (nativeDataType.trim().equals("VARCHAR () FOR BIT DATA")) {
            return "VARCHAR FOR BIT DATA";
        }
        if (nativeDataType.trim().equals("CHAR () FOR BIT DATA")) {
            return "CHAR FOR BIT DATA";
        }
        return nativeDataType;
    }

    class ServerSpace
    extends Space {
        protected ServerSpace(String name) {
            super((Space)DatabaseSpace.this, name, true, false);
        }

        public Space[] getSubSpaces() throws AdapterException {
            Space[] schema;
            ArrayList<SchemaSpace> schemas;
            ResultSet rs;
            block6: {
                DatabaseSpace.this.ensureConnection();
                rs = null;
                schemas = new ArrayList<SchemaSpace>();
                String catalogName = DatabaseSpace.this.handleDbSchemaSynonym();
                if (catalogName == null) break block6;
                schemas.add(new SchemaSpace(catalogName));
                Space[] spaceArray = schemas.toArray(new SchemaSpace[0]);
                JdbcUtils.closeForce(rs);
                return spaceArray;
            }
            try {
                DatabaseMetaData metadata = DatabaseSpace.this.connection.getMetaData();
                rs = metadata.getSchemas();
                while (rs.next()) {
                    schema = rs.getString(1);
                    if (DatabaseSpace.this.filter.isSystemSchema((String)schema)) continue;
                    schemas.add(new SchemaSpace((String)schema));
                }
                schema = schemas.toArray(new SchemaSpace[0]);
            }
            catch (SQLException e) {
                try {
                    String dbUrl = DatabaseSpace.this.dburl.getString();
                    Message msg = JdbcUtils.getDefaultMessage(e, null, dbUrl);
                    throw new AdapterException(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeForce(rs);
                    throw throwable;
                }
            }
            JdbcUtils.closeForce(rs);
            return schema;
        }

        public Space getSubSpace(String name) throws AdapterException {
            return new SchemaSpace(name);
        }

        private class SchemaSpace
        extends Space {
            private SchemaSpace(String name) {
                super((Space)DatabaseSpace.this, name, true, false);
            }

            public Space[] getSubSpaces() throws AdapterException {
                Space[] spaceArray;
                ResultSet rs = null;
                try {
                    String schema = this.getName();
                    DatabaseMetaData metadata = DatabaseSpace.this.connection.getMetaData();
                    String[] tableTypes = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM"};
                    rs = metadata.getTables(null, schema, null, tableTypes);
                    ArrayList<TableSpace> tables = new ArrayList<TableSpace>();
                    while (rs.next()) {
                        String table = rs.getString(3);
                        if (DatabaseSpace.this.filter.isSystemTable(table)) continue;
                        tables.add(new TableSpace(schema, table));
                    }
                    JdbcUtils.closeForce(rs);
                    ArrayList<TableSpace> removes = new ArrayList<TableSpace>();
                    for (TableSpace tableSpace : tables) {
                        if (DatabaseSpace.this.filter.canSelect(DatabaseSpace.this.connection, schema, tableSpace.getName())) continue;
                        removes.add(tableSpace);
                    }
                    tables.removeAll(removes);
                    spaceArray = tables.toArray(new TableSpace[0]);
                }
                catch (SQLException e) {
                    try {
                        String dbUrl = DatabaseSpace.this.dburl.getString();
                        Message msg = JdbcUtils.getDefaultMessage(e, null, dbUrl);
                        throw new AdapterException(msg, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeForce(rs);
                        throw throwable;
                    }
                }
                JdbcUtils.closeForce(rs);
                return spaceArray;
            }

            public Space getSubSpace(String name) throws AdapterException {
                String schema = this.getName();
                String table = name;
                return new TableSpace(schema, table);
            }

            private class TableSpace
            extends Space {
                private final String schemaName;
                private final String tableName;
                private final ConfigurationElement primaryKey;
                private final ConfigurationElement detectUpdateColumn;
                private final ConfigurationElement documentDateColumn;
                private final ConfigurationElement whereCondition;
                private final ConfigurationElement contentColumn;
                private final ConfigurationMap tableSpaceConfigs;
                private List<FieldDefinition> columns;
                private List<FieldDefinition> implicitFields;

                private TableSpace(String schemaName, String tableName) {
                    super((Space)DatabaseSpace.this, tableName, false, true);
                    this.schemaName = schemaName;
                    this.tableName = tableName;
                    this.tableSpaceConfigs = new ConfigurationMap();
                    this.primaryKey = this.tableSpaceConfigs.add(DatabaseSpace.PARAM_PRIMARY_KEY, true, ListConfiguration.Style.MULTI);
                    this.detectUpdateColumn = this.tableSpaceConfigs.add(DatabaseSpace.PARAM_UPDATE_COLUMN, false, ListConfiguration.Style.SINGLE);
                    this.documentDateColumn = this.tableSpaceConfigs.add(DatabaseSpace.PARAM_DOCUMENT_DATE, false, ListConfiguration.Style.SINGLE);
                    EnumSet<ConfigurationElement.Attribute> conditionOption = EnumSet.noneOf(ConfigurationElement.Attribute.class);
                    conditionOption.add(ConfigurationElement.Attribute.NO_FORCE);
                    this.whereCondition = this.tableSpaceConfigs.add(DatabaseSpace.PARAM_CONDITION, null, conditionOption);
                    this.contentColumn = this.tableSpaceConfigs.add(DatabaseSpace.PARAM_CONTENT_COLUMN, false, ListConfiguration.Style.SINGLE);
                    this.implicitFields = new ArrayList<FieldDefinition>();
                    this.implicitFields.add(DatabaseSpace.this.fixedDatabaseUrlField);
                    this.implicitFields.add(new FieldDefinition(ImplicitField.TABLENAME.toString().toLowerCase(), null, FieldType.STRING, true, schemaName + "." + tableName));
                }

                public void open() throws AdapterException {
                    HashSet<String> primaryKeySet = new HashSet<String>();
                    ResultSet rs = null;
                    ResultSet pkrs = null;
                    this.columns = new ArrayList<FieldDefinition>();
                    try {
                        ListConfiguration primaryKeyList;
                        DatabaseMetaData metadata = DatabaseSpace.this.connection.getMetaData();
                        try {
                            pkrs = metadata.getPrimaryKeys(null, this.schemaName, this.tableName);
                            primaryKeyList = this.tableSpaceConfigs.get(DatabaseSpace.PARAM_PRIMARY_KEY).getList();
                            while (pkrs.next()) {
                                String name = pkrs.getString(4);
                                primaryKeyList.add(name).setSelected(true);
                                primaryKeySet.add(name);
                            }
                        }
                        catch (SQLException e) {
                            try {
                                String dbUrl = DatabaseSpace.this.dburl.getString();
                                Message msg = JdbcUtils.getDefaultMessage(e, null, dbUrl);
                                throw new AdapterException(msg, (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                JdbcUtils.closeForce(pkrs);
                                throw throwable;
                            }
                        }
                        JdbcUtils.closeForce(pkrs);
                        try {
                            rs = metadata.getColumns(null, this.schemaName, this.tableName, null);
                            primaryKeyList = this.tableSpaceConfigs.get(DatabaseSpace.PARAM_PRIMARY_KEY).getList();
                            ListConfiguration contentColumnList = this.tableSpaceConfigs.get(DatabaseSpace.PARAM_CONTENT_COLUMN).getList();
                            ListConfiguration detectUpdateColumnList = this.tableSpaceConfigs.get(DatabaseSpace.PARAM_UPDATE_COLUMN).getList();
                            ListConfiguration documentDateColumnList = this.tableSpaceConfigs.get(DatabaseSpace.PARAM_DOCUMENT_DATE).getList();
                            while (rs.next()) {
                                FieldType type;
                                String colName = rs.getString(4);
                                short t = rs.getShort(5);
                                String typeName = rs.getString(6);
                                if (!DatabaseSpace.this.filter.isSupportedType(t, typeName)) continue;
                                if (DatabaseSpace.this.filter.isContentType(t, typeName)) {
                                    contentColumnList.add(colName);
                                }
                                if (DatabaseSpace.this.filter.isUpdateType(t, typeName)) {
                                    detectUpdateColumnList.add(colName);
                                }
                                if (DatabaseSpace.this.filter.isDocumentDateType(t, typeName)) {
                                    documentDateColumnList.add(colName);
                                }
                                if (!(type = DatabaseSpace.mapType(t, typeName, DatabaseSpace.this.filter)).equals((Object)FieldType.LONG) && !type.equals((Object)FieldType.STRING) && !type.equals((Object)FieldType.DATE) && !type.equals((Object)FieldType.DOUBLE) && !type.equals((Object)FieldType.BOOLEAN) && !type.equals((Object)FieldType.READER) && !type.equals((Object)FieldType.UNKNOWN)) continue;
                                this.columns.add(new FieldDefinition(colName, DatabaseSpace.normalizeTypeName(typeName), type, false));
                                if (primaryKeySet.contains(colName) || DatabaseSpace.this.filter.isContentType(t, typeName) || type.equals((Object)FieldType.UNKNOWN)) continue;
                                primaryKeyList.add(colName).setSelected(false);
                            }
                        }
                        catch (SQLException e) {
                            try {
                                String dbUrl = DatabaseSpace.this.dburl.getString();
                                Message msg = JdbcUtils.getDefaultMessage(e, null, dbUrl);
                                throw new AdapterException(msg, (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                JdbcUtils.closeForce(rs);
                                throw throwable;
                            }
                        }
                        JdbcUtils.closeForce(rs);
                    }
                    catch (SQLException e) {
                        String dbUrl = DatabaseSpace.this.dburl.getString();
                        Message msg = JdbcUtils.getDefaultMessage(e, null, dbUrl);
                        throw new AdapterException(msg, (Throwable)e);
                    }
                }

                public ConfigurationMap getCrawlSpaceConfigurations() {
                    return this.tableSpaceConfigs;
                }

                public FieldDefinition[] getFields() throws AdapterException {
                    ArrayList<FieldDefinition> allFields = new ArrayList<FieldDefinition>();
                    allFields.addAll(this.columns);
                    allFields.addAll(this.implicitFields);
                    return allFields.toArray(new FieldDefinition[0]);
                }

                public ContentQuery createContentQuery() throws AdapterException {
                    return new ContentQuery(){
                        private long maxLastModified;
                        private final Set<String> targetColumns = new HashSet<String>();

                        public void addField(FieldDefinition field) {
                            if (!field.isSystemField()) {
                                this.targetColumns.add(field.getName());
                            }
                        }

                        public ContentSet execute() throws AdapterException {
                            return new RecordSet(this.targetColumns.toArray(new String[0]), this.maxLastModified);
                        }

                        public void setMaxLastModified(long maxLastModified) {
                            this.maxLastModified = maxLastModified;
                        }
                    };
                }

                public Content getContent(String uri) throws AdapterException {
                    FetchCursorConfig config = new FetchCursorConfig(uri);
                    JdbcCursor cursor = JdbcCursorFactory.getFactory("com.ibm.es.nuvo.crawler.adapter.jdbc.active.CursorFactory").createCursor(config, DatabaseSpace.this.connection);
                    try {
                        cursor.open();
                        if (cursor.next()) {
                            SimpleContent content;
                            try {
                                content = DatabaseSpace.buildContent(cursor, 1, 1, config.getContentColumnName());
                            }
                            catch (FetchColumnException e) {
                                throw new AdapterException((Throwable)((Object)e));
                            }
                            SimpleContent simpleContent = content;
                            return simpleContent;
                        }
                        throw new ItemNotFoundException(uri);
                    }
                    finally {
                        cursor.close();
                    }
                }

                private class FetchCursorConfig
                implements JdbcCursorConfig {
                    private List<String> paramValues = new ArrayList<String>();
                    private StringBuilder sqlCondition = new StringBuilder(100);

                    public FetchCursorConfig(String uri) {
                        boolean isCaseSensitive = true;
                        try {
                            isCaseSensitive = DatabaseSpace.this.dburl.getString().startsWith(DatabaseSpace.MYSQL_PREFIX);
                        }
                        catch (AdapterException e) {
                            // empty catch block
                        }
                        String uriStr = uri.substring(DatabaseSpace.URI_PREFIX.length(), uri.length());
                        uriStr = uriStr.substring(uriStr.indexOf(47) + 1, uriStr.length());
                        uriStr = uriStr.substring(uriStr.indexOf(47) + 1, uriStr.length());
                        String[] tokens = uriStr.split("/");
                        boolean isKey = true;
                        for (String token : tokens) {
                            try {
                                token = URLDecoder.decode(token, DatabaseSpace.DEFAULT_URI_ENCODING);
                            }
                            catch (UnsupportedEncodingException e) {
                                // empty catch block
                            }
                            if (isKey) {
                                this.sqlCondition.append("(").append(isCaseSensitive ? "\"" : "").append(token).append(isCaseSensitive ? "\"" : "").append("=?)").append(" AND ");
                            } else {
                                this.paramValues.add(token);
                            }
                            isKey = !isKey;
                        }
                        this.sqlCondition.delete(this.sqlCondition.length() - 5, this.sqlCondition.length());
                    }

                    public String[] getTargetColumns() throws AdapterException {
                        String contentColumnStr = this.getContentColumnName();
                        ArrayList<String> columnNames = new ArrayList<String>();
                        for (FieldDefinition fd : TableSpace.this.columns) {
                            columnNames.add(fd.getName());
                        }
                        if (contentColumnStr != null) {
                            columnNames.add(contentColumnStr);
                        }
                        return columnNames.toArray(new String[0]);
                    }

                    public String getSchemaName() {
                        return TableSpace.this.schemaName;
                    }

                    public String getTableName() {
                        return TableSpace.this.tableName;
                    }

                    public JdbcCondition getCondition() {
                        return new JdbcCondition(){

                            public String getSQLRepresentaion() {
                                return FetchCursorConfig.this.sqlCondition.toString();
                            }

                            public int setParameter(PreparedStatement stmt, int beginIndex) throws SQLException {
                                int count = 0;
                                for (String value : FetchCursorConfig.this.paramValues) {
                                    stmt.setString(beginIndex, value);
                                    ++count;
                                    ++beginIndex;
                                }
                                return count;
                            }
                        };
                    }

                    public String getContentColumnName() throws AdapterException {
                        List list = DatabaseSpace.getSelectedItemList(TableSpace.this.contentColumn.getList(), ListConfiguration.Style.SINGLE);
                        if (list.size() == 0) {
                            return null;
                        }
                        return (String)list.get(0);
                    }

                    public String getDetectUpdateColumnName() throws AdapterException {
                        List list = DatabaseSpace.getSelectedItemList(TableSpace.this.detectUpdateColumn.getList(), ListConfiguration.Style.SINGLE);
                        if (list.size() == 0) {
                            return null;
                        }
                        return (String)list.get(0);
                    }

                    public long getMaxLastModified() {
                        return 0L;
                    }
                }

                private class RecordSet
                extends ContentSet {
                    private final String baseUri;
                    private String uri;
                    private long hash;
                    private final JdbcCursor cursor;
                    private final ListConfiguration.Item[] primaryKeys;
                    private int detectUpdateIndex = 1;
                    private final String detectUpdateColumnName;
                    private int documentDateCoumnIndex = 1;
                    private final String documentDateColumnName;
                    private final String contentColumnName;
                    private int bodyIndex = 1;
                    private SimpleContent content;
                    private List<String> allTargetColumns = new ArrayList<String>();
                    private long maxLastModified;
                    private boolean isDetectUpdateNull;

                    private RecordSet(String[] columns, long maxLastModified) throws AdapterException {
                        this.maxLastModified = maxLastModified;
                        this.baseUri = this.createBaseUri();
                        ArrayList<ListConfiguration.Item> tmpPk = new ArrayList<ListConfiguration.Item>();
                        for (ListConfiguration.Item pk : TableSpace.this.primaryKey.getList().getItems()) {
                            if (!pk.isSelected()) continue;
                            tmpPk.add(pk);
                        }
                        this.primaryKeys = tmpPk.toArray(new ListConfiguration.Item[0]);
                        List conList = DatabaseSpace.getSelectedItemList(TableSpace.this.contentColumn.getList(), ListConfiguration.Style.SINGLE);
                        this.contentColumnName = conList.size() == 0 ? null : (String)conList.get(0);
                        List duList = DatabaseSpace.getSelectedItemList(TableSpace.this.detectUpdateColumn.getList(), ListConfiguration.Style.SINGLE);
                        this.detectUpdateColumnName = duList.size() == 0 ? null : (String)duList.get(0);
                        List ddList = DatabaseSpace.getSelectedItemList(TableSpace.this.documentDateColumn.getList(), ListConfiguration.Style.SINGLE);
                        this.documentDateColumnName = ddList.size() == 0 ? null : (String)ddList.get(0);
                        for (ListConfiguration.Item primaryKeyColumn : this.primaryKeys) {
                            this.allTargetColumns.add(primaryKeyColumn.getValue());
                            ++this.bodyIndex;
                        }
                        if (this.documentDateColumnName != null) {
                            this.allTargetColumns.add(this.documentDateColumnName);
                            this.documentDateCoumnIndex = this.bodyIndex++;
                        }
                        if (this.detectUpdateColumnName != null) {
                            this.allTargetColumns.add(this.detectUpdateColumnName);
                            this.detectUpdateIndex = this.bodyIndex++;
                        }
                        for (int i = 0; i < columns.length; ++i) {
                            this.allTargetColumns.add(columns[i]);
                        }
                        if (this.contentColumnName != null) {
                            this.allTargetColumns.add(this.contentColumnName);
                        }
                        String packagePath = "com.ibm.es.nuvo.crawler.adapter.jdbc.";
                        String cursortType = "active";
                        this.cursor = JdbcCursorFactory.getFactory(packagePath + cursortType + ".CursorFactory").createCursor(new RSCursorConfig(), DatabaseSpace.this.connection);
                        this.cursor.open();
                    }

                    private String createBaseUri() throws AdapterException {
                        StringBuilder str = new StringBuilder(DatabaseSpace.URI_PREFIX);
                        try {
                            str.append(URLEncoder.encode(DatabaseSpace.this.dburl.getString(), DatabaseSpace.DEFAULT_URI_ENCODING));
                        }
                        catch (UnsupportedEncodingException e) {
                            str.append(DatabaseSpace.this.dburl.getString());
                        }
                        str.append("/");
                        try {
                            str.append(URLEncoder.encode(SchemaSpace.this.getName(), DatabaseSpace.DEFAULT_URI_ENCODING));
                        }
                        catch (UnsupportedEncodingException e) {
                            str.append(SchemaSpace.this.getName());
                        }
                        str.append(".");
                        try {
                            str.append(URLEncoder.encode(TableSpace.this.getName(), DatabaseSpace.DEFAULT_URI_ENCODING));
                        }
                        catch (UnsupportedEncodingException e) {
                            str.append(TableSpace.this.getName());
                        }
                        return str.toString();
                    }

                    public long getHash() {
                        return this.detectUpdateIndex != 1 ? 0L : this.hash;
                    }

                    public long getLastModified() {
                        return this.detectUpdateIndex != 1 ? this.hash : 0L;
                    }

                    public Content getContent() throws AdapterException {
                        if (this.detectUpdateIndex != 1 && !this.isDetectUpdateNull) {
                            try {
                                this.content = DatabaseSpace.buildContent(this.cursor, this.documentDateCoumnIndex, this.bodyIndex, this.contentColumnName);
                            }
                            catch (FetchColumnException e) {
                                throw new AdapterException((Throwable)((Object)e));
                            }
                        }
                        return this.content;
                    }

                    public boolean next() throws AdapterException {
                        try {
                            if (this.cursor.next()) {
                                this.hash = 0L;
                                this.uri = null;
                                while (!this.assignURI()) {
                                    boolean hasNext = this.cursor.next();
                                    if (hasNext) continue;
                                    return false;
                                }
                                if (this.detectUpdateIndex != 1) {
                                    JdbcTimestampHandler timestampHandler = this.cursor.getTimestampHandler();
                                    JdbcColumn tsColumn = null;
                                    try {
                                        tsColumn = this.cursor.getColumn(this.detectUpdateIndex);
                                    }
                                    catch (FetchColumnException e) {
                                        throw new AdapterException((Throwable)((Object)e));
                                    }
                                    if (timestampHandler.readData(tsColumn)) {
                                        this.hash = timestampHandler.getLastModified();
                                        this.isDetectUpdateNull = false;
                                    } else {
                                        try {
                                            this.content = DatabaseSpace.buildContent(this.cursor, this.documentDateCoumnIndex, this.bodyIndex, this.contentColumnName);
                                        }
                                        catch (FetchColumnException e) {
                                            this.handleUnreadableRow(e);
                                            return this.next();
                                        }
                                        this.hash = this.content.getChecksumValue();
                                        this.isDetectUpdateNull = true;
                                    }
                                } else {
                                    try {
                                        this.content = DatabaseSpace.buildContent(this.cursor, this.documentDateCoumnIndex, this.bodyIndex, this.contentColumnName);
                                    }
                                    catch (FetchColumnException e) {
                                        this.handleUnreadableRow(e);
                                        return this.next();
                                    }
                                    this.hash = this.content.getChecksumValue();
                                }
                                return true;
                            }
                            return false;
                        }
                        catch (AdapterException e) {
                            Message msg = new Message("C3508E.CFW_SAVE_DOCUMENT_FAILED");
                            msg.addArgument(JdbcUtils.decodeUri(this.uri));
                            throw new AdapterException(msg);
                        }
                    }

                    private boolean assignURI() throws AdapterException {
                        StringBuilder addUri = new StringBuilder(1024);
                        for (int i = 1; i <= this.primaryKeys.length; ++i) {
                            JdbcColumn column = null;
                            try {
                                column = this.cursor.getColumn(i);
                            }
                            catch (FetchColumnException e) {
                                this.handleUnreadableRow(e);
                                return false;
                            }
                            String name = column.getName();
                            String value = null;
                            if (column.wasNull()) {
                                if (logger.isLoggable(Level.WARNING)) {
                                    Message msg = new Message("C4208W.JDBC_DETECT_NULL_KEY");
                                    msg.addArgument(DatabaseSpace.this.dburl.getString());
                                    msg.addArgument(TableSpace.this.schemaName + "." + TableSpace.this.tableName);
                                    msg.addArgument(name);
                                    logger.log(Level.WARNING, msg);
                                }
                                return false;
                            }
                            value = column.getString();
                            value = value.trim();
                            try {
                                name = URLEncoder.encode(name, DatabaseSpace.DEFAULT_URI_ENCODING);
                                value = URLEncoder.encode(value, DatabaseSpace.DEFAULT_URI_ENCODING);
                            }
                            catch (UnsupportedEncodingException e1) {
                                // empty catch block
                            }
                            addUri.append("/").append(name).append("/").append(value);
                        }
                        this.uri = this.baseUri + addUri.toString();
                        return true;
                    }

                    private void handleUnreadableRow(FetchColumnException e) {
                        if (logger.isLoggable(Level.WARNING)) {
                            Message msg = new Message("C4210W.JDBC_DETECT_UNREADABLE_COLUMN");
                            msg.addArgument(JdbcUtils.decodeUri(this.uri));
                            msg.addArgument(e.getColumnName());
                            logger.log(Level.WARNING, msg);
                        }
                    }

                    public String getURI() {
                        return this.uri;
                    }

                    public void close() throws AdapterException {
                        if (this.cursor != null) {
                            this.cursor.close();
                        }
                    }

                    private class RSCursorConfig
                    implements JdbcCursorConfig {
                        private RSCursorConfig() {
                        }

                        public String[] getTargetColumns() throws AdapterException {
                            return RecordSet.this.allTargetColumns.toArray(new String[0]);
                        }

                        public String getSchemaName() {
                            return TableSpace.this.schemaName;
                        }

                        public String getTableName() {
                            return TableSpace.this.tableName;
                        }

                        public JdbcCondition getCondition() throws AdapterException {
                            final String conditionStr = TableSpace.this.whereCondition.getString();
                            if (conditionStr == null) {
                                return null;
                            }
                            return new JdbcCondition(){

                                public String getSQLRepresentaion() {
                                    return conditionStr;
                                }

                                public int setParameter(PreparedStatement stmt, int beginIndex) throws SQLException {
                                    return 0;
                                }
                            };
                        }

                        public String getContentColumnName() throws AdapterException {
                            return RecordSet.this.contentColumnName;
                        }

                        public String getDetectUpdateColumnName() throws AdapterException {
                            return RecordSet.this.detectUpdateColumnName;
                        }

                        public long getMaxLastModified() {
                            return RecordSet.this.maxLastModified;
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImplicitField {
        DBURL,
        TABLENAME;

    }
}

