/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLock;

public class NativeFSLockFactory
extends LockFactory {
    private File lockDir;

    private void acquireTestLock() throws IOException {
        String randomLockName = "lucene-" + Long.toString(new Random().nextInt(), 36) + "-test.lock";
        Lock l = this.makeLock(randomLockName);
        try {
            l.obtain();
        }
        catch (IOException e) {
            IOException e2 = new IOException("Failed to acquire random test lock; please verify filesystem for lock directory '" + this.lockDir + "' supports locking");
            e2.initCause(e);
            throw e2;
        }
        l.release();
    }

    NativeFSLockFactory() throws IOException {
        this((File)null);
    }

    public NativeFSLockFactory(String lockDirName) throws IOException {
        this(new File(lockDirName));
    }

    public NativeFSLockFactory(File lockDir) throws IOException {
        this.setLockDir(lockDir);
    }

    void setLockDir(File lockDir) throws IOException {
        this.lockDir = lockDir;
        if (lockDir != null) {
            if (!lockDir.exists()) {
                if (!lockDir.mkdirs()) {
                    throw new IOException("Cannot create directory: " + lockDir.getAbsolutePath());
                }
            } else if (!lockDir.isDirectory()) {
                throw new IOException("Found regular file where directory expected: " + lockDir.getAbsolutePath());
            }
            this.acquireTestLock();
        }
    }

    public synchronized Lock makeLock(String lockName) {
        if (this.lockPrefix != null) {
            lockName = String.valueOf(this.lockPrefix) + "-n-" + lockName;
        }
        return new NativeFSLock(this.lockDir, lockName);
    }

    public void clearLock(String lockName) throws IOException {
        if (this.lockDir.exists()) {
            File lockFile;
            if (this.lockPrefix != null) {
                lockName = String.valueOf(this.lockPrefix) + "-n-" + lockName;
            }
            if ((lockFile = new File(this.lockDir, lockName)).exists() && !lockFile.delete()) {
                throw new IOException("Cannot delete " + lockFile);
            }
        }
    }
}

