/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import org.apache.lucene.store.Lock;

class NativeFSLock
extends Lock {
    private RandomAccessFile f;
    private FileChannel channel;
    private FileLock lock;
    private File path;
    private File lockDir;
    private static HashSet LOCK_HELD = new HashSet();

    public NativeFSLock(File lockDir, String lockFileName) {
        this.lockDir = lockDir;
        this.path = new File(lockDir, lockFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized boolean obtain() throws IOException {
        boolean markedHeld;
        String canonicalPath;
        block49: {
            if (this.isLocked()) {
                return false;
            }
            if (!this.lockDir.exists()) {
                if (!this.lockDir.mkdirs()) {
                    throw new IOException("Cannot create directory: " + this.lockDir.getAbsolutePath());
                }
            } else if (!this.lockDir.isDirectory()) {
                throw new IOException("Found regular file where directory expected: " + this.lockDir.getAbsolutePath());
            }
            canonicalPath = this.path.getCanonicalPath();
            markedHeld = false;
            try {
                block48: {
                    HashSet hashSet = LOCK_HELD;
                    // MONITORENTER : hashSet
                    if (!LOCK_HELD.contains(canonicalPath)) break block48;
                    // MONITOREXIT : hashSet
                    if (!markedHeld) return false;
                    if (this.isLocked()) return false;
                    HashSet hashSet2 = LOCK_HELD;
                    {
                        catch (Throwable throwable) {
                            // MONITOREXIT : hashSet
                            throw throwable;
                        }
                    }
                    // MONITORENTER : hashSet2
                    if (LOCK_HELD.contains(canonicalPath)) {
                        LOCK_HELD.remove(canonicalPath);
                    }
                    // MONITOREXIT : hashSet2
                    return false;
                }
                LOCK_HELD.add(canonicalPath);
                markedHeld = true;
                // MONITOREXIT : hashSet
            }
            catch (Throwable throwable) {
                if (!markedHeld) throw throwable;
                if (this.isLocked()) throw throwable;
                HashSet hashSet = LOCK_HELD;
                // MONITORENTER : hashSet
                if (LOCK_HELD.contains(canonicalPath)) {
                    LOCK_HELD.remove(canonicalPath);
                }
                // MONITOREXIT : hashSet
                throw throwable;
            }
            {
                try {
                    this.f = new RandomAccessFile(this.path, "rw");
                }
                catch (IOException e) {
                    this.failureReason = e;
                    this.f = null;
                }
                if (this.f == null) break block49;
                try {
                    this.channel = this.f.getChannel();
                    try {
                        try {
                            this.lock = this.channel.tryLock();
                        }
                        catch (IOException e) {
                            this.failureReason = e;
                        }
                    }
                    finally {
                        if (this.lock == null) {
                            try {
                                this.channel.close();
                            }
                            finally {
                                this.channel = null;
                            }
                        }
                    }
                }
                finally {
                    if (this.channel == null) {
                        try {
                            this.f.close();
                        }
                        finally {
                            this.f = null;
                        }
                    }
                }
            }
        }
        if (!markedHeld) return this.isLocked();
        if (this.isLocked()) return this.isLocked();
        HashSet hashSet = LOCK_HELD;
        // MONITORENTER : hashSet
        if (LOCK_HELD.contains(canonicalPath)) {
            LOCK_HELD.remove(canonicalPath);
        }
        // MONITOREXIT : hashSet
        return this.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        block40: {
            try {
                if (!this.isLocked()) break block40;
                try {
                    this.lock.release();
                }
                catch (Throwable throwable) {
                    this.lock = null;
                    try {
                        this.channel.close();
                    }
                    catch (Throwable throwable2) {
                        this.channel = null;
                        try {
                            this.f.close();
                        }
                        catch (Throwable throwable3) {
                            this.f = null;
                            HashSet hashSet = LOCK_HELD;
                            synchronized (hashSet) {
                                LOCK_HELD.remove(this.path.getCanonicalPath());
                            }
                            throw throwable3;
                        }
                        this.f = null;
                        HashSet hashSet = LOCK_HELD;
                        synchronized (hashSet) {
                            LOCK_HELD.remove(this.path.getCanonicalPath());
                        }
                        throw throwable2;
                    }
                    this.channel = null;
                    try {
                        this.f.close();
                    }
                    catch (Throwable throwable4) {
                        this.f = null;
                        HashSet hashSet = LOCK_HELD;
                        synchronized (hashSet) {
                            LOCK_HELD.remove(this.path.getCanonicalPath());
                        }
                        throw throwable4;
                    }
                    this.f = null;
                    HashSet hashSet = LOCK_HELD;
                    synchronized (hashSet) {
                        LOCK_HELD.remove(this.path.getCanonicalPath());
                    }
                    throw throwable;
                }
                this.lock = null;
                try {
                    this.channel.close();
                }
                catch (Throwable throwable) {
                    this.channel = null;
                    try {
                        this.f.close();
                    }
                    catch (Throwable throwable5) {
                        this.f = null;
                        HashSet hashSet = LOCK_HELD;
                        synchronized (hashSet) {
                            LOCK_HELD.remove(this.path.getCanonicalPath());
                        }
                        throw throwable5;
                    }
                    this.f = null;
                    HashSet hashSet = LOCK_HELD;
                    synchronized (hashSet) {
                        LOCK_HELD.remove(this.path.getCanonicalPath());
                    }
                    throw throwable;
                }
                this.channel = null;
                try {
                    this.f.close();
                }
                catch (Throwable throwable) {
                    this.f = null;
                    HashSet hashSet = LOCK_HELD;
                    synchronized (hashSet) {
                        LOCK_HELD.remove(this.path.getCanonicalPath());
                    }
                    throw throwable;
                }
                this.f = null;
                HashSet hashSet = LOCK_HELD;
                synchronized (hashSet) {
                    LOCK_HELD.remove(this.path.getCanonicalPath());
                }
                this.path.delete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isLocked() {
        return this.lock != null;
    }

    public String toString() {
        return "NativeFSLock@" + this.path;
    }

    public void finalize() throws Throwable {
        try {
            if (this.isLocked()) {
                this.release();
            }
        }
        finally {
            super.finalize();
        }
    }
}

