/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

public abstract class Directory {
    protected LockFactory lockFactory;

    public abstract String[] list() throws IOException;

    public abstract boolean fileExists(String var1) throws IOException;

    public abstract long fileModified(String var1) throws IOException;

    public abstract void touchFile(String var1) throws IOException;

    public abstract void deleteFile(String var1) throws IOException;

    public abstract void renameFile(String var1, String var2) throws IOException;

    public abstract long fileLength(String var1) throws IOException;

    public abstract IndexOutput createOutput(String var1) throws IOException;

    public abstract IndexInput openInput(String var1) throws IOException;

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return this.openInput(name);
    }

    public Lock makeLock(String name) {
        return this.lockFactory.makeLock(name);
    }

    public void clearLock(String name) throws IOException {
        if (this.lockFactory != null) {
            this.lockFactory.clearLock(name);
        }
    }

    public abstract void close() throws IOException;

    public void setLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
        lockFactory.setLockPrefix(this.getLockID());
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public String getLockID() {
        return this.toString();
    }

    public static void copy(Directory src, Directory dest, boolean closeDirSrc) throws IOException {
        String[] files = src.list();
        if (files == null) {
            throw new IOException("cannot read directory " + src + ": list() returned null");
        }
        byte[] buf = new byte[16384];
        int i = 0;
        while (i < files.length) {
            IndexOutput os = null;
            IndexInput is = null;
            try {
                os = dest.createOutput(files[i]);
                is = src.openInput(files[i]);
                long len = is.length();
                long readCount = 0L;
                while (readCount < len) {
                    int toRead = readCount + 16384L > len ? (int)(len - readCount) : 16384;
                    is.readBytes(buf, 0, toRead);
                    os.writeBytes(buf, toRead);
                    readCount += (long)toRead;
                }
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            ++i;
        }
        if (closeDirSrc) {
            src.close();
        }
    }
}

