/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.ToStringUtils;

public class SpanOrQuery
extends SpanQuery {
    private List clauses;
    private String field;

    public SpanOrQuery(SpanQuery[] clauses) {
        this.clauses = new ArrayList(clauses.length);
        int i = 0;
        while (i < clauses.length) {
            SpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
            ++i;
        }
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        for (SpanQuery clause : this.clauses) {
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    public void extractTerms(Set terms) {
        for (SpanQuery clause : this.clauses) {
            clause.extractTerms(terms);
        }
    }

    public Query rewrite(IndexReader reader) throws IOException {
        SpanOrQuery clone = null;
        int i = 0;
        while (i < this.clauses.size()) {
            SpanQuery c = (SpanQuery)this.clauses.get(i);
            SpanQuery query = (SpanQuery)c.rewrite(reader);
            if (query != c) {
                if (clone == null) {
                    clone = (SpanOrQuery)this.clone();
                }
                clone.clauses.set(i, query);
            }
            ++i;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanOr([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("])");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanOrQuery that = (SpanOrQuery)o;
        if (!this.clauses.equals(that.clauses)) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public int hashCode() {
        int h = this.clauses.hashCode();
        h ^= h << 10 | h >>> 23;
        return h ^= Float.floatToRawIntBits(this.getBoost());
    }

    public Spans getSpans(final IndexReader reader) throws IOException {
        if (this.clauses.size() == 1) {
            return ((SpanQuery)this.clauses.get(0)).getSpans(reader);
        }
        return new Spans(){
            private SpanQueue queue = null;

            private boolean initSpanQueue(int target) throws IOException {
                this.queue = new SpanQueue(SpanOrQuery.this.clauses.size());
                Iterator i = SpanOrQuery.this.clauses.iterator();
                while (i.hasNext()) {
                    Spans spans = ((SpanQuery)i.next()).getSpans(reader);
                    if ((target != -1 || !spans.next()) && (target == -1 || !spans.skipTo(target))) continue;
                    this.queue.put(spans);
                }
                return this.queue.size() != 0;
            }

            public boolean next() throws IOException {
                if (this.queue == null) {
                    return this.initSpanQueue(-1);
                }
                if (this.queue.size() == 0) {
                    return false;
                }
                if (this.top().next()) {
                    this.queue.adjustTop();
                    return true;
                }
                this.queue.pop();
                return this.queue.size() != 0;
            }

            private Spans top() {
                return (Spans)this.queue.top();
            }

            /*
             * Unable to fully structure code
             */
            public boolean skipTo(int target) throws IOException {
                if (this.queue != null) ** GOTO lbl8
                return this.initSpanQueue(target);
lbl-1000:
                // 1 sources

                {
                    if (this.top().skipTo(target)) {
                        this.queue.adjustTop();
                        continue;
                    }
                    this.queue.pop();
lbl8:
                    // 3 sources

                    ** while (this.queue.size() != 0 && this.top().doc() < target)
                }
lbl9:
                // 1 sources

                return this.queue.size() != 0;
            }

            public int doc() {
                return this.top().doc();
            }

            public int start() {
                return this.top().start();
            }

            public int end() {
                return this.top().end();
            }

            public String toString() {
                return "spans(" + SpanOrQuery.this + ")@" + (this.queue == null ? "START" : (this.queue.size() > 0 ? String.valueOf(this.doc()) + ":" + this.start() + "-" + this.end() : "END"));
            }
        };
    }

    private class SpanQueue
    extends PriorityQueue {
        public SpanQueue(int size) {
            this.initialize(size);
        }

        protected final boolean lessThan(Object o1, Object o2) {
            Spans spans1 = (Spans)o1;
            Spans spans2 = (Spans)o2;
            if (spans1.doc() == spans2.doc()) {
                if (spans1.start() == spans2.start()) {
                    return spans1.end() < spans2.end();
                }
                return spans1.start() < spans2.start();
            }
            return spans1.doc() < spans2.doc();
        }
    }
}

