/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

class NearSpansOrdered
implements Spans {
    private final int allowedSlop;
    private boolean firstTime = true;
    private boolean more = false;
    private final Spans[] subSpans;
    private boolean inSameDoc = false;
    private int matchDoc = -1;
    private int matchStart = -1;
    private int matchEnd = -1;
    private final Spans[] subSpansByDoc;
    private final Comparator spanDocComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Spans)o1).doc() - ((Spans)o2).doc();
        }
    };
    private SpanNearQuery query;

    public NearSpansOrdered(SpanNearQuery spanNearQuery, IndexReader reader) throws IOException {
        if (spanNearQuery.getClauses().length < 2) {
            throw new IllegalArgumentException("Less than 2 clauses: " + spanNearQuery);
        }
        this.allowedSlop = spanNearQuery.getSlop();
        SpanQuery[] clauses = spanNearQuery.getClauses();
        this.subSpans = new Spans[clauses.length];
        this.subSpansByDoc = new Spans[clauses.length];
        int i = 0;
        while (i < clauses.length) {
            this.subSpans[i] = clauses[i].getSpans(reader);
            this.subSpansByDoc[i] = this.subSpans[i];
            ++i;
        }
        this.query = spanNearQuery;
    }

    public int doc() {
        return this.matchDoc;
    }

    public int start() {
        return this.matchStart;
    }

    public int end() {
        return this.matchEnd;
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.firstTime = false;
            int i = 0;
            while (i < this.subSpans.length) {
                if (!this.subSpans[i].next()) {
                    this.more = false;
                    return false;
                }
                ++i;
            }
            this.more = true;
        }
        return this.advanceAfterOrdered();
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime) {
            this.firstTime = false;
            int i = 0;
            while (i < this.subSpans.length) {
                if (!this.subSpans[i].skipTo(target)) {
                    this.more = false;
                    return false;
                }
                ++i;
            }
            this.more = true;
        } else if (this.more && this.subSpans[0].doc() < target) {
            if (this.subSpans[0].skipTo(target)) {
                this.inSameDoc = false;
            } else {
                this.more = false;
                return false;
            }
        }
        return this.advanceAfterOrdered();
    }

    private boolean advanceAfterOrdered() throws IOException {
        while (this.more && (this.inSameDoc || this.toSameDoc())) {
            if (!this.stretchToOrder() || !this.shrinkToAfterShortestMatch()) continue;
            return true;
        }
        return false;
    }

    private boolean toSameDoc() throws IOException {
        Arrays.sort(this.subSpansByDoc, this.spanDocComparator);
        int firstIndex = 0;
        int maxDoc = this.subSpansByDoc[this.subSpansByDoc.length - 1].doc();
        while (this.subSpansByDoc[firstIndex].doc() != maxDoc) {
            if (!this.subSpansByDoc[firstIndex].skipTo(maxDoc)) {
                this.more = false;
                this.inSameDoc = false;
                return false;
            }
            maxDoc = this.subSpansByDoc[firstIndex].doc();
            if (++firstIndex != this.subSpansByDoc.length) continue;
            firstIndex = 0;
        }
        int i = 0;
        while (i < this.subSpansByDoc.length) {
            assert (this.subSpansByDoc[i].doc() == maxDoc) : " NearSpansOrdered.toSameDoc() spans " + this.subSpansByDoc[0] + "\n at doc " + this.subSpansByDoc[i].doc() + ", but should be at " + maxDoc;
            ++i;
        }
        this.inSameDoc = true;
        return true;
    }

    static final boolean docSpansOrdered(Spans spans1, Spans spans2) {
        int start2;
        assert (spans1.doc() == spans2.doc()) : "doc1 " + spans1.doc() + " != doc2 " + spans2.doc();
        int start1 = spans1.start();
        return start1 == (start2 = spans2.start()) ? spans1.end() < spans2.end() : start1 < start2;
    }

    private static final boolean docSpansOrdered(int start1, int end1, int start2, int end2) {
        return start1 == start2 ? end1 < end2 : start1 < start2;
    }

    /*
     * Unable to fully structure code
     */
    private boolean stretchToOrder() throws IOException {
        this.matchDoc = this.subSpans[0].doc();
        i = 1;
        ** GOTO lbl16
        {
            block3: {
                block2: {
                    if (this.subSpans[i].next()) break block2;
                    this.inSameDoc = false;
                    this.more = false;
                    ** GOTO lbl15
                }
                if (this.matchDoc == this.subSpans[i].doc()) break block3;
                this.inSameDoc = false;
                ** GOTO lbl15
            }
            do {
                if (!NearSpansOrdered.docSpansOrdered(this.subSpans[i - 1], this.subSpans[i])) continue block0;
lbl15:
                // 3 sources

                ++i;
lbl16:
                // 2 sources

            } while (this.inSameDoc && i < this.subSpans.length);
        }
        return this.inSameDoc;
    }

    private boolean shrinkToAfterShortestMatch() throws IOException {
        this.matchStart = this.subSpans[this.subSpans.length - 1].start();
        this.matchEnd = this.subSpans[this.subSpans.length - 1].end();
        int matchSlop = 0;
        int lastStart = this.matchStart;
        int lastEnd = this.matchEnd;
        int i = this.subSpans.length - 2;
        while (i >= 0) {
            Spans prevSpans = this.subSpans[i];
            int prevStart = prevSpans.start();
            int prevEnd = prevSpans.end();
            while (true) {
                int ppEnd;
                if (!prevSpans.next()) {
                    this.inSameDoc = false;
                    this.more = false;
                    break;
                }
                if (this.matchDoc != prevSpans.doc()) {
                    this.inSameDoc = false;
                    break;
                }
                int ppStart = prevSpans.start();
                if (!NearSpansOrdered.docSpansOrdered(ppStart, ppEnd = prevSpans.end(), lastStart, lastEnd)) break;
                prevStart = ppStart;
                prevEnd = ppEnd;
            }
            assert (prevStart <= this.matchStart);
            if (this.matchStart > prevEnd) {
                matchSlop += this.matchStart - prevEnd;
            }
            this.matchStart = prevStart;
            lastStart = prevStart;
            lastEnd = prevEnd;
            --i;
        }
        return matchSlop <= this.allowedSlop;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.query.toString() + ")@" + (this.firstTime ? "START" : (this.more ? String.valueOf(this.doc()) + ":" + this.start() + "-" + this.end() : "END"));
    }
}

