/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldSortedHitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;

public class TopFieldDocCollector
extends TopDocCollector {
    public TopFieldDocCollector(IndexReader reader, Sort sort, int numHits) throws IOException {
        super(numHits, new FieldSortedHitQueue(reader, sort.fields, numHits));
    }

    public void collect(int doc, float score) {
        if (score > 0.0f) {
            ++this.totalHits;
            this.hq.insert(new FieldDoc(doc, score));
        }
    }

    public TopDocs topDocs() {
        FieldSortedHitQueue fshq = (FieldSortedHitQueue)this.hq;
        ScoreDoc[] scoreDocs = new ScoreDoc[fshq.size()];
        int i = fshq.size() - 1;
        while (i >= 0) {
            scoreDocs[i] = fshq.fillFields((FieldDoc)fshq.pop());
            --i;
        }
        return new TopFieldDocs(this.totalHits, scoreDocs, fshq.getFields(), fshq.getMaxScore());
    }
}

