/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.util.SmallFloat;

public abstract class Similarity
implements Serializable {
    private static Similarity defaultImpl = new DefaultSimilarity();
    private static final float[] NORM_TABLE = new float[256];

    static {
        int i = 0;
        while (i < 256) {
            Similarity.NORM_TABLE[i] = SmallFloat.byte315ToFloat((byte)i);
            ++i;
        }
    }

    public static void setDefault(Similarity similarity) {
        defaultImpl = similarity;
    }

    public static Similarity getDefault() {
        return defaultImpl;
    }

    public static float decodeNorm(byte b) {
        return NORM_TABLE[b & 0xFF];
    }

    public static float[] getNormDecoder() {
        return NORM_TABLE;
    }

    public abstract float lengthNorm(String var1, int var2);

    public abstract float queryNorm(float var1);

    public static byte encodeNorm(float f) {
        return SmallFloat.floatToByte315(f);
    }

    public float tf(int freq) {
        return this.tf((float)freq);
    }

    public abstract float sloppyFreq(int var1);

    public abstract float tf(float var1);

    public float idf(Term term, Searcher searcher) throws IOException {
        return this.idf(searcher.docFreq(term), searcher.maxDoc());
    }

    public float idf(Collection terms, Searcher searcher) throws IOException {
        float idf = 0.0f;
        Iterator i = terms.iterator();
        while (i.hasNext()) {
            idf += this.idf((Term)i.next(), searcher);
        }
        return idf;
    }

    public abstract float idf(int var1, int var2);

    public abstract float coord(int var1, int var2);

    public float scorePayload(byte[] payload, int offset, int length) {
        return 1.0f;
    }
}

