/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQueue;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

abstract class PhraseScorer
extends Scorer {
    private Weight weight;
    protected byte[] norms;
    protected float value;
    private boolean firstTime = true;
    private boolean more = true;
    protected PhraseQueue pq;
    protected PhrasePositions first;
    protected PhrasePositions last;
    private float freq;

    PhraseScorer(Weight weight, TermPositions[] tps, int[] offsets, Similarity similarity, byte[] norms) {
        super(similarity);
        this.norms = norms;
        this.weight = weight;
        this.value = weight.getValue();
        int i = 0;
        while (i < tps.length) {
            PhrasePositions pp = new PhrasePositions(tps[i], offsets[i]);
            if (this.last != null) {
                this.last.next = pp;
            } else {
                this.first = pp;
            }
            this.last = pp;
            ++i;
        }
        this.pq = new PhraseQueue(tps.length);
    }

    public int doc() {
        return this.first.doc;
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.init();
            this.firstTime = false;
        } else if (this.more) {
            this.more = this.last.next();
        }
        return this.doNext();
    }

    /*
     * Unable to fully structure code
     */
    private boolean doNext() throws IOException {
        ** GOTO lbl12
        {
            this.more = this.first.skipTo(this.last.doc);
            this.firstToLast();
            do {
                if (this.more && this.first.doc < this.last.doc) continue block0;
                if (!this.more) continue;
                this.freq = this.phraseFreq();
                if (this.freq == 0.0f) {
                    this.more = this.last.next();
                    continue;
                }
                return true;
lbl12:
                // 3 sources

            } while (this.more);
        }
        return false;
    }

    public float score() throws IOException {
        float raw = this.getSimilarity().tf(this.freq) * this.value;
        return raw * Similarity.decodeNorm(this.norms[this.first.doc]);
    }

    public boolean skipTo(int target) throws IOException {
        this.firstTime = false;
        PhrasePositions pp = this.first;
        while (this.more && pp != null) {
            this.more = pp.skipTo(target);
            pp = pp.next;
        }
        if (this.more) {
            this.sort();
        }
        return this.doNext();
    }

    protected abstract float phraseFreq() throws IOException;

    private void init() throws IOException {
        PhrasePositions pp = this.first;
        while (this.more && pp != null) {
            this.more = pp.next();
            pp = pp.next;
        }
        if (this.more) {
            this.sort();
        }
    }

    private void sort() {
        this.pq.clear();
        PhrasePositions pp = this.first;
        while (pp != null) {
            this.pq.put(pp);
            pp = pp.next;
        }
        this.pqToList();
    }

    protected final void pqToList() {
        this.first = null;
        this.last = null;
        while (this.pq.top() != null) {
            PhrasePositions pp = (PhrasePositions)this.pq.pop();
            if (this.last != null) {
                this.last.next = pp;
            } else {
                this.first = pp;
            }
            this.last = pp;
            pp.next = null;
        }
    }

    protected final void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        while (this.next() && this.doc() < doc) {
        }
        float phraseFreq = this.doc() == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

