/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.PriorityQueue;

public class MultiSearcher
extends Searcher {
    private Searchable[] searchables;
    private int[] starts;
    private int maxDoc = 0;

    public MultiSearcher(Searchable[] searchables) throws IOException {
        this.searchables = searchables;
        this.starts = new int[searchables.length + 1];
        int i = 0;
        while (i < searchables.length) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += searchables[i].maxDoc();
            ++i;
        }
        this.starts[searchables.length] = this.maxDoc;
    }

    public Searchable[] getSearchables() {
        return this.searchables;
    }

    protected int[] getStarts() {
        return this.starts;
    }

    public void close() throws IOException {
        int i = 0;
        while (i < this.searchables.length) {
            this.searchables[i].close();
            ++i;
        }
    }

    public int docFreq(Term term) throws IOException {
        int docFreq = 0;
        int i = 0;
        while (i < this.searchables.length) {
            docFreq += this.searchables[i].docFreq(term);
            ++i;
        }
        return docFreq;
    }

    public Document doc(int n) throws CorruptIndexException, IOException {
        int i = this.subSearcher(n);
        return this.searchables[i].doc(n - this.starts[i]);
    }

    public Document doc(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        int i = this.subSearcher(n);
        return this.searchables[i].doc(n - this.starts[i], fieldSelector);
    }

    /*
     * Unable to fully structure code
     */
    public int subSearcher(int n) {
        lo = 0;
        hi = this.searchables.length - 1;
        while (hi >= lo) {
            mid = lo + hi >> 1;
            midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n <= midValue) ** GOTO lbl13
            lo = mid + 1;
            continue;
lbl-1000:
            // 1 sources

            {
                ++mid;
lbl13:
                // 2 sources

                ** while (mid + 1 < this.searchables.length && this.starts[mid + 1] == midValue)
            }
lbl14:
            // 1 sources

            return mid;
        }
        return hi;
    }

    public int subDoc(int n) {
        return n - this.starts[this.subSearcher(n)];
    }

    public int maxDoc() throws IOException {
        return this.maxDoc;
    }

    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        HitQueue hq = new HitQueue(nDocs);
        int totalHits = 0;
        int i = 0;
        while (i < this.searchables.length) {
            TopDocs docs = this.searchables[i].search(weight, filter, nDocs);
            totalHits += docs.totalHits;
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            int j = 0;
            while (j < scoreDocs.length) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[i];
                if (!hq.insert(scoreDoc)) break;
                ++j;
            }
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        float maxScore = totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        PriorityQueue hq = null;
        int totalHits = 0;
        float maxScore = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.searchables.length) {
            TopFieldDocs docs = this.searchables[i].search(weight, filter, n, sort);
            if (hq == null) {
                hq = new FieldDocSortedHitQueue(docs.fields, n);
            }
            totalHits += docs.totalHits;
            maxScore = Math.max(maxScore, docs.getMaxScore());
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            int j = 0;
            while (j < scoreDocs.length) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[i];
                if (!hq.insert(scoreDoc)) break;
                ++j;
            }
            ++i;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i2 = hq.size() - 1;
        while (i2 >= 0) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
            --i2;
        }
        return new TopFieldDocs(totalHits, scoreDocs, ((FieldDocSortedHitQueue)hq).getFields(), maxScore);
    }

    public void search(Weight weight, Filter filter, final HitCollector results) throws IOException {
        int i = 0;
        while (i < this.searchables.length) {
            final int start = this.starts[i];
            this.searchables[i].search(weight, filter, new HitCollector(){

                public void collect(int doc, float score) {
                    results.collect(doc + start, score);
                }
            });
            ++i;
        }
    }

    public Query rewrite(Query original) throws IOException {
        Query[] queries = new Query[this.searchables.length];
        int i = 0;
        while (i < this.searchables.length) {
            queries[i] = this.searchables[i].rewrite(original);
            ++i;
        }
        return queries[0].combine(queries);
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        int i = this.subSearcher(doc);
        return this.searchables[i].explain(weight, doc - this.starts[i]);
    }

    protected Weight createWeight(Query original) throws IOException {
        Query rewrittenQuery = this.rewrite(original);
        HashSet terms = new HashSet();
        rewrittenQuery.extractTerms(terms);
        Term[] allTermsArray = new Term[terms.size()];
        terms.toArray(allTermsArray);
        int[] aggregatedDfs = new int[terms.size()];
        int i = 0;
        while (i < this.searchables.length) {
            int[] dfs = this.searchables[i].docFreqs(allTermsArray);
            int j = 0;
            while (j < aggregatedDfs.length) {
                int n = j;
                aggregatedDfs[n] = aggregatedDfs[n] + dfs[j];
                ++j;
            }
            ++i;
        }
        HashMap<Term, Integer> dfMap = new HashMap<Term, Integer>();
        int i2 = 0;
        while (i2 < allTermsArray.length) {
            dfMap.put(allTermsArray[i2], new Integer(aggregatedDfs[i2]));
            ++i2;
        }
        int numDocs = this.maxDoc();
        CachedDfSource cacheSim = new CachedDfSource(dfMap, numDocs, this.getSimilarity());
        return rewrittenQuery.weight(cacheSim);
    }

    private static class CachedDfSource
    extends Searcher {
        private Map dfMap;
        private int maxDoc;

        public CachedDfSource(Map dfMap, int maxDoc, Similarity similarity) {
            this.dfMap = dfMap;
            this.maxDoc = maxDoc;
            this.setSimilarity(similarity);
        }

        public int docFreq(Term term) {
            int df;
            try {
                df = (Integer)this.dfMap.get(term);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("df for term " + term.text() + " not available");
            }
            return df;
        }

        public int[] docFreqs(Term[] terms) {
            int[] result = new int[terms.length];
            int i = 0;
            while (i < terms.length) {
                result[i] = this.docFreq(terms[i]);
                ++i;
            }
            return result;
        }

        public int maxDoc() {
            return this.maxDoc;
        }

        public Query rewrite(Query query) {
            return query;
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public Document doc(int i) {
            throw new UnsupportedOperationException();
        }

        public Document doc(int i, FieldSelector fieldSelector) {
            throw new UnsupportedOperationException();
        }

        public Explanation explain(Weight weight, int doc) {
            throw new UnsupportedOperationException();
        }

        public void search(Weight weight, Filter filter, HitCollector results) {
            throw new UnsupportedOperationException();
        }

        public TopDocs search(Weight weight, Filter filter, int n) {
            throw new UnsupportedOperationException();
        }

        public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) {
            throw new UnsupportedOperationException();
        }
    }
}

