/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.FuzzyTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.ToStringUtils;

public class FuzzyQuery
extends MultiTermQuery {
    public static final float defaultMinSimilarity = 0.5f;
    public static final int defaultPrefixLength = 0;
    private float minimumSimilarity;
    private int prefixLength;

    public FuzzyQuery(Term term, float minimumSimilarity, int prefixLength) throws IllegalArgumentException {
        super(term);
        if (minimumSimilarity >= 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity >= 1");
        }
        if (minimumSimilarity < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity < 0");
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength < 0");
        }
        this.minimumSimilarity = minimumSimilarity;
        this.prefixLength = prefixLength;
    }

    public FuzzyQuery(Term term, float minimumSimilarity) throws IllegalArgumentException {
        this(term, minimumSimilarity, 0);
    }

    public FuzzyQuery(Term term) {
        this(term, 0.5f, 0);
    }

    public float getMinSimilarity() {
        return this.minimumSimilarity;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new FuzzyTermEnum(reader, this.getTerm(), this.minimumSimilarity, this.prefixLength);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        FilteredTermEnum enumerator = this.getEnum(reader);
        int maxClauseCount = BooleanQuery.getMaxClauseCount();
        ScoreTermQueue stQueue = new ScoreTermQueue(maxClauseCount);
        try {
            do {
                float minScore = 0.0f;
                float score = 0.0f;
                Term t = enumerator.term();
                if (t == null) continue;
                score = enumerator.difference();
                if (stQueue.size() >= maxClauseCount && !(score > minScore)) continue;
                stQueue.insert(new ScoreTerm(t, score));
                minScore = ((ScoreTerm)stQueue.top()).score;
            } while (enumerator.next());
        }
        finally {
            enumerator.close();
        }
        BooleanQuery query = new BooleanQuery(true);
        int size = stQueue.size();
        int i = 0;
        while (i < size) {
            ScoreTerm st = (ScoreTerm)stQueue.pop();
            TermQuery tq = new TermQuery(st.term);
            tq.setBoost(this.getBoost() * st.score);
            query.add(tq, BooleanClause.Occur.SHOULD);
            ++i;
        }
        return query;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        Term term = this.getTerm();
        if (!term.field().equals(field)) {
            buffer.append(term.field());
            buffer.append(":");
        }
        buffer.append(term.text());
        buffer.append('~');
        buffer.append(Float.toString(this.minimumSimilarity));
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FuzzyQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FuzzyQuery fuzzyQuery = (FuzzyQuery)o;
        if (this.minimumSimilarity != fuzzyQuery.minimumSimilarity) {
            return false;
        }
        return this.prefixLength == fuzzyQuery.prefixLength;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = (float)(29 * result) + this.minimumSimilarity != 0.0f ? Float.floatToIntBits(this.minimumSimilarity) : 0;
        result = 29 * result + this.prefixLength;
        return result;
    }

    protected static class ScoreTerm {
        public Term term;
        public float score;

        public ScoreTerm(Term term, float score) {
            this.term = term;
            this.score = score;
        }
    }

    protected static class ScoreTermQueue
    extends PriorityQueue {
        public ScoreTermQueue(int size) {
            this.initialize(size);
        }

        protected boolean lessThan(Object a, Object b) {
            ScoreTerm termA = (ScoreTerm)a;
            ScoreTerm termB = (ScoreTerm)b;
            if (termA.score == termB.score) {
                return termA.term.compareTo(termB.term) > 0;
            }
            return termA.score < termB.score;
        }
    }
}

