/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.SortComparator;

class FieldCacheImpl
implements FieldCache {
    private static final FieldCache.ByteParser BYTE_PARSER = new FieldCache.ByteParser(){

        public byte parseByte(String value) {
            return Byte.parseByte(value);
        }
    };
    private static final FieldCache.ShortParser SHORT_PARSER = new FieldCache.ShortParser(){

        public short parseShort(String value) {
            return Short.parseShort(value);
        }
    };
    private static final FieldCache.IntParser INT_PARSER = new FieldCache.IntParser(){

        public int parseInt(String value) {
            return Integer.parseInt(value);
        }
    };
    private static final FieldCache.FloatParser FLOAT_PARSER = new FieldCache.FloatParser(){

        public float parseFloat(String value) {
            return Float.parseFloat(value);
        }
    };
    Cache bytesCache = new Cache(){

        protected Object createValue(IndexReader reader, Object entryKey) throws IOException {
            Entry entry = (Entry)entryKey;
            String field = entry.field;
            FieldCache.ByteParser parser = (FieldCache.ByteParser)entry.custom;
            byte[] retArray = new byte[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        byte termval = parser.parseByte(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    };
    Cache shortsCache = new Cache(){

        protected Object createValue(IndexReader reader, Object entryKey) throws IOException {
            Entry entry = (Entry)entryKey;
            String field = entry.field;
            FieldCache.ShortParser parser = (FieldCache.ShortParser)entry.custom;
            short[] retArray = new short[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        short termval = parser.parseShort(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    };
    Cache intsCache = new Cache(){

        protected Object createValue(IndexReader reader, Object entryKey) throws IOException {
            Entry entry = (Entry)entryKey;
            String field = entry.field;
            FieldCache.IntParser parser = (FieldCache.IntParser)entry.custom;
            int[] retArray = new int[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        int termval = parser.parseInt(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    };
    Cache floatsCache = new Cache(){

        protected Object createValue(IndexReader reader, Object entryKey) throws IOException {
            Entry entry = (Entry)entryKey;
            String field = entry.field;
            FieldCache.FloatParser parser = (FieldCache.FloatParser)entry.custom;
            float[] retArray = new float[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        float termval = parser.parseFloat(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    };
    Cache stringsCache = new Cache(){

        protected Object createValue(IndexReader reader, Object fieldKey) throws IOException {
            String field = ((String)fieldKey).intern();
            String[] retArray = new String[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        String termval = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    };
    Cache stringsIndexCache = new Cache(){

        protected Object createValue(IndexReader reader, Object fieldKey) throws IOException {
            String field = ((String)fieldKey).intern();
            int[] retArray = new int[reader.maxDoc()];
            String[] mterms = new String[reader.maxDoc() + 1];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            int t = 0;
            mterms[t++] = null;
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        if (t >= mterms.length) {
                            throw new RuntimeException("there are more terms than documents in field \"" + field + "\", but it's impossible to sort on " + "tokenized fields");
                        }
                        mterms[t] = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = t;
                        }
                        ++t;
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            if (t == 0) {
                mterms = new String[1];
            } else if (t < mterms.length) {
                String[] terms = new String[t];
                System.arraycopy(mterms, 0, terms, 0, t);
                mterms = terms;
            }
            FieldCache.StringIndex value = new FieldCache.StringIndex(retArray, mterms);
            return value;
        }
    };
    Cache autoCache = new Cache(){

        protected Object createValue(IndexReader reader, Object fieldKey) throws IOException {
            String field = ((String)fieldKey).intern();
            TermEnum enumerator = reader.terms(new Term(field, ""));
            try {
                Term term = enumerator.term();
                if (term == null) {
                    throw new RuntimeException("no terms in field " + field + " - cannot determine sort type");
                }
                Object ret = null;
                if (term.field() == field) {
                    String termtext = term.text().trim();
                    try {
                        Integer.parseInt(termtext);
                        ret = FieldCacheImpl.this.getInts(reader, field);
                    }
                    catch (NumberFormatException nfe1) {
                        try {
                            Float.parseFloat(termtext);
                            ret = FieldCacheImpl.this.getFloats(reader, field);
                        }
                        catch (NumberFormatException nfe2) {
                            ret = FieldCacheImpl.this.getStringIndex(reader, field);
                        }
                    }
                } else {
                    throw new RuntimeException("field \"" + field + "\" does not appear to be indexed");
                }
                int[] nArray = ret;
                return nArray;
            }
            finally {
                enumerator.close();
            }
        }
    };
    Cache customCache = new Cache(){

        protected Object createValue(IndexReader reader, Object entryKey) throws IOException {
            Entry entry = (Entry)entryKey;
            String field = entry.field;
            SortComparator comparator = (SortComparator)entry.custom;
            Comparable[] retArray = new Comparable[reader.maxDoc()];
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field, ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        Comparable termval = comparator.getComparable(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            retArray[termDocs.doc()] = termval;
                        }
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
            return retArray;
        }
    };

    FieldCacheImpl() {
    }

    public byte[] getBytes(IndexReader reader, String field) throws IOException {
        return this.getBytes(reader, field, BYTE_PARSER);
    }

    public byte[] getBytes(IndexReader reader, String field, FieldCache.ByteParser parser) throws IOException {
        return (byte[])this.bytesCache.get(reader, new Entry(field, parser));
    }

    public short[] getShorts(IndexReader reader, String field) throws IOException {
        return this.getShorts(reader, field, SHORT_PARSER);
    }

    public short[] getShorts(IndexReader reader, String field, FieldCache.ShortParser parser) throws IOException {
        return (short[])this.shortsCache.get(reader, new Entry(field, parser));
    }

    public int[] getInts(IndexReader reader, String field) throws IOException {
        return this.getInts(reader, field, INT_PARSER);
    }

    public int[] getInts(IndexReader reader, String field, FieldCache.IntParser parser) throws IOException {
        return (int[])this.intsCache.get(reader, new Entry(field, parser));
    }

    public float[] getFloats(IndexReader reader, String field) throws IOException {
        return this.getFloats(reader, field, FLOAT_PARSER);
    }

    public float[] getFloats(IndexReader reader, String field, FieldCache.FloatParser parser) throws IOException {
        return (float[])this.floatsCache.get(reader, new Entry(field, parser));
    }

    public String[] getStrings(IndexReader reader, String field) throws IOException {
        return (String[])this.stringsCache.get(reader, field);
    }

    public FieldCache.StringIndex getStringIndex(IndexReader reader, String field) throws IOException {
        return (FieldCache.StringIndex)this.stringsIndexCache.get(reader, field);
    }

    public Object getAuto(IndexReader reader, String field) throws IOException {
        return this.autoCache.get(reader, field);
    }

    public Comparable[] getCustom(IndexReader reader, String field, SortComparator comparator) throws IOException {
        return (Comparable[])this.customCache.get(reader, new Entry(field, comparator));
    }

    static abstract class Cache {
        private final Map readerCache = new WeakHashMap();

        Cache() {
        }

        protected abstract Object createValue(IndexReader var1, Object var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(IndexReader reader, Object key) throws IOException {
            Object value;
            HashMap<Object, Object> innerCache;
            Object object = this.readerCache;
            synchronized (object) {
                innerCache = (HashMap<Object, Object>)this.readerCache.get(reader);
                if (innerCache == null) {
                    innerCache = new HashMap<Object, Object>();
                    this.readerCache.put(reader, innerCache);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof CreationPlaceholder) {
                object = value;
                synchronized (object) {
                    CreationPlaceholder progress = (CreationPlaceholder)value;
                    if (progress.value == null) {
                        progress.value = this.createValue(reader, key);
                        Map map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }
    }

    static final class CreationPlaceholder {
        Object value;

        CreationPlaceholder() {
        }
    }

    static class Entry {
        final String field;
        final int type;
        final Object custom;
        final Locale locale;

        Entry(String field, int type, Locale locale) {
            this.field = field.intern();
            this.type = type;
            this.custom = null;
            this.locale = locale;
        }

        Entry(String field, Object custom) {
            this.field = field.intern();
            this.type = 9;
            this.custom = custom;
            this.locale = null;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry other = (Entry)o;
                if (other.field == this.field && other.type == this.type && (other.locale == null ? this.locale == null : other.locale.equals(this.locale)) && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.type ^ (this.custom == null ? 0 : this.custom.hashCode()) ^ (this.locale == null ? 0 : this.locale.hashCode());
        }
    }
}

